package jp.co.sra.smalltalk;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

/**
 * StDisplayable interface
 * 
 *  @author    nisinaka
 *  @created   2002/11/21 (by nisinaka)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StDisplayable.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public interface StDisplayable {
	/**
	 * Answer the receiver as <code>StImage</code>.
	 *
	 * @return jp.co.sra.smalltalk.StImage
	 * @category converting
	 */
	public StImage asImage();

	/**
	 * Answer the bounding box of the receiver.
	 *
	 * @return java.awt.Rectangle
	 * @category bounds accessing
	 */
	public Rectangle bounds();

	/**
	 * Display the receiver on the graphics.
	 *
	 * @param aGraphics java.awt.Graphics
	 * @category displaying
	 */
	public void displayOn_(Graphics aGraphics);

	/**
	 * Display the receiver on the graphics at the specified point.
	 *
	 * @param aGraphics java.awt.Graphics
	 * @param aPoint java.awt.Point
	 * @category displaying
	 */
	public void displayOn_at_(Graphics aGraphics, Point aPoint);
}