package jp.co.sra.smalltalk;

/**
 * StComputedValue class
 * 
 *  @author    nisinaka
 *  @created   1998/10/15 (by nisinaka)
 *  @updated   2006/04/18 (by nisinaka)
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StComputedValue.java,v 8.10 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StComputedValue extends StValueModel {

	/** A unique object which represents an unassigned value. */
	protected static final Object UnassignedValue = new Object();

	/** A cached value of the computation result. */
	protected Object cachedValue;

	/** A flag whether to wait until the receiver is asked to perform the computation. */
	protected boolean eagerEvaluation;

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StValueModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		cachedValue = UnassignedValue;
		eagerEvaluation = true;
	}

	/**
	 * Break the dependency links from any parts of myself to myself.
	 * 
	 * @see jp.co.sra.smalltalk.StValueModel#releaseParts()
	 * @category initialize-release
	 */
	public void releaseParts() {
		StBlockValued[] parts = this.parts();
		for (int i = 0; i < parts.length; i++) {
			parts[i].removeDependentListener(this);
		}
	}

	/**
	 * Answer the cached value for the receiver.
	 * 
	 * @return java.lang.Object
	 * @see jp.co.sra.smalltalk.StValueModel#value()
	 * @category accessing
	 */
	public Object value() {
		if (cachedValue == UnassignedValue) {
			cachedValue = this.computeValue();
		}
		return cachedValue;
	}

	/**
	 * Set the currently stored value, and notify dependents.
	 * 
	 * @param newValue java.lang.Object
	 * @see jp.co.sra.smalltalk.StValueModel#value_(java.lang.Object)
	 * @category accessing
	 */
	public void value_(Object newValue) {
		throw SmalltalkException.ShouldNotImplement();
	}

	/**
	 * If aBoolean is true the receiver will do late evaluation of its computation;
	 * othewise the receiver will do eager computation.
	 * 
	 * @param aBoolean boolean
	 * @category accessing
	 */
	public void eagerEvaluation_(boolean aBoolean) {
		eagerEvaluation = aBoolean;
	}

	/**
	 * Answer a collection of objects that have the receiver as a dependent.
	 * 
	 * @return jp.co.sra.smalltalk.StBlockValued[]
	 * @category accessing
	 */
	public StBlockValued[] parts() {
		throw SmalltalkException.SubclassResponsibility();
	}

	/**
	 * If a model is propagating a change,
	 * then reset the receiver and propagate the change to my dependents.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.StObject#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		this.resetValue();
	}

	/**
	 * Compute a value for the receiver.
	 * 
	 * @return java.lang.Object
	 * @category private
	 */
	public Object computeValue() {
		throw SmalltalkException.SubclassResponsibility();
	}

	/**
	 * Set the receiver's value to unknown. Propagate the change to my dependents.
	 * 
	 * @category private
	 */
	protected void resetValue() {
		if (eagerEvaluation) {
			cachedValue = this.computeValue();
		} else {
			cachedValue = UnassignedValue;
		}
		this.changed_($("value"));
	}

}
