package jp.co.sra.smalltalk;

import java.lang.reflect.Method;

/**
 * StBlockClosure class
 * 
 *  @author    He Weijie
 *  @created   1998/08/06 (by He Weijie)
 *  @updated   N/A
 *  @version   8.9
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: StBlockClosure.java,v 8.11 2008/02/20 06:33:18 nisinaka Exp $
 */
public class StBlockClosure extends StObject implements StValued {

	/**
	 * Just return the number of arguments.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int numArgs() {
		Class myClass = this.getClass();
		if (myClass == StBlockClosure.class) {
			return 0;
		}

		Method[] myMethods = myClass.getDeclaredMethods();
		for (int i = 0; i < myMethods.length; i++) {
			String name = myMethods[i].getName();
			if ("value".equals(name)) {
				return 0;
			} else if ("value_".equals(name)) {
				return 1;
			} else if ("value_value_".equals(name)) {
				return 2;
			} else if ("value_value_value_".equals(name)) {
				return 3;
			} else if ("valueWithArguments_".equals(name)) {
				return 4;
			}
		}

		throw new SmalltalkException("Unexpected name of the method");
	}

	/**
	 * This is a abstract method for value
	 * 
	 * @return java.lang.Object
	 * @see jp.co.sra.smalltalk.StValued#value()
	 * @category evaluating
	 */
	public Object value() {
		return null;
	}

	/**
	 * This is a abstract method for value:
	 * 
	 * @param argument java.lang.Object
	 * @return java.lang.Object
	 * @category evaluating
	 */
	public Object value_(Object argument) {
		return null;
	}

	/**
	 * This is a abstract method for value: value:
	 * 
	 * @param argument1 java.lang.Object
	 * @param argument2 java.lang.Object
	 * @return java.lang.Object
	 * @category evaluating
	 */
	public Object value_value_(Object argument1, Object argument2) {
		return null;
	}

	/**
	 * This is a abstract method for value: value: value:
	 * 
	 * @param argument1 java.lang.Object
	 * @param argument2 java.lang.Object
	 * @param argument3 java.lang.Object
	 * @return java.lang.Object
	 * @category evaluating
	 */
	public Object value_value_value_(Object argument1, Object argument2, Object argument3) {
		return null;
	}

	/**
	 * This is a abstract method for valueWithArguments:
	 * 
	 * @param anArray java.lang.Object[]
	 * @return java.lang.Object
	 * @throws jp.co.sra.smalltalk.SmalltalkException
	 * @category evaluating
	 */
	public Object valueWithArguments_(Object[] anArray) {
		if (anArray == null) {
			return null;
		}

		switch (anArray.length) {
			case 0:
				return this.value();
			case 1:
				return this.value_(anArray[0]);
			case 2:
				return this.value_value_(anArray[0], anArray[1]);
			case 3:
				return this.value_value_value_(anArray[0], anArray[1], anArray[2]);
		}

		throw new SmalltalkException("The method 'valueWithArguments_(Object[])' should be overrided.");
	}

}
