package jp.co.sra.qt4jun;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

/**
 * JunQTNativePort class
 * 
 *  @author    Hoshi Takanori
 *  @created   2005/01/19 (by Hoshi Takanori)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunQTNativePort.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunQTNativePort implements JunQTPort {
	private Component mv;

	private int viewPtr;
	private int grafPtr;

	/**
	 * get the movie interface.
	 *
	 * @return jp.co.sra.qt4jun.JunMovieInterface
	 * @category Private
	 */
	static JunQTInterface _interface() {
		return JunQTInterface.Interface();
	}

	/**
	 * constructor.
	 *
	 * @param mv java.awt.Component
	 * @category Instance creation
	 */
	public JunQTNativePort(Component mv) {
		this.mv = mv;
	}

	/**
	 * finalize.
	 *
	 * @category initialize-release
	 */
	protected void finalize() {
		this.destroyPortAssociation();
	}

	/**
	 * create port association 1.
	 *
	 * @category initialize-release
	 */
	public void createPortAssociation1() {
		if (viewPtr == 0) {
			viewPtr = this._interface().createPortAssociation1(mv);
		}
	}

	/**
	 * create port association 2.
	 *
	 * @category initialize-release
	 */
	public void createPortAssociation2() {
		if (viewPtr != 0 && grafPtr == 0) {
			grafPtr = this._interface().createPortAssociation2(viewPtr);
		}
	}

	/**
	 * destroy port association.
	 *
	 * @category initialize-release
	 */
	public void destroyPortAssociation() {
		if (grafPtr != 0) {
			this._interface().destroyPortAssociation(viewPtr);
			grafPtr = 0;
		}
	}

	/**
	 * get the movie component.
	 *
	 * @return java.awt.Component
	 * @category accessing
	 */
	public Component getComponent() {
		return mv;
	}

	/**
	 * set the movie box.
	 *
	 * @param movie jp.co.sra.qt4jun.JunQTMovie
	 * @param box java.awt.Rectangle
	 * @param offset java.awt.Point
	 * @category accessing
	 */
	public void setMovieBox(JunQTMovie movie, Rectangle box, Point offset) {
		box = new Rectangle(box);
		box.translate(offset.x, offset.y);
		if (mv instanceof JComponent) {
			offset = this._interface().getMovieOffsetSwing(mv);
		} else {
			offset = this._interface().getMovieOffsetAwt(mv);
		}
		box.translate(offset.x, offset.y);
		movie.setBox(box);
	}

	/**
	 * get the graf ptr.
	 *
	 * @return int
	 * @category private
	 */
	public int getGrafPtr() {
		return grafPtr;
	}
}
