package jp.co.sra.jun.vrml.support;

import java.util.Stack;
import java.util.Vector;
import jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode;
import jp.co.sra.smalltalk.*;

/**
 * JunVrmlParser class
 * 
 *  @author    nisinaka
 *  @created   2000/03/17 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlParser.java,v 8.11 2008/02/20 06:33:17 nisinaka Exp $
 */
public abstract class JunVrmlParser extends JunVrmlScanner {
	protected Object parseNode = null;
	protected JunVrmlSyntaxTreeBuilder builder = null;
	protected Stack prevMark = null;
	protected Stack prevToken = null;
	protected Stack prevTokenType = null;

	/**
	 * Create a read stream from the object.
	 * 
	 * @param anObject java.lang.Object
	 * 
	 * @return jp.co.sra.smalltalk.StReadStream
	 */
	public static StReadStream MakeStream_(Object anObject) {
		if (anObject instanceof StReadStream) {
			return (StReadStream) anObject;
		}

		if (anObject instanceof String) {
			return new StReadStream((String) anObject);
		}

		return new StReadStream(anObject.toString());
	}

	/**
	 * Initialize the VRML parser.
	 * 
	 * @param sourceStream jp.co.sra.smalltalk.StReadStream
	 * @param aBuilder jp.co.sra.jun.vrml.support.JunVrmlSyntaxTreeBuilder
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category initialize-release
	 */
	protected void init_builder_ifFail_(StReadStream sourceStream, JunVrmlSyntaxTreeBuilder aBuilder, StBlockClosure aBlock) {
		super.on_(sourceStream);
		builder = aBuilder;
		failBlock = aBlock;
		prevMark = new Stack();
		prevToken = new Stack();
		prevTokenType = new Stack();
	}

	/**
	 * Get a next token.
	 * 
	 * @return java.lang.Object
	 */
	public Object nextToken() {
		if (tokenType != $("xComment")) {
			prevMark.push(new Integer(mark));
			prevToken.push(token);
			prevTokenType.push(tokenType);
		}

		return super.nextToken();
	}

	/**
	 * Parse the input stream and generate a VRML node tree.
	 * 
	 * @param anObject java.lang.Object
	 * 
	 * @return jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode[]
	 */
	public JunVrmlNode[] parse_(Object anObject) {
		return this.parse_builder_(MakeStream_(anObject), this.defaultBuilder());
	}

	/**
	 * Parse the input stream with the syntax tree builder and generate a VRML
	 * node tree.
	 * 
	 * @param sourceStream jp.co.sra.smalltalk.StReadStream
	 * @param aBuilder jp.co.sra.jun.vrml.support.JunVrmlSyntaxTreeBuilder
	 * 
	 * @return jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode[]
	 */
	public JunVrmlNode[] parse_builder_(StReadStream sourceStream, JunVrmlSyntaxTreeBuilder aBuilder) {
		return this.parse_builder_ifFail_(sourceStream, aBuilder, new StBlockClosure() {
			public Object value_(Object anObject) {
				String errorMessage = (String) anObject;
				String label = errorMessage + " near " + token.toString();
				String string = source.upToEnd().toString();

				if (string.length() == 0) {
					string = "--> end of file ";
				} else {
					string = "--> " + string;
				}

				throw SmalltalkException.Error(label + " : " + string);
			}
		});
	}

	/**
	 * Parse the input stream with the syntax tree builder and generate a VRML
	 * node tree.
	 * 
	 * @param sourceStream jp.co.sra.smalltalk.StReadStream
	 * @param aBuilder jp.co.sra.jun.vrml.support.JunVrmlSyntaxTreeBuilder
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * 
	 * @return jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode[]
	 */
	public JunVrmlNode[] parse_builder_ifFail_(StReadStream sourceStream, JunVrmlSyntaxTreeBuilder aBuilder, StBlockClosure aBlock) {
		this.init_builder_ifFail_(sourceStream, aBuilder, aBlock);

		if (this.parseVrml() == false) {
			throw SmalltalkException.Error("Syntax error");
		}

		//
		if (parseNode == null) {
			return null;
		}

		if (parseNode instanceof JunVrmlNode) {
			return new JunVrmlNode[] {(JunVrmlNode) parseNode };
		}

		if (parseNode instanceof Vector) {
			Vector nodes = (Vector) parseNode;
			JunVrmlNode[] nodeTree = new JunVrmlNode[nodes.size()];
			nodes.copyInto(nodeTree);

			return nodeTree;
		}

		throw SmalltalkException.Error("Unknown type of parsed node");
	}

	/**
	 * Answer true if the receiver successfully parse the source stream.
	 * Creation date: (2000/03/22 18:44:39)
	 * 
	 * @return boolean
	 */
	public boolean parseVrml() {
		if (source.atEnd()) {
			parseNode = null;

			return true;
		}

		if (this.parseVrmlScene()) {
			this.nextToken();

			return tokenType == $("eof");
		}

		return ((Boolean) failBlock.value_("Syntex error")).booleanValue();
	}

	/**
	 * Answer true if the receiver successfully parse the source stream as a
	 * VRML scene. Creation date: (2000/03/22 18:49:27)
	 * 
	 * @return boolean
	 */
	public abstract boolean parseVrmlScene();

	/**
	 * Unget a token.
	 */
	public void unNextToken() {
		super.unNextToken();
		mark = ((Integer) prevMark.pop()).intValue();
		token = prevToken.pop();
		tokenType = (StSymbol) prevTokenType.pop();
	}

	/**
	 * Answer an instance of the default syntax tree builder.
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlSyntaxTreeBuilder
	 */
	protected abstract JunVrmlSyntaxTreeBuilder defaultBuilder();
}
