package jp.co.sra.jun.vrml.support;

import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.vrml.node.abstracts.*;

/**
 * JunVrmlNodeVisitor class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlNodeVisitor.java,v 8.11 2008/02/20 06:33:17 nisinaka Exp $
 */
public abstract class JunVrmlNodeVisitor extends JunAbstractObject {

	/**
	 * Process the geometry node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractGeometryNode
	 */
	public void doGeneralGeometry_(JunVrmlAbstractGeometryNode aNode) {
		// Do nothing as a default.
	}

	/**
	 * Process the property node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode
	 */
	public void doGeneralProperty_(JunVrmlAbstractPropertyNode aNode) {
		// Do nothing as a default.
	}

	/**
	 * Process the geometry node.
	 * 
	 * @param aNode jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode
	 */
	public void doWorldInfo_(JunVrmlNode aNode) {
		// Do nothing as a default.
	}
}
