package jp.co.sra.jun.vrml.support;

import jp.co.sra.smalltalk.*;

/**
 * JunVrmlKeywordTable class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   1999/06/22 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlKeywordTable.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlKeywordTable extends StObject {
	/** The keyword table. */
	protected Object[] table = null;

	/**
	 * Create a new JunVrmlKeywordTable.
	 */
	public JunVrmlKeywordTable() {
		this(0);
	}

	/**
	 * Create a new JunVrmlKeywordTable.
	 * 
	 * @param nSize int
	 */
	public JunVrmlKeywordTable(int nSize) {
		table = new Object[nSize];
	}

	/**
	 * Answer the keyword table.
	 * 
	 * @return jp.co.sra.jun.vrml.support.JunVrmlKeywordTable
	 */
	public static JunVrmlKeywordTable KeywordTable() {
		return null;
	}

	/**
	 * Answer the object at the specified place.
	 * 
	 * @param index int
	 * 
	 * @return java.lang.Object
	 */
	public Object at(int index) {
		return table[index];
	}

	/**
	 * Answer true if the table contains the symbol as a key.
	 * 
	 * @param aSymbol jp.co.sra.smalltalk.StSymbol
	 * 
	 * @return boolean
	 */
	public boolean hasSymbol_(StSymbol aSymbol) {
		for (int i = 0; i < table.length; i++) {
			if (table[i] == aSymbol) {
				return true;
			}
		}

		return false;
	}

	/**
	 * Put the object at the specified place. This is a replacement of the
	 * smalltalk method 'at:put:'.
	 * 
	 * @param index int
	 * @param anObject java.lang.Object
	 */
	public void put(int index, Object anObject) {
		table[index] = anObject;
	}

	/**
	 * Answer the size of the table.
	 * 
	 * @return int
	 */
	public int size() {
		return table.length;
	}
}
