package jp.co.sra.jun.vrml.node.property20;

import java.util.Hashtable;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.vrml.field.mf.JunVrmlMFStringField;
import jp.co.sra.jun.vrml.field.sf.JunVrmlSFStringField;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlWorldInfoNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/04/17 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlWorldInfoNode.java,v 8.10 2008/02/20 06:33:17 nisinaka Exp $
 */
public class JunVrmlWorldInfoNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode {
	protected JunVrmlMFStringField infoField;
	protected JunVrmlSFStringField titleField;

	/**
	 * Create a new instance of JunVrmlWorldInfoNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 */
	public JunVrmlWorldInfoNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("info"))) {
			infoField = new JunVrmlMFStringField(aDictionary.get($("info")));
		}

		if (aDictionary.containsKey($("title"))) {
			titleField = new JunVrmlSFStringField(aDictionary.get($("title")));
		}
	}

	/**
	 * Answer the default value of info.
	 * 
	 * @return java.lang.String[]
	 */
	public static String[] DefaultInfo() {
		return new String[] {
		};
	}

	/**
	 * Answer the default value of title.
	 * 
	 * @return java.lang.String
	 */
	public static String DefaultTitle() {
		return "";
	}

	/**
	 * Answer the info.
	 * 
	 * @return java.lang.String[]
	 */
	public String[] info() {
		return this.infoField().value();
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doWorldInfo_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public void propertyOn_(JunOpenGL3dObject a3dObject) {
	}

	/**
	 * Answer the title.
	 * 
	 * @return java.lang.String
	 */
	public String title() {
		return this.titleField().value();
	}

	/**
	 * Answer the info field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFStringField
	 */
	protected JunVrmlMFStringField infoField() {
		if (infoField == null) {
			infoField = new JunVrmlMFStringField(DefaultInfo());
		}

		return infoField;
	}

	/**
	 * Answer the title field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.sf.JunVrmlSFStringField
	 */
	protected JunVrmlSFStringField titleField() {
		if (titleField == null) {
			titleField = new JunVrmlSFStringField(DefaultTitle());
		}

		return titleField;
	}
}
