package jp.co.sra.jun.vrml.node.property;

import java.util.Hashtable;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.*;
import jp.co.sra.jun.vrml.field.mf.JunVrmlMFVec3fField;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlNormalNode class
 * 
 *  @author    nisinaka
 *  @created   2000/03/29 (by nisinaka)
 *  @updated   2003/09/09 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlNormalNode.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlNormalNode extends jp.co.sra.jun.vrml.node.abstracts.JunVrmlAbstractPropertyNode {

	protected JunVrmlMFVec3fField vectorField;

	/**
	 * The default constructor.
	 * 
	 * @category Instance creation
	 */
	public JunVrmlNormalNode() {
		super();
	}

	/**
	 * Create a new instance of JunVrmlNormalNode and initialize it.
	 * 
	 * @param aDictionary java.util.Hashtable
	 * @category Instance creation
	 */
	public JunVrmlNormalNode(Hashtable aDictionary) {
		if (aDictionary.containsKey($("vector"))) {
			vectorField = new JunVrmlMFVec3fField(aDictionary.get($("vector")));
		}
	}

	/**
	 * Answer the default value of vector.
	 * 
	 * @return float[]
	 * @category Defaults
	 */
	public static final float[] DefaultVector() {
		return new float[] {
		};
	}

	/**
	 * Initialize the JunVrmlNormalNode.
	 * 
	 * @see jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		vectorField = null;
	}

	/**
	 * Answer the vector.
	 * 
	 * @return float[]
	 * @category accessing
	 */
	public float[] vector() {
		return this.vectorField().value();
	}

	/**
	 * Answer the vector field.
	 * 
	 * @return jp.co.sra.jun.vrml.field.mf.JunVrmlMFVec3fField
	 * @category accessing
	 */
	protected JunVrmlMFVec3fField vectorField() {
		if (vectorField == null) {
			vectorField = new JunVrmlMFVec3fField(DefaultVector());
		}
		return vectorField;
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 * @category enumerating
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doNormal_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the vector as an array of Jun3dPoint.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category code generation
	 */
	public Jun3dPoint[] vectorAs3dPoints() {
		return this.vectorField().as3dPoints();
	}

	/**
	 * Set my properties on the JunOpenGL3dObject.
	 * 
	 * @param anOpenGL3dObject jp.co.sra.jun.openg.objects.JunOpenGL3dObject
	 * @category code generation
	 */
	public void propertyOn_(JunOpenGL3dObject anOpenGL3dObject) {
	}

}
