package jp.co.sra.jun.vrml.node.grouping10;

import java.util.Vector;
import jp.co.sra.jun.vrml.node.abstracts.*;
import jp.co.sra.jun.vrml.support.*;

/**
 * JunVrmlSeparatorNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlSeparatorNode.java,v 8.10 2008/02/20 06:33:16 nisinaka Exp $
 */
public class JunVrmlSeparatorNode extends JunVrmlAbstractGroupingNode {
	protected JunVrmlNode[] nodes;

	/**
	 * Create a new instance of JunVrmlSeparatorNode and initialize it.
	 * 
	 * @param aCollectionOfNodes java.util.Vector
	 */
	public JunVrmlSeparatorNode(Vector aCollectionOfNodes) {
		this.nodes_(aCollectionOfNodes);
	}

	/**
	 * Process myself with the generator.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		try {
			aVisitor.perform_with_("doSeparator_", this);
		} catch (Exception e) {
			super.nodeDo_(aVisitor);
		}
	}

	/**
	 * Answer the nodes.
	 * 
	 * @return jp.co.sra.jun.vrml.node.abstracts.JunVrmlNode[]
	 */
	public JunVrmlNode[] nodes() {
		return nodes;
	}

	/**
	 * Set the nodes.
	 * 
	 * @param aCollection java.util.Vector
	 */
	public void nodes_(Vector aCollection) {
		int size = aCollection.size();
		nodes = new JunVrmlNode[size];
		aCollection.copyInto(nodes);
	}
}
