package jp.co.sra.jun.vrml.node.abstracts;

import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor;

/**
 * JunVrmlNode class
 * 
 *  @author    ASTI Beijing
 *  @created   UNKNOWN
 *  @updated   2000/03/27 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVrmlNode.java,v 8.11 2008/02/20 06:33:15 nisinaka Exp $
 */
public abstract class JunVrmlNode extends JunAbstractObject {

	public static JunVrmlNode Undefined = new JunVrmlNode() {
	};

	/**
	 * Create a new instance of <code>JunVrmlNode</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunVrmlNode() {
		super();
	}

	/**
	 * Initialize the JunVrmlNode.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
	}

	/**
	 * Answer true if the receiver is a geometry node, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isGeometryNode() {
		return false;
	}

	/**
	 * Answer true if the receiver is a grouping node, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isGroupingNode() {
		return false;
	}

	/**
	 * Answer true if the receiver is a property node, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isPropertyNode() {
		return false;
	}

	/**
	 * Process the receiver with the visitor.
	 * 
	 * @param aVisitor jp.co.sra.jun.vrml.support.JunVrmlNodeVisitor
	 * @category enumerating
	 */
	public void nodeDo_(JunVrmlNodeVisitor aVisitor) {
		// Nothing to do.
	}

}
