package jp.co.sra.jun.voronoi.twoD.diagram;

import java.awt.Point;
import java.io.IOException;
import java.io.Writer;

/**
 * JunVoronoi2dSide class
 * 
 *  @author    NISHIHARA Satoshi
 *  @created   2000/01/25 (by NISHIHARA Satoshi)
 *  @updated   2006/11/07 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunVoronoi2dSide.java,v 8.10 2008/02/20 06:33:14 nisinaka Exp $
 */
public class JunVoronoi2dSide extends JunVoronoi2dObject {

	protected JunVoronoi2dPoint from;
	protected JunVoronoi2dPoint to;
	protected JunVoronoi2dDot dot1;
	protected JunVoronoi2dDot dot2;

	/**
	 * Create a new instance of JunVoronoi2dSide and initialize it.
	 *
	 * @param fromPoint jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPoint
	 * @param toPoint jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPoint
	 * @category Instance creation
	 */
	public JunVoronoi2dSide(JunVoronoi2dPoint fromPoint, JunVoronoi2dPoint toPoint) {
		this.from_(fromPoint);
		this.to_(toPoint);
	}

	/**
	 * Create a new instance of JunVoronoi2dSide and initialize it.
	 *
	 * @param fromPoint java.awt.Point
	 * @param toPoint java.awt.Point
	 * @category Instance creation
	 */
	public JunVoronoi2dSide(Point fromPoint, Point toPoint) {
		this(new JunVoronoi2dPoint(fromPoint), new JunVoronoi2dPoint(toPoint));
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		from = null;
		to = null;
		dot1 = null;
		dot2 = null;
	}

	/**
	 * Answer my current FROM point.
	 * 
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPoint
	 * @category accessing
	 */
	public JunVoronoi2dPoint from() {
		return from;
	}

	/**
	 * Set my new FROM point.
	 * 
	 * @param voronoi2dPoint jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPoint
	 * @category accessing
	 */
	public void from_(JunVoronoi2dPoint voronoi2dPoint) {
		from = voronoi2dPoint;
	}

	/**
	 * Answer my current TO point.
	 * 
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPoint
	 * @category accessing
	 */
	public JunVoronoi2dPoint to() {
		return to;
	}

	/**
	 * Set my new TO point.
	 * 
	 * @param voronoi2dPoint jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPoint
	 * @category accessing
	 */
	public void to_(JunVoronoi2dPoint voronoi2dPoint) {
		to = voronoi2dPoint;
	}

	/**
	 * Answer my current dot1.
	 * 
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category accessing
	 */
	public JunVoronoi2dDot dot1() {
		return dot1;
	}

	/**
	 * Set my new dot1.
	 * 
	 * @param voronoi2dDot jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category accessing
	 */
	public void dot1_(JunVoronoi2dDot voronoi2dDot) {
		dot1 = voronoi2dDot;
	}

	/**
	 * Answer my current dot2.
	 * 
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category accessing
	 */
	public JunVoronoi2dDot dot2() {
		return dot2;
	}

	/**
	 * Set my new dot2.
	 * 
	 * @param voronoi2dDot jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dDot
	 * @category accessing
	 */
	public void dot2_(JunVoronoi2dDot voronoi2dDot) {
		dot2 = voronoi2dDot;
	}

	/**
	 * Answer the intersecting point with the specified side.
	 * 
	 * @param voronoi2dSide jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dSide
	 * @return jp.co.sra.jun.voronoi.twoD.diagram.JunVoronoi2dPoint
	 * @category functions
	 */
	public JunVoronoi2dPoint intersectingPointWithSide_(JunVoronoi2dSide voronoi2dSide) {
		double x1 = this.from().x();
		double y1 = this.from().y();
		double x2 = this.to().x();
		double y2 = this.to().y();
		double x3 = voronoi2dSide.from().x();
		double y3 = voronoi2dSide.from().y();
		double x4 = voronoi2dSide.to().x();
		double y4 = voronoi2dSide.to().y();
		double x21 = x2 - x1;
		double y21 = y2 - y1;
		double x43 = x4 - x3;
		double y43 = y4 - y3;
		double x31 = x3 - x1;
		double y31 = y3 - y1;
		double det = x43 * y21 - y43 * x21;
		if (Math.abs(det) < this.accuracy()) {
			return null;
		}

		double detinv = 1.0 / det;
		double s = (x43 * y31 - y43 * x31) * detinv;
		double t = (x21 * y31 - y21 * x31) * detinv;
		if (s < 0 || 1 < s || t < 0 || 1 < t) {
			return null;
		}

		double x = x1 + x21 * s;
		double y = y1 + y21 * s;
		return new JunVoronoi2dPoint(x, y);
	}

	/**
	 * Answer true if the receiver is valid.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isValid() {
		if (from == null || from.isValid() == false) {
			return false;
		}
		if (to == null || to.isValid() == false) {
			return false;
		}
		if (dot1 == null) {
			return false;
		}
		if (dot2 == null) {
			return false;
		}
		return true;
	}

	/**
	 * Answer true if the receiver is invalid.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isInvalid() {
		return !this.isValid();
	}

	/**
	 * Answer true if the receiver is valid.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isValid2() {
		if (from == null) {
			return false;
		}
		if (to == null) {
			return false;
		}
		if (dot1 == null) {
			return false;
		}
		if (dot2 == null) {
			return false;
		}
		return true;
	}

	/**
	 * Print my string representation on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		aWriter.write("side ( ");
		from.printOn_(aWriter);
		aWriter.write(" , ");
		to.printOn_(aWriter);
		aWriter.write(" )");
	}

}
