package jp.co.sra.jun.topology.graph;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

import javax.swing.JFrame;
import javax.swing.JPanel;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StRectangle;

import jp.co.sra.jun.goodies.tables.JunAttributeTable;
import jp.co.sra.jun.goodies.utilities.JunStringUtility;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunElementalGraphTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/04/05 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun597 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalGraphTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalGraphTestExamples extends JunTestExamples {

	/**
	 * Example00: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example00() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleSimple();
		System.out.println(aGraph.printString());

		return true;
	}

	/**
	 * Example01: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example01() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleSimple();
		aGraph.beUndirectedGraph();
		System.out.println(aGraph.printString());

		return true;
	}

	/**
	 * Example02: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example02() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleSimple();
		System.out.println(aGraph.toLispList());
		aGraph = new JunElementalGraph(aGraph.toLispList());
		System.out.println(aGraph.toLispList());
		System.out.println(aGraph.printString());

		return true;
	}

	/**
	 * Example10: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example10() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleSimple();
		aGraph.nodesDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence);
				System.out.print(": ");
				System.out.print(node);
				System.out.println();
				return null;
			}
		});
		System.out.println();
		aGraph.arcsDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object arc, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence);
				System.out.print(": ");
				System.out.print(arc);
				System.out.println();
				return null;
			}
		});

		return true;
	}

	/**
	 * Example11: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example11() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleCycle();
		aGraph.nodesDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence);
				System.out.print(": ");
				System.out.print(node);
				System.out.println();
				return null;
			}
		});
		System.out.println();
		aGraph.arcsDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object arc, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence);
				System.out.print(": ");
				System.out.print(arc);
				System.out.println();
				return null;
			}
		});

		return true;
	}

	/**
	 * Example12: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example12() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleSimple();
		aGraph.nodesBreadthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence);
				System.out.print(": ");
				System.out.print(node);
				System.out.println();
				return null;
			}
		});
		System.out.println();
		aGraph.arcsBreadthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object arc, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence);
				System.out.print(": ");
				System.out.print(arc);
				System.out.println();
				return null;
			}
		});

		return true;
	}

	/**
	 * Example13: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example13() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleSimple();
		aGraph.nodesTopologicalSortDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print('\t');
				}
				System.out.print(sequence);
				System.out.print(": ");
				System.out.print(node);
				System.out.println();
				return null;
			}
		});
		System.out.println();
		JunElementalNode[] nodes = aGraph.nodesTopologicalSort();
		for (int i = 0; i < nodes.length; i++) {
			System.out.println(nodes[i].toString());
		}

		return true;
	}

	/**
	 * Example14: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example14() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleSimple();
		Map shortestPaths = aGraph.shortestPaths();

		TreeSet aTreeSet = new TreeSet(new Comparator() {
			public int compare(Object o1, Object o2) {
				JunElementalNode node1 = (JunElementalNode) ((Map.Entry) o1).getKey();
				JunElementalNode node2 = (JunElementalNode) ((Map.Entry) o2).getKey();
				return node1.labelString().compareTo(node2.labelString());
			}
		});
		aTreeSet.addAll(shortestPaths.entrySet());
		Iterator iterator = aTreeSet.iterator();
		while (iterator.hasNext()) {
			Map.Entry entry = (Map.Entry) iterator.next();
			Object startNode = entry.getKey();
			Map shortestPath = (Map) entry.getValue();

			TreeSet aTreeSet2 = new TreeSet(new Comparator() {
				public int compare(Object o1, Object o2) {
					JunElementalNode node1 = (JunElementalNode) ((Map.Entry) o1).getKey();
					JunElementalNode node2 = (JunElementalNode) ((Map.Entry) o2).getKey();
					return node1.labelString().compareTo(node2.labelString());
				}
			});
			aTreeSet2.addAll(shortestPath.entrySet());
			Iterator iterator2 = aTreeSet2.iterator();
			while (iterator2.hasNext()) {
				Map.Entry entry2 = (Map.Entry) iterator2.next();
				Object node = entry2.getKey();
				Number distance = (Number) entry2.getValue();

				System.out.print(startNode);
				System.out.print(" -- ");
				System.out.print(distance);
				System.out.print(" -> ");
				System.out.print(node);
				System.out.println();
			}
		}

		return true;
	}

	/**
	 * Example15: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example15() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleCycle();
		Map shortestPaths = aGraph.shortestPaths();

		TreeSet aTreeSet = new TreeSet(new Comparator() {
			public int compare(Object o1, Object o2) {
				JunElementalNode node1 = (JunElementalNode) ((Map.Entry) o1).getKey();
				JunElementalNode node2 = (JunElementalNode) ((Map.Entry) o2).getKey();
				return node1.labelString().compareTo(node2.labelString());
			}
		});
		aTreeSet.addAll(shortestPaths.entrySet());
		Iterator iterator = aTreeSet.iterator();
		while (iterator.hasNext()) {
			Map.Entry entry = (Map.Entry) iterator.next();
			Object startNode = entry.getKey();
			Map shortestPath = (Map) entry.getValue();

			TreeSet aTreeSet2 = new TreeSet(new Comparator() {
				public int compare(Object o1, Object o2) {
					JunElementalNode node1 = (JunElementalNode) ((Map.Entry) o1).getKey();
					JunElementalNode node2 = (JunElementalNode) ((Map.Entry) o2).getKey();
					return node1.labelString().compareTo(node2.labelString());
				}
			});
			aTreeSet2.addAll(shortestPath.entrySet());
			Iterator iterator2 = aTreeSet2.iterator();
			while (iterator2.hasNext()) {
				Map.Entry entry2 = (Map.Entry) iterator2.next();
				Object node = entry2.getKey();
				Number distance = (Number) entry2.getValue();

				System.out.print(startNode);
				System.out.print(" -- ");
				System.out.print(distance);
				System.out.print(" -> ");
				System.out.print(node);
				System.out.println();
			}
		}

		return true;
	}

	/**
	 * Example16: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example16() {
		JunElementalNode nodeA = JunElementalGraph.DefaultNewNode("a");
		JunElementalNode nodeB = JunElementalGraph.DefaultNewNode("b");
		JunElementalNode nodeC = JunElementalGraph.DefaultNewNode("c");
		JunElementalNode nodeD = JunElementalGraph.DefaultNewNode("d");
		JunElementalNode nodeE = JunElementalGraph.DefaultNewNode("e");
		JunElementalNode nodeF = JunElementalGraph.DefaultNewNode("f");

		JunElementalGraph aGraph = JunElementalGraph.DefaultNewGraph();
		aGraph.connect_with_(nodeA, nodeB);
		aGraph.connect_with_(nodeA, nodeC);
		aGraph.connect_with_(nodeB, nodeC);

		JunElementalGraph anotherGraph = JunElementalGraph.DefaultNewGraph();
		anotherGraph.connect_with_(nodeF, nodeD);
		anotherGraph.connect_with_(nodeE, nodeD);
		anotherGraph.connect_with_(nodeE, nodeF);

		boolean isIsomorphic = aGraph.isIsomorphicTo_(anotherGraph);
		System.out.println(isIsomorphic);

		return isIsomorphic;
	}

	/**
	 * Example17: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example17() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleSimple();
		JunElementalGraph anotherGraph = JunElementalGraph.ExampleCycle();
		boolean isIsomorphic = aGraph.isIsomorphicTo_(anotherGraph);
		System.out.println(isIsomorphic);

		return !isIsomorphic;
	}

	/**
	 * Example20: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example20() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleTree();
		aGraph.nodesDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print("|-- ");
				}
				System.out.println(node);
				return null;
			}
		});

		return true;
	}

	/**
	 * Example21: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example21() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleForest();
		aGraph.nodesDepthFirstDo_(new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				for (int i = 0; i < ((Number) indent).intValue(); i++) {
					System.out.print("|-- ");
				}
				System.out.println(node);
				return null;
			}
		});

		return true;
	}

	/**
	 * Example22: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example22() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleDirectory_withFiles_(3, true);
		if (aGraph == null) {
			return false;
		}

		aGraph.visitDepthFirst_nodeDo_arcDo_(null, new StBlockClosure() {
			public Object value_value_value_(Object node, Object indent, Object sequence) {
				String aString = ((JunElementalNode) node).labelString();
				int level = ((Number) indent).intValue();
				if (level > 0) {
					for (int i = 1; i < level; i++) {
						System.out.print("|  ");
					}
					if (aString.endsWith("/")) {
						System.out.print("+- ");
					} else {
						System.out.print("|- ");
					}
				}
				System.out.println(aString);
				return null;
			}
		}, new StBlockClosure());

		return true;
	}

	/**
	 * Example30: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example30() {
		final JunElementalGraph aGraph = JunElementalGraph.ExampleTree();
		JunAttributeTable attributeTable = aGraph.arrangeTree();

		int howMany = 100;
		HashMap aMap = new HashMap();
		Dimension extent = new Dimension();
		Iterator iterator = ((Map) attributeTable.at_($("nodeOriginTable"))).entrySet().iterator();
		while (iterator.hasNext()) {
			Map.Entry entry = (Map.Entry) iterator.next();
			JunElementalNode node = (JunElementalNode) entry.getKey();
			Point origin = (Point) entry.getValue();
			ArrayList aList = new ArrayList(howMany + 1);
			for (int i = 0; i <= howMany; i++) {
				int x = node.origin().x + (origin.x - node.origin().x) * i / howMany;
				int y = node.origin().y + (origin.y - node.origin().y) * i / howMany;
				aList.add(new Point(x, y));
			}
			aMap.put(node, aList);

			extent.width = Math.max(extent.width, origin.x + node.width());
			extent.height = Math.max(extent.height, origin.y + node.height());
		}

		JPanel aPanel = new JPanel() {
			public void paint(Graphics g) {
				aGraph.displayOn_(g);
			}
		};
		aPanel.setPreferredSize(extent);

		JFrame aFrame = new JFrame();
		aFrame.getContentPane().add(aPanel);
		aFrame.pack();
		_ShowAtCenterPoint(aFrame);

		JunElementalNode[] nodes = aGraph.nodes();
		for (int n = 0; n <= howMany; n++) {
			for (int i = 0; i < nodes.length; i++) {
				nodes[i].origin_((Point) ((ArrayList) aMap.get(nodes[i])).get(n));
			}

			aPanel.paintImmediately(aPanel.getBounds());

			try {
				Thread.sleep(50);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}

		return true;
	}

	/**
	 * Example31: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example31() {
		final JunElementalGraph aGraph = JunElementalGraph.ExampleForest();
		JunAttributeTable attributeTable = aGraph.arrangeForest();

		int howMany = 100;
		HashMap aMap = new HashMap();
		Dimension extent = new Dimension();
		Iterator iterator = ((Map) attributeTable.at_($("nodeOriginTable"))).entrySet().iterator();
		while (iterator.hasNext()) {
			Map.Entry entry = (Map.Entry) iterator.next();
			JunElementalNode node = (JunElementalNode) entry.getKey();
			Point origin = (Point) entry.getValue();
			ArrayList aList = new ArrayList(howMany + 1);
			for (int i = 0; i <= howMany; i++) {
				int x = node.origin().x + (origin.x - node.origin().x) * i / howMany;
				int y = node.origin().y + (origin.y - node.origin().y) * i / howMany;
				aList.add(new Point(x, y));
			}
			aMap.put(node, aList);

			extent.width = Math.max(extent.width, origin.x + node.width());
			extent.height = Math.max(extent.height, origin.y + node.height());
		}

		final Point aPoint = new Point();
		JPanel aPanel = new JPanel() {
			public void paint(Graphics g) {
				aGraph.displayOn_at_(g, aPoint);
			}
		};
		aPanel.setPreferredSize(new Dimension(extent.width, extent.height / 2));

		JFrame aFrame = new JFrame();
		aFrame.getContentPane().add(aPanel);
		aFrame.pack();
		_ShowAtCenterPoint(aFrame);

		JunElementalNode[] nodes = aGraph.nodes();
		for (int n = 0; n <= howMany; n++) {
			for (int i = 0; i < nodes.length; i++) {
				nodes[i].origin_((Point) ((ArrayList) aMap.get(nodes[i])).get(n));
			}

			aPanel.paintImmediately(aPanel.getBounds());

			try {
				Thread.sleep(50);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}

		Graphics aGraphics = null;
		try {
			aGraphics = aPanel.getGraphics();

			int scrollAmount = Math.max(extent.height / 250, 10);
			aPoint.y = 0;
			while (aPoint.y > aPanel.getHeight() - extent.height) {
				aPanel.paintImmediately(aPanel.getBounds());

				try {
					Thread.sleep(50);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}

				aPoint.y -= scrollAmount;
			}
			while (aPoint.y < 0) {
				aPanel.paintImmediately(aPanel.getBounds());

				try {
					Thread.sleep(50);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}

				aPoint.y += scrollAmount;
			}
		} finally {
			if (aGraphics != null) {
				aGraphics.dispose();
			}
		}

		aPoint.x = 0;
		aPoint.y = 0;
		aPanel.repaint();

		return true;
	}

	/**
	 * Example40: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example40() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleTree();
		aGraph.arrangeFormat_($("tree"));
		aGraph.arrange();
		aGraph.show();

		return true;
	}

	/**
	 * Example41: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example41() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleForest();
		aGraph.arrangeFormat_($("forest"));
		aGraph.arrange();
		aGraph.show();

		return true;
	}

	/**
	 * Example42: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example42() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleForest();
		aGraph.arrangeFormat_($("forest"));
		aGraph.arrangeForestInterval_(150);
		aGraph.arrangeForestMargin_(1);
		aGraph.arrange();
		aGraph.show();

		return true;
	}

	/**
	 * Example43: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example43() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleTokyo();

		StBlockClosure locationDMStoNumberBlock = new StBlockClosure() {
			public Object value_(Object anObject) {
				String[] strings = JunStringUtility.Separate_dividers_((String) anObject, new char[] { '/' });
				double result = Double.parseDouble(strings[1]);
				result += Double.parseDouble(strings[2]) / 60;
				result += Double.parseDouble(strings[3]) / 3600;
				if ("W".equals(strings[0]) || "S".equals(strings[0])) {
					result *= -1;
				}
				return new Double(result);
			}
		};

		double centerLongitude = ((Number) locationDMStoNumberBlock.value_("E/139/44/40.9")).doubleValue();
		double centerLatitude = ((Number) locationDMStoNumberBlock.value_("N/35/39/16.0")).doubleValue();
		JunElementalNode[] nodes = aGraph.nodes();
		for (int i = 0; i < nodes.length; i++) {
			double longitude = ((Number) locationDMStoNumberBlock.value_(nodes[i].attributeAt_($("longitude")))).doubleValue();
			double latitude = ((Number) locationDMStoNumberBlock.value_(nodes[i].attributeAt_($("latitude")))).doubleValue();
			double scale = 7000;
			int x = (int) Math.round((longitude - centerLongitude) * scale);
			int y = (int) Math.round((latitude - centerLatitude) * scale);
			nodes[i].center_(new Point(x, -y));
		}

		aGraph.flushBoundingBox();
		StRectangle aBox = aGraph.boundingBox();
		for (int i = 0; i < nodes.length; i++) {
			Point aPoint = nodes[i].origin();
			nodes[i].origin_(new Point(aPoint.x - aBox.originX(), aPoint.y - aBox.originY()));
		}
		aGraph.flushBoundingBox();

		aGraph.show();

		return true;
	}

	/**
	 * Example44: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example44() {
		JunElementalGraph aGraph = JunElementalGraph.ExampleTokyo();
		aGraph.arrangeFormat_($("concentric"));
		aGraph.arrangeAttributeSymbol_($("distance"));
		aGraph.arrangeConcentricRadius_(400);
		aGraph.arrangeConcentricSpiral_(3);
		aGraph.arrange();
		aGraph.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunElementalGraphTestExamples();
	}

}
