package jp.co.sra.jun.topology.graph;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;

import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.WindowSpecLayout;

import jp.co.sra.jun.goodies.track.JunSimpleSliderModel;
import jp.co.sra.jun.goodies.track.JunSimpleSliderViewAwt;

/**
 * JunElementalArcSettingsViewAwt class
 * 
 *  @author    nisinaka
 *  @created   2006/04/21 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun593 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunElementalArcSettingsViewAwt.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunElementalArcSettingsViewAwt extends JunElementalStuffSettingsViewAwt implements JunElementalArcSettingsView {

	protected Button lineColorButton;
	protected JunSimpleSliderViewAwt lineWidthSlider;
	protected Button firstBoxColorButton;
	protected Button lastBoxColorButton;
	protected Checkbox firstTopLeftButton;
	protected Checkbox firstTopCenterButton;
	protected Checkbox firstTopRightButton;
	protected Checkbox firstLeftButton;
	protected Checkbox firstCenterButton;
	protected Checkbox firstRightButton;
	protected Checkbox firstBottomLeftButton;
	protected Checkbox firstBottomCenterButton;
	protected Checkbox firstBottomRightButton;
	protected Checkbox lastTopLeftButton;
	protected Checkbox lastTopCenterButton;
	protected Checkbox lastTopRightButton;
	protected Checkbox lastLeftButton;
	protected Checkbox lastCenterButton;
	protected Checkbox lastRightButton;
	protected Checkbox lastBottomLeftButton;
	protected Checkbox lastBottomCenterButton;
	protected Checkbox lastBottomRightButton;
	protected Button allDefaultsButton;

	private HashMap _blockValues;
	private CheckboxGroup _firstPointAlignmentCheckboxGroup;
	private CheckboxGroup _lastPointAlignmentCheckboxGroup;

	/**
	 * Create a new instance of JunElementalArcSettingsViewAwt and initialize it.
	 *
	 * @param anElementalArcSettings jp.co.sra.jun.topology.graph.JunElementalArcSettings
	 * @category Instance creation
	 */
	public JunElementalArcSettingsViewAwt(JunElementalArcSettings anElementalArcSettings) {
		super(anElementalArcSettings);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		_blockValues = new HashMap();
		_firstPointAlignmentCheckboxGroup = new CheckboxGroup();
		_lastPointAlignmentCheckboxGroup = new CheckboxGroup();
	}

	/**
	 * Build the component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewJPanel#buildComponent()
	 * @category initialize-release
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(new Label($String("Line Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 16));
		this.add(this.lineColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 16, 0f, 248, 0f, 40));
		this.add(new Label($String("Line Width") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 48));
		this.add(this.lineWidthSlider(), WindowSpecLayout.Position(0f, 168, 0f, 48, 0f, 248, 0f, 72));
		this.add(new Label($String("First Box Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 80));
		this.add(this.firstBoxColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 80, 0f, 248, 0f, 104));
		this.add(new Label($String("Last Box Color") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 112));
		this.add(this.lastBoxColorButton(), WindowSpecLayout.Position(0f, 168, 0f, 112, 0f, 248, 0f, 136));
		this.add(new Label($String("First Point Alignment") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 144));
		this.add(this.firstTopLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 152));
		this.add(this.firstTopCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 152));
		this.add(this.firstTopRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 152));
		this.add(this.firstLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 176));
		this.add(this.firstCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 176));
		this.add(this.firstRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 176));
		this.add(this.firstBottomLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 200));
		this.add(this.firstBottomCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 200));
		this.add(this.firstBottomRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 200));
		this.add(new Label($String("Last Point Alignment") + " :"), WindowSpecLayout.Position(0f, 16, 0f, 224));
		this.add(this.lastTopLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 232));
		this.add(this.lastTopCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 232));
		this.add(this.lastTopRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 232));
		this.add(this.lastLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 256));
		this.add(this.lastCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 256));
		this.add(this.lastRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 256));
		this.add(this.lastBottomLeftButton(), WindowSpecLayout.Position(0f, 168, 0f, 280));
		this.add(this.lastBottomCenterButton(), WindowSpecLayout.Position(0f, 200, 0f, 280));
		this.add(this.lastBottomRightButton(), WindowSpecLayout.Position(0f, 232, 0f, 280));
		this.add(this.allDefaultsButton(), WindowSpecLayout.Position(0.5f, -52, 0f, 312, 0.5f, 52, 0f, 336));
		this.setSize(DefaultBounds.getSize());
	}

	/**
	 * Answer my model as JunElementalArcSettings.
	 * 
	 * @return jp.co.sra.jun.topology.graph.JunElementalArcSettings
	 * @see jp.co.sra.jun.topology.graph.JunElementalArcSettingsView#getElementalArcSettings()
	 * @category model accessing
	 */
	public JunElementalArcSettings getElementalArcSettings() {
		return (JunElementalArcSettings) this.model();
	}

	/**
	 * Answer the line color button.
	 * 
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button lineColorButton() {
		if (lineColorButton == null) {
			lineColorButton = new Button() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalArcSettings().lineColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(lineColorButton)).release();
					super.removeNotify();
				}
			};
			lineColorButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lineColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					lineColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lineColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lineColorButton, blockValue);
		}
		return lineColorButton;
	}

	/**
	 * Answer the selection border width slider.
	 * 
	 * @return jp.co.sra.jun.goodies.track.JunSimpleSliderViewAwt
	 * @category user interface
	 */
	protected JunSimpleSliderViewAwt lineWidthSlider() {
		if (lineWidthSlider == null) {
			JunSimpleSliderModel sliderModel = new JunSimpleSliderModel();
			sliderModel.compute_(new StBlockClosure() {
				public Object value_(Object anObject) {
					double value = ((Number) anObject).doubleValue();
					int width = (int) ((value + 0.125) * 4) + 1;
					getElementalArcSettings().lineWidthHolder().value_(new Integer(width));
					return null;
				}
			});
			lineWidthSlider = new JunSimpleSliderViewAwt(sliderModel) {
				public void removeNotify() {
					((StBlockValue) _blockValues.get(lineWidthSlider)).release();
					super.removeNotify();
				}
			};

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					int width = ((Number) anObject).intValue();
					double value = (width - 1) / 4.0d;
					if (value != lineWidthSlider.getSimpleSliderModel().doubleValue()) {
						lineWidthSlider.getSimpleSliderModel().value_(value);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lineWidthHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lineWidthSlider, blockValue);
		}
		return lineWidthSlider;
	}

	/**
	 * Answer the first box color button.
	 * 
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button firstBoxColorButton() {
		if (firstBoxColorButton == null) {
			firstBoxColorButton = new Button() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalArcSettings().firstBoxColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(firstBoxColorButton)).release();
					super.removeNotify();
				}
			};
			firstBoxColorButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().firstBoxColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					firstBoxColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstBoxColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstBoxColorButton, blockValue);
		}
		return firstBoxColorButton;
	}

	/**
	 * Answer the last box color button.
	 * 
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button lastBoxColorButton() {
		if (lastBoxColorButton == null) {
			lastBoxColorButton = new Button() {
				public void paint(Graphics g) {
					super.paint(g);

					Dimension size = this.getSize();
					int x = (size.width - ButtonColorImageSize.width) / 2;
					int y = (size.height - ButtonColorImageSize.height) / 2;
					g.setColor((Color) getElementalArcSettings().lastBoxColorHolder().value());
					g.fillRect(x, y, ButtonColorImageSize.width, ButtonColorImageSize.height);
				}

				public void removeNotify() {
					((StBlockValue) _blockValues.get(lastBoxColorButton)).release();
					super.removeNotify();
				}
			};
			lastBoxColorButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().lastBoxColorButtonPressed();
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					lastBoxColorButton.repaint();
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastBoxColorHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastBoxColorButton, blockValue);
		}
		return lastBoxColorButton;
	}

	/**
	 * Answer the first top left button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox firstTopLeftButton() {
		if (firstTopLeftButton == null) {
			firstTopLeftButton = new Checkbox("", false, _firstPointAlignmentCheckboxGroup);
			firstTopLeftButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("topLeft"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topLeft") && firstTopLeftButton.getState() == false) {
						firstTopLeftButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstTopLeftButton, blockValue);
		}
		return firstTopLeftButton;
	}

	/**
	 * Answer the first top center button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox firstTopCenterButton() {
		if (firstTopCenterButton == null) {
			firstTopCenterButton = new Checkbox("", false, _firstPointAlignmentCheckboxGroup);
			firstTopCenterButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("topCenter"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topCenter") && firstTopCenterButton.getState() == false) {
						firstTopCenterButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstTopCenterButton, blockValue);
		}
		return firstTopCenterButton;
	}

	/**
	 * Answer the first top center button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox firstTopRightButton() {
		if (firstTopRightButton == null) {
			firstTopRightButton = new Checkbox("", false, _firstPointAlignmentCheckboxGroup);
			firstTopRightButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("topRight"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topRight") && firstTopRightButton.getState() == false) {
						firstTopRightButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstTopRightButton, blockValue);
		}
		return firstTopRightButton;
	}

	/**
	 * Answer the first left button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox firstLeftButton() {
		if (firstLeftButton == null) {
			firstLeftButton = new Checkbox("", false, _firstPointAlignmentCheckboxGroup);
			firstLeftButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("leftCenter"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("leftCenter") && firstLeftButton.getState() == false) {
						firstLeftButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstLeftButton, blockValue);
		}
		return firstLeftButton;
	}

	/**
	 * Answer the first center button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox firstCenterButton() {
		if (firstCenterButton == null) {
			firstCenterButton = new Checkbox("", false, _firstPointAlignmentCheckboxGroup);
			firstCenterButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("center"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("center") && firstCenterButton.getState() == false) {
						firstCenterButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstCenterButton, blockValue);
		}
		return firstCenterButton;
	}

	/**
	 * Answer the first right button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox firstRightButton() {
		if (firstRightButton == null) {
			firstRightButton = new Checkbox("", false, _firstPointAlignmentCheckboxGroup);
			firstRightButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("rightCenter"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("rightCenter") && firstRightButton.getState() == false) {
						firstRightButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstRightButton, blockValue);
		}
		return firstRightButton;
	}

	/**
	 * Answer the first bottom left button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox firstBottomLeftButton() {
		if (firstBottomLeftButton == null) {
			firstBottomLeftButton = new Checkbox("", false, _firstPointAlignmentCheckboxGroup);
			firstBottomLeftButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("bottomLeft"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomLeft") && firstBottomLeftButton.getState() == false) {
						firstBottomLeftButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstBottomLeftButton, blockValue);
		}
		return firstBottomLeftButton;
	}

	/**
	 * Answer the first bottom center button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox firstBottomCenterButton() {
		if (firstBottomCenterButton == null) {
			firstBottomCenterButton = new Checkbox("", false, _firstPointAlignmentCheckboxGroup);
			firstBottomCenterButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("bottomCenter"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomCenter") && firstBottomCenterButton.getState() == false) {
						firstBottomCenterButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstBottomCenterButton, blockValue);
		}
		return firstBottomCenterButton;
	}

	/**
	 * Answer the first bottom center button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox firstBottomRightButton() {
		if (firstBottomRightButton == null) {
			firstBottomRightButton = new Checkbox("", false, _firstPointAlignmentCheckboxGroup);
			firstBottomRightButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().firstPointAlignmentHolder().value_($("bottomRight"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomRight") && firstBottomRightButton.getState() == false) {
						firstBottomRightButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().firstPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(firstBottomRightButton, blockValue);
		}
		return firstBottomRightButton;
	}

	/**
	 * Answer the last top left button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox lastTopLeftButton() {
		if (lastTopLeftButton == null) {
			lastTopLeftButton = new Checkbox("", false, _lastPointAlignmentCheckboxGroup);
			lastTopLeftButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("topLeft"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topLeft") && lastTopLeftButton.getState() == false) {
						lastTopLeftButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastTopLeftButton, blockValue);
		}
		return lastTopLeftButton;
	}

	/**
	 * Answer the last top center button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox lastTopCenterButton() {
		if (lastTopCenterButton == null) {
			lastTopCenterButton = new Checkbox("", false, _lastPointAlignmentCheckboxGroup);
			lastTopCenterButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("topCenter"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topCenter") && lastTopCenterButton.getState() == false) {
						lastTopCenterButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastTopCenterButton, blockValue);
		}
		return lastTopCenterButton;
	}

	/**
	 * Answer the last top center button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox lastTopRightButton() {
		if (lastTopRightButton == null) {
			lastTopRightButton = new Checkbox("", false, _lastPointAlignmentCheckboxGroup);
			lastTopRightButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("topRight"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("topRight") && lastTopRightButton.getState() == false) {
						lastTopRightButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastTopRightButton, blockValue);
		}
		return lastTopRightButton;
	}

	/**
	 * Answer the last left button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox lastLeftButton() {
		if (lastLeftButton == null) {
			lastLeftButton = new Checkbox("", false, _lastPointAlignmentCheckboxGroup);
			lastLeftButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("leftCenter"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("leftCenter") && lastLeftButton.getState() == false) {
						lastLeftButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastLeftButton, blockValue);
		}
		return lastLeftButton;
	}

	/**
	 * Answer the last center button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox lastCenterButton() {
		if (lastCenterButton == null) {
			lastCenterButton = new Checkbox("", false, _lastPointAlignmentCheckboxGroup);
			lastCenterButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("center"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("center") && lastCenterButton.getState() == false) {
						lastCenterButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastCenterButton, blockValue);
		}
		return lastCenterButton;
	}

	/**
	 * Answer the last right button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox lastRightButton() {
		if (lastRightButton == null) {
			lastRightButton = new Checkbox("", false, _lastPointAlignmentCheckboxGroup);
			lastRightButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("rightCenter"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("rightCenter") && lastRightButton.getState() == false) {
						lastRightButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastRightButton, blockValue);
		}
		return lastRightButton;
	}

	/**
	 * Answer the last bottom left button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox lastBottomLeftButton() {
		if (lastBottomLeftButton == null) {
			lastBottomLeftButton = new Checkbox("", false, _lastPointAlignmentCheckboxGroup);
			lastBottomLeftButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("bottomLeft"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomLeft") && lastBottomLeftButton.getState() == false) {
						lastBottomLeftButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastBottomLeftButton, blockValue);
		}
		return lastBottomLeftButton;
	}

	/**
	 * Answer the last bottom center button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox lastBottomCenterButton() {
		if (lastBottomCenterButton == null) {
			lastBottomCenterButton = new Checkbox("", false, _lastPointAlignmentCheckboxGroup);
			lastBottomCenterButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("bottomCenter"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomCenter") && lastBottomCenterButton.getState() == false) {
						lastBottomCenterButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastBottomCenterButton, blockValue);
		}
		return lastBottomCenterButton;
	}

	/**
	 * Answer the last bottom center button.
	 * 
	 * @return java.awt.Checkbox
	 * @category user interface
	 */
	protected Checkbox lastBottomRightButton() {
		if (lastBottomRightButton == null) {
			lastBottomRightButton = new Checkbox("", false, _lastPointAlignmentCheckboxGroup);
			lastBottomRightButton.addItemListener(new ItemListener() {
				public void itemStateChanged(ItemEvent e) {
					getElementalArcSettings().lastPointAlignmentHolder().value_($("bottomRight"));
				}
			});

			StBlockClosure aBlock = new StBlockClosure() {
				public Object value_(Object anObject) {
					if (anObject == $("bottomRight") && lastBottomRightButton.getState() == false) {
						lastBottomRightButton.setState(true);
					}
					return null;
				}
			};

			StBlockValue blockValue = this.getElementalArcSettings().lastPointAlignmentHolder().compute_(aBlock);
			blockValue.computeValue();
			_blockValues.put(lastBottomRightButton, blockValue);
		}
		return lastBottomRightButton;
	}

	/**
	 * Answer the all defaults button.
	 * 
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button allDefaultsButton() {
		if (allDefaultsButton == null) {
			allDefaultsButton = new Button($String("Default"));
			allDefaultsButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					getElementalArcSettings().defaultButtonPressed();
				}
			});
		}
		return allDefaultsButton;
	}

	/**
	 * Update for the change notice from the model.
	 * 
	 * @param e jp.co.sra.smalltalk.DependentEvent
	 * @see jp.co.sra.smalltalk.DependentListener#update_(jp.co.sra.smalltalk.DependentEvent)
	 * @category updating
	 */
	public void update_(DependentEvent e) {
		if (e.getAspect() == $("widgets")) {
			Iterator i = _blockValues.values().iterator();
			while (i.hasNext()) {
				((StBlockValue) i.next()).computeValue();
			}
		} else {
			super.update_(e);
		}
	}

}
