package jp.co.sra.jun.topology.globaloperators;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.geometry.abstracts.JunCurve;
import jp.co.sra.jun.geometry.abstracts.JunSurface;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.topology.abstracts.JunAbstractOperator;
import jp.co.sra.jun.topology.abstracts.JunGlobalOperator;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoop;
import jp.co.sra.jun.topology.elements.JunVertex;

/**
 * JunMOVE class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMOVE.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMOVE extends JunGlobalOperator {
	protected Jun3dPoint vector;

	/**
	 * Create a new instance of JunMOVE and initialize it with a body.
	 * 
	 * @param aJunBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aJun3dPoint DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static final JunMOVE Body_vector_(JunBody aJunBody, Jun3dPoint aJun3dPoint) {
		JunMOVE anOperator = new JunMOVE();
		anOperator.body_(aJunBody);
		anOperator.vector_(aJun3dPoint);

		return anOperator;
	}

	/**
	 * Execute the receiver.
	 */
	public void execute() {
		final Jun3dTransformation translation = Jun3dTransformation.Translate_(this.vector());
		this.body().vertexesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunVertex vertex = (JunVertex) anObject;

				if (vertex.point() != null) {
					vertex.point_((Jun3dPoint) vertex.point().transform_(translation));
				}

				return null;
			}
		});
		this.body().edgesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunEdge edge = (JunEdge) anObject;
				Jun3dLine curve = (Jun3dLine) edge.basicCurve();

				if (curve != null) {
					edge.setCurve_((JunCurve) curve.transform_(translation));
				}

				return null;
			}
		});
		this.body().loopsDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunLoop loop = (JunLoop) anObject;
				Jun3dPolygon surface = (Jun3dPolygon) loop.basicSurface();

				if (surface != null) {
					loop.setSurface_((JunSurface) surface.transform_(translation));
				}

				return null;
			}
		});
	}

	/**
	 * Answer the inverse operator of the receiver.
	 * 
	 * @return jp.co.sra.jun.topology.abstracts.JunAbstractOperator
	 */
	public JunAbstractOperator inverse() {
		return JunMOVE.Body_vector_(this.body(), (Jun3dPoint) this.vector().negated());
	}

	/**
	 * Answer the vector.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public final Jun3dPoint vector() {
		return vector;
	}

	/**
	 * Set the vector.
	 * 
	 * @param aJun3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 */
	public final void vector_(Jun3dPoint aJun3dPoint) {
		vector = aJun3dPoint;
	}
}
