package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoop;
import jp.co.sra.jun.topology.elements.JunVertex;
import jp.co.sra.jun.topology.geometricoperators.JunTV;

/**
 * JunMVETestExamples class
 * 
 *  @author    ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMVETestExamples.java,v 8.11 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMVETestExamples extends jp.co.sra.jun.system.support.JunTestExamples {
	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();
		JunLoop loop = mevvl.newLoop();
		JunEdge edge = mevvl.newEdge();
		JunVertex v100 = mevvl.newVertex1();
		JunVertex v010 = mevvl.newVertex2();
		JunMEV mev = JunMEV.Body_vertex_loop_point_(body, v100, loop, new Jun3dPoint(0, 0, 0));
		mev.doOperation();
		JunVertex v000 = mev.newVertex();
		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, loop, v010, v000);
		mel.doOperation();
		JunMVE mve = JunMVE.Body_edge_point_newEdgeOnVertex_(body, edge, new Jun3dPoint(0.5, 0.5, 0), v100);
		mve.doOperation();
		body.show();
		JunVertex v550 = mve.newVertex();
		JunTV tv = JunTV.Body_vertex_vector_(body, v550, new Jun3dPoint(0.5, 0.5, 0));
		tv.doOperation();
		body.show();

		//#?# mve #newVertex #newEdge #edge2 #point
		System.out.println("-------- #point");
		System.out.println(mve.point());
		System.out.println("-------- #edge2");
		System.out.println(mve.edge2());
		System.out.println("-------- #newEdge");
		System.out.println(mve.newEdge());
		System.out.println("-------- #newVertex");
		System.out.println(mve.newVertex());

		return true;
	}

	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 1));
		mevvl.doOperation();
		// JunVertex v000 = mevvl.vertex1();
		// JunVertex v001 = mevvl.vertex2();

		JunEdge edge000001 = mevvl.edge();
		JunMVE mve = JunMVE.Body_edge_point_(body, edge000001, new Jun3dPoint(0, 1, 0));
		mve.doOperation();
		body.show();

		//return mve;
		return true;
	}

	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 1));
		mevvl.doOperation();
		// JunVertex v000 = mevvl.vertex1();
		JunVertex v001 = mevvl.vertex2();
		// JunEdge edge000001 = mevvl.edge();
		mevvl.edge();

		JunMEV mev1 = JunMEV.Body_vertex_loop_point_(body, v001, mevvl.loop(), new Jun3dPoint(0, 1, 0));
		mev1.doOperation();
		JunVertex v010 = mev1.vertex1();
		JunEdge edge001010 = mev1.edge();

		JunMEV mev2 = JunMEV.Body_vertex_loop_point_(body, v010, mevvl.loop(), new Jun3dPoint(1, 0, 0));
		mev2.doOperation();
		// JunVertex v100 = mev2.vertex1();
		// JunEdge edge010100 = mev2.edge();
		mev2.edge();

		JunMVE mve = JunMVE.Body_edge_point_(body, edge001010, new Jun3dPoint(1, 1, 1));
		mve.doOperation();
		body.show();

		return true;
	}

	/**
	 * Example.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 1));
		mevvl.doOperation();
		JunVertex v000 = mevvl.vertex1();
		JunVertex v001 = mevvl.vertex2();
		// JunEdge edge000001 = mevvl.edge();
		mevvl.edge();
		JunLoop loop1 = mevvl.loop();

		JunMEV mev1 = JunMEV.Body_vertex_loop_point_(body, v001, loop1, new Jun3dPoint(0, 1, 0));
		mev1.doOperation();
		JunVertex v010 = mev1.vertex1();
		JunEdge edge001010 = mev1.edge();

		JunMEV mev2 = JunMEV.Body_vertex_loop_point_(body, v010, loop1, new Jun3dPoint(1, 0, 0));
		mev2.doOperation();
		JunVertex v100 = mev2.vertex1();
		// JunEdge edge010100 = mev2.edge();
		mev2.edge();

		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, loop1, v100, v000);
		mel.doOperation();
		// JunEdge edge100000 = mel.edge();
		mel.edge();
		// JunLoop loop2 = mel.loop1();
		mel.loop1();

		JunMVE mve = JunMVE.Body_edge_point_(body, edge001010, new Jun3dPoint(1, 1, 1));
		mve.doOperation();
		body.show();

		//return mve;
		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunMVETestExamples();
	}
}
