package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.topology.elements.*;

/**
 * JunMDEVTestExamples class
 * 
 *  @author    BNR, ASTI Shanghai
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunMDEVTestExamples.java,v 8.10 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunMDEVTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example1() {
		JunBody body = new JunBody();
		JunMEVVL mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();

		//JunLoop loop1 = mevvl.newLoop();
		JunLoop loop1 = mevvl.loop();
		JunVertex vertex100 = mevvl.newVertex1();
		JunVertex vertex010 = mevvl.newVertex2();
		JunMEV mev = JunMEV.Body_vertex_loop_point_(body, vertex100, loop1, new Jun3dPoint(0, 0, 0));
		mev.doOperation();

		JunEdge edge1 = mev.newEdge();
		JunVertex vertex000 = mev.newVertex();
		JunMEL mel = JunMEL.Body_loop_vertex_vertex_(body, loop1, vertex010, vertex000);
		mel.doOperation();
		body.show();

		JunEdge edge2 = mel.newEdge();
		JunMDEV mdev = JunMDEV.Body_vertex_edge_edge_(body, vertex000, edge1, edge2);
		mdev.doOperation();
		body.show();
		System.out.println("-------- #newEdge");
		System.out.println(mdev.newEdge());
		System.out.println("-------- #newVertex");
		System.out.println(mdev.newVertex());

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @return DOCUMENT ME!
	 */
	public static boolean Example2() {
		JunBody body;
		JunVertex v000 = null;
		JunVertex v100 = null;
		JunVertex v010 = null;
		JunVertex v001 = null;
		JunEdge edge1;
		JunEdge edge2;
		JunMDEV mdev;
		Jun3dPoint[] a3dPoint = new Jun3dPoint[4];
		a3dPoint[0] = new Jun3dPoint(0, 0, 0);
		a3dPoint[1] = new Jun3dPoint(1, 0, 0);
		a3dPoint[2] = new Jun3dPoint(0, 1, 0);
		a3dPoint[3] = new Jun3dPoint(0, 0, 1);
		body = JunBody.Tetrahedron_(a3dPoint);

		JunVertex[] temp = body.vertexes();

		for (int i = 0; i < temp.length; i++) {
			if ((temp[i].point()).equals(new Jun3dPoint(0, 0, 0))) {
				v000 = temp[i];

				break;
			}
		}

		for (int i = 0; i < temp.length; i++) {
			if ((temp[i].point()).equals(new Jun3dPoint(1, 0, 0))) {
				v100 = temp[i];

				break;
			}
		}

		for (int i = 0; i < temp.length; i++) {
			if ((temp[i].point()).equals(new Jun3dPoint(0, 1, 0))) {
				v010 = temp[i];

				break;
			}
		}

		for (int i = 0; i < temp.length; i++) {
			if ((temp[i].point()).equals(new Jun3dPoint(0, 0, 1))) {
				v001 = temp[i];

				break;
			}
		}

		edge1 = body.edgeForVertex_and_(v000, v100);
		edge2 = body.edgeForVertex_and_(v000, v010);
		mdev = JunMDEV.Body_vertex_edge_edge_(body, v000, edge1, edge2);
		mdev.doOperation();
		mdev.vertex1().point_((new Jun3dPoint(0.5, -0.5, -0.5)));
		(JunMEL.Body_loop_vertex_vertex_(body, body.loopForVertex_and_(v001, v000), v001, v000)).doOperation();
		(JunMEL.Body_loop_vertex_vertex_(body, body.loopForVertex_and_(v000, v100), v000, v100)).doOperation();

		//	return body;
		body.show();

		return true;
	}

	/**
	 * DOCUMENT ME!
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunMDEVTestExamples();
	}
}
