package jp.co.sra.jun.topology.euleroperators;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.elements.JunEdge;
import jp.co.sra.jun.topology.elements.JunLoop;
import jp.co.sra.jun.topology.elements.JunVertex;

/**
 * JunKEMLTestExamples class
 * 
 *  @author    bnr
 *  @created   1999/07/29 (by BNR)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunKEMLTestExamples.java,v 8.11 2008/02/20 06:33:02 nisinaka Exp $
 */
public class JunKEMLTestExamples extends JunTestExamples {
	/**
	 * Insert the method's description here. Creation date: (7/29/99 5:21:59 PM)
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean example1() {
		System.out.println("JunKEMLTestExamples example1");

		JunMEVVL mevvl;
		JunMEVVL mevvl2;
		JunMEV mev;
		JunMEL mel;
		JunMEKL mekl;
		JunKEML keml;
		JunBody body = new JunBody();
		JunVertex vertex000;
		JunVertex vertex001;
		JunVertex vertex010;
		JunVertex vertex011;
		JunVertex vertex100;
		JunVertex vertex101;
		JunLoop loop1;
		JunLoop loop2;
		JunEdge edge;
		mevvl = JunMEVVL.Body_point_point_(body, new Jun3dPoint(1, 0, 0), new Jun3dPoint(0, 1, 0));
		mevvl.doOperation();
		vertex100 = mevvl.newVertex1();
		vertex010 = mevvl.newVertex2();
		loop1 = mevvl.loop();
		mev = JunMEV.Body_vertex_loop_point_(body, vertex100, loop1, new Jun3dPoint(0, 0, 0));
		mev.doOperation();
		vertex000 = mev.newVertex();
		mel = JunMEL.Body_loop_vertex_vertex_(body, mev.loop(), vertex010, vertex000);
		mel.doOperation();
		mevvl2 = JunMEVVL.Body_point_point_(new JunBody(), new Jun3dPoint(1, 0, 1), new Jun3dPoint(0, 1, 1));
		mevvl2.doOperation();
		loop2 = mevvl2.loop();
		vertex101 = mevvl2.newVertex1();
		vertex011 = mevvl2.newVertex2();
		mev = JunMEV.Body_vertex_loop_point_(body, vertex101, loop2, new Jun3dPoint(0, 0, 1));
		mev.doOperation();
		vertex001 = mev.newVertex();
		mel = JunMEL.Body_loop_vertex_vertex_(body, mev.loop(), vertex011, vertex001);
		mel.doOperation();
		mekl = JunMEKL.Body_killLoop_aliveLoop_vertex_vertex_(body, loop1, loop2, vertex000, vertex001);
		mekl.doOperation();
		edge = mekl.newEdge();
		keml = JunKEML.Body_edge_(body, edge);
		keml.doOperation();

		// #(#killedEdge #originalLoop #newLoop #vertex1 
		// #vertex2 #edge2 #edge3)
		System.out.println("\n-------- #killedEdge");
		System.out.println(keml.killedEdge());
		System.out.println("-------- #originalLoop");
		System.out.println(keml.originalLoop());
		System.out.println("\n-------- #newLoop");
		System.out.println(keml.newLoop());
		System.out.println("-------- #vertex1");
		System.out.println(keml.vertex1());
		System.out.println("\n-------- #vertex2");
		System.out.println(keml.vertex2());
		System.out.println("-------- #edge2");
		System.out.println(keml.edge2());
		System.out.println("\n-------- #edge3");
		System.out.println(keml.edge3());

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunKEMLTestExamples();
	}
}
