package jp.co.sra.jun.topology.elements;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.topology.abstracts.JunTopologicalElement;

/**
 * JunBodyTestExamples class
 * 
 *  @author    nisinaka
 *  @created   1999/01/05 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBodyTestExamples.java,v 8.11 2008/02/20 06:33:01 nisinaka Exp $
 */
public class JunBodyTestExamples extends jp.co.sra.jun.system.support.JunTestExamples {
	/**
	 * Execute all examples.
	 * 
	 * @param args an array of command-line arguments
	 * @category Main
	 */
	public static void main(java.lang.String[] args) {
		new JunBodyTestExamples();
	}

	/**
	 * Test for JunBody#RotationSweep2dPoints_divisions_(Jun2dPoint[], int).
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test1() {
		int divisions = 30;
		Jun2dPoint[] points = new Jun2dPoint[divisions + 1];

		for (int i = 0; i <= divisions; i++) {
			JunAngle angle = JunAngle.FromDeg_((360 * i) / divisions);
			points[i] = new Jun2dPoint(angle.cos(), angle.sin() + 2.0d);
		}

		JunBody body = JunBody.RotationSweep2dPoints_divisions_(points, divisions);
		body.show();

		return false;
	}

	/**
	 * Test for JunBody#copy().
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test2() {
		Jun3dPoint[] points = { new Jun3dPoint(0, 0, 0), new Jun3dPoint(1.5, 0, 0), new Jun3dPoint(0, 1.5, 0), new Jun3dPoint(0, 0, 1.5) };
		JunBody body = JunBody.Tetrahedron_(points);
		body.showLispList();

		JunBody body2 = (JunBody) body.copy();
		body2.asJunOpenGL3dObject().show();

		return false;
	}

	/**
	 * Test for JunBody#copy().
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Test3() {
//		((JunTopologicalElement) JunBody.UnitPyramidArrayDivisions_(4)[0]).show();
		((JunTopologicalElement) JunBody.UnitPyramidArrayDivisions_(4)[1]).show();

		return true;
	}
}
