package jp.co.sra.jun.system.support;

import java.awt.Dimension;

import jp.co.sra.jun.goodies.display.JunDisplayView;

/**
 * JunLauncherView interface
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2003/03/20 (by Mitsuhiro Asada)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2007/03/12 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun473 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunLauncherView.java,v 8.12 2008/02/20 06:32:59 nisinaka Exp $
 */
public interface JunLauncherView extends JunDisplayView {

	/**
	 * Open a banner.
	 *
	 * @param visual java.lang.Object
	 * @category utilities
	 */
	public void _openBanner(Object visual);

	/**
	 * Open a dialog.
	 *
	 * @param title java.lang.String
	 * @param visual java.lang.Object
	 * @param size java.awt.Dimension
	 * @category utilities
	 */
	public void _openDialog_(final String title, final Object visual, final Dimension size);

	/**
	 * Open a text viewer.
	 *
	 * @param title java.lang.String
	 * @param message java.lang.String 
	 * @param size java.awt.Dimension
	 * @category utilities
	 */
	public void _openTextViewer_(final String title, final String message, final Dimension size);

}
