package jp.co.sra.jun.system.framework;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunDialogTestExamples class
 * 
 *  @author    
 *  @created   UNKNOWN
 *  @updated   2006/04/19 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDialogTestExamples.java,v 8.10 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunDialogTestExamples extends JunTestExamples {

	/**
	 * Example to choose.
	 * 
	 * @return boolean
	 */
	public static boolean Example_choose() {
		System.out.println(JunDialog.Choose_($String("Are you tired yet?"), new String[] { "absolutely", "sort of", "not really" }, new Object[] { $("yes"), $("maybe"), $("no") }, $("maybe")));
		return true;
	}

	/**
	 * Example to choose from list.
	 * 
	 * @return boolean
	 */
	public static boolean Example_chooseFromList() {
		System.out.println(JunDialog.Choose_($String("Which one do you want?"), new String[] { "first", "second", "third", "fourth" }, new Object[] { new Integer(1), new Integer(2), new Integer(3), new Integer(4) }, new String[] { "Frobits" },
				new Object[] { null }, 8, new StBlockClosure() {
					public Object value() {
						return $("noChoice");
					}
				}));
		return true;
	}

	/**
	 * Example to confirm.
	 * 
	 * @return boolean
	 */
	public static boolean Example_confirm() {
		System.out.println(JunDialog.Confirm_($String("Are you happy?")));
		return true;
	}

	/**
	 * Example to request.
	 * 
	 * @return boolean
	 */
	public static boolean Example_request() {
		System.out.println(JunDialog.Request_($String("What is your name?"), JunSystem.$String("Yoshiyuki NISHINAKA")));
		return true;
	}

	/**
	 * Example to warn.
	 * 
	 * @return boolean
	 */
	public static boolean Example_warn() {
		System.out.println(JunDialog.Warn_(JunSystem.$String("This is a fatal error.")));
		return true;
	}

	/**
	 * Execute the test examples.
	 *
	 * @param args java.lang.String[]
	 */
	public static void main(String[] args) {
		new JunDialogTestExamples();
	}
}
