package jp.co.sra.jun.system.dialog;

import java.awt.Component;
import java.awt.Rectangle;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StBlockValue;
import jp.co.sra.smalltalk.StRectangle;
import jp.co.sra.smalltalk.StValueHolder;
import jp.co.sra.smalltalk.StView;

/**
 * JunTextInputField class
 * 
 *  @author    nisinaka
 *  @created   2006/10/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunTextInputField.java,v 8.10 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunTextInputField extends JunPopUpDialog {

	protected StValueHolder textHolder;
	protected String initialAnswer;
	protected StBlockClosure checkBlock;

	/**
	 * Popup the dialog and return the value.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String PopUpIn_(Rectangle aRectangle) {
		JunTextInputField aDialog = new JunTextInputField();
		aDialog.popUpIn_(new StRectangle(aRectangle));
		return (String) aDialog.answer();
	}

	/**
	 * Popup the dialog and return the value.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String PopUpIn_initialAnswer_(Rectangle aRectangle, String aString) {
		JunTextInputField aDialog = new JunTextInputField();
		aDialog.initialAnswer_(aString);
		aDialog.popUpIn_(new StRectangle(aRectangle));
		return (String) aDialog.answer();
	}

	/**
	 * Popup the dialog and return the value.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @param aComponent java.awt.Component
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String PopUpIn_forView_(Rectangle aRectangle, Component aComponent) {
		JunTextInputField aDialog = new JunTextInputField();
		aDialog.popUpIn_forView_(aRectangle, aComponent);
		return (String) aDialog.answer();
	}

	/**
	 * Popup the dialog and return the value.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @param aComponent java.awt.Component
	 * @param aString java.lang.String
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String PopUpIn_forView_initialAnswer_(Rectangle aRectangle, Component aComponent, String aString) {
		JunTextInputField aDialog = new JunTextInputField();
		aDialog.initialAnswer_(aString);
		aDialog.popUpIn_forView_(aRectangle, aComponent);
		return (String) aDialog.answer();
	}

	/**
	 * Popup the dialog and return the value.
	 * 
	 * @param aComponent java.awt.Component
	 * @param aString java.lang.String
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String PopUpForView_initialAnswer_(Component aComponent, String aString) {
		JunTextInputField aDialog = new JunTextInputField();
		aDialog.initialAnswer_(aString);
		aDialog.popUpForView_(aComponent);
		return (String) aDialog.answer();
	}

	/**
	 * Answer the size of the line grid.
	 * 
	 * @return int
	 * @category Utilities
	 */
	public static int LineGrid() {
		return 14;
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.smalltalk.StSimpleDialog#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		textHolder = null;
		initialAnswer = "";
		checkBlock = new StBlockClosure();
	}

	/**
	 * Answer my value.
	 * 
	 * @return java.lang.Object
	 * @see jp.co.sra.jun.system.dialog.JunPopUpDialog#answer()
	 * @category accessing
	 */
	public Object answer() {
		return this.string();
	}

	/**
	 * Answer my current string value.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String string() {
		return this.asString();
	}

	/**
	 * Set my new string value.
	 * 
	 * @param aString java.lang.String
	 * @category accessing
	 */
	public void string_(String aString) {
		this.textHolder().value_(aString);
	}

	/**
	 * Answer my text holder.
	 * 
	 * @return jp.co.sra.smalltalk.StValueHolder
	 * @category aspects
	 */
	protected StValueHolder textHolder() {
		if (textHolder == null) {
			textHolder = new StValueHolder("");
		}
		return textHolder;
	}

	/**
	 * Answer a StBlockValue that computes aBlock with the receiver's value as the argument.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.smalltalk.StBlockValue
	 * @category constructing
	 */
	public StBlockValue compute_(StBlockClosure aBlock) {
		return this.textHolder().compute_(aBlock);
	}

	/**
	 * Set a block closure for checking.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category constructing
	 */
	public void check_(StBlockClosure aBlock) {
		checkBlock = aBlock;
	}

	/**
	 * Convert the receiver to a string.
	 * 
	 * @return java.lang.String
	 * @category converting
	 */
	public String asString() {
		return (String) this.textHolder().value();
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.jun.system.dialog.JunPopUpDialog#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunTextInputFieldViewAwt(this);
		} else {
			return new JunTextInputFieldViewSwing(this);
		}
	}

	/**
	 * Popup the receiver in the specified size and place.
	 * 
	 * @param aRectangle jp.co.sra.smalltalk.StRectangle
	 * @param aString java.lang.String
	 * @category interface opening
	 */
	public void popUpIn_initialAnswer_(StRectangle aRectangle, String aString) {
		this.initialAnswer_(aString);
		this.popUpIn_(aRectangle);
	}

	/**
	 * Set my initial answer.
	 * 
	 * @param aString java.lang.String
	 * @category private
	 */
	protected void initialAnswer_(String aString) {
		initialAnswer = aString;
		this.string_(initialAnswer);
	}

	/**
	 * Action when closing by the ESC key.
	 * 
	 * @see jp.co.sra.jun.system.dialog.JunPopUpDialog#actionByESC()
	 * @category private
	 */
	protected void actionByESC() {
		this.string_(initialAnswer);
	}

	/**
	 * Check for the character.
	 * 
	 * @param keyChar char
	 * @return boolean
	 * @see jp.co.sra.jun.system.dialog.JunPopUpDialog#checkCharacter_(char)
	 * @category private 
	 */
	protected boolean checkCharacter_(final char keyChar) {
		Thread aThread = new Thread() {
			public void run() {
				Thread.yield();

				int numberOfArguments = checkBlock.numArgs();
				switch (numberOfArguments) {
					case 0:
						checkBlock.value();
						break;
					case 1:
						checkBlock.value_(new Character(keyChar));
						break;
					case 2:
						checkBlock.value_value_(new Character(keyChar), string());
						break;
				}
			}
		};
		aThread.start();

		return super.checkCharacter_(keyChar);
	}

}
