package jp.co.sra.jun.system.dialog;

import java.awt.Component;
import java.awt.Dialog;

import jp.co.sra.smalltalk.StController;
import jp.co.sra.smalltalk.StSimpleDialogViewSwing;

/**
 * JunPopUpDialogViewSwing class
 * 
 *  @author    nisinaka
 *  @created   2006/10/16 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPopUpDialogViewSwing.java,v 8.14 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunPopUpDialogViewSwing extends StSimpleDialogViewSwing implements JunPopUpDialogView {

	/**
	 * Create a new instance of JunPopUpDialogViewAwt and initialize it.
	 *
	 * @param aPopUpDialog jp.co.sra.jun.system.dialog.JunPopUpDialog
	 * @category Instance creation
	 */
	public JunPopUpDialogViewSwing(JunPopUpDialog aPopUpDialog) {
		super(aPopUpDialog);
	}

	/**
	 * Answer my model as JunPopUpDialog.
	 * 
	 * @return jp.co.sra.jun.system.dialog.JunPopUpDialog
	 * @see jp.co.sra.jun.system.dialog.JunPopUpDialogView#getPopUpDialog()
	 * @category model accessing
	 */
	public JunPopUpDialog getPopUpDialog() {
		return (JunPopUpDialog) this.model();
	}

	/**
	 * Answer my default controller. Subclasses may override this.
	 * 
	 * @return jp.co.sra.smalltalk.StController
	 * @see jp.co.sra.smalltalk.StViewJPanel#defaultController()
	 * @category controller accessing
	 */
	protected StController defaultController() {
		return new JunPopUpDialogController();
	}

	/**
	 * Create a default dialog.
	 *
	 * @param aComponentOrNull java.awt.Component
	 * @see jp.co.sra.smalltalk.StSimpleDialogViewAwt#defaultDialog()
	 * @return java.awt.Dialog
	 */
	public Dialog defaultDialog() {
		return this.defaultDialog(this.getPopUpDialog()._viewComponent());
	}

	/**
	 * Create a default dialog.
	 *
	 * @param aComponentOrNull java.awt.Component
	 * @return java.awt.Dialog
	 * @see jp.co.sra.smalltalk.StSimpleDialogView#defaultDialog(java.awt.Component)
	 * @category defaults
	 */
	public Dialog defaultDialog(Component aComponentOrNull) {
		return this.defaultDialog(aComponentOrNull, true);
	}

	/**
	 * Answer my focused component.
	 * 
	 * @return java.awt.Component
	 * @see jp.co.sra.jun.system.dialog.JunPopUpDialogView#getFocusedComponent()
	 * @category user interface
	 */
	public Component _focusedComponent() {
		return this;
	}

}
