package jp.co.sra.jun.opengl.texture;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;

import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.goodies.image.support.JunImageProcessor;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunOpenGLStipple class
 * 
 *  @author    nisinaka
 *  @created   1998/10/13 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLStipple.java,v 8.14 2008/02/20 06:32:50 nisinaka Exp $
 */
public class JunOpenGLStipple extends JunAbstractObject {

	protected static HashMap HalftoneStipples = null;

	protected StImage stippleImage;
	protected byte[] cachedPixels;

	/**
	 * Create a new instance of JunOpenGLStipple and initialize it.
	 *
	 * @param anImage java.awt.Image
	 * @category Instance creation
	 */
	public JunOpenGLStipple(Image anImage) {
		super();
		this.image_(new StImage(anImage));
	}

	/**
	 * Create a new instance of JunOpenGLStipple and initialize it.
	 *
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @category Instance creation
	 */
	public JunOpenGLStipple(StImage anImage) {
		super();
		this.image_(anImage);
	}

	/**
	 *  Create a new instance of JunOpenGLStipple with default halftone scale.
	 * 
	 * @return jp.co.sra.jun.opengl.texture.JunOpenGLStipple
	 * @category Instance creation
	 */
	public static JunOpenGLStipple Halftone() {
		return Halftone_(0.5);
	}

	/**
	 * Create a new instance of JunOpenGLStipple with the specified halftone scale.
	 * 
	 * @param halftoneScale double
	 * @return jp.co.sra.jun.opengl.texture.JunOpenGLStipple
	 * @category Instance creation
	 */
	public static JunOpenGLStipple Halftone_(double halftoneScale) {
		double halftone = Math.max(0, (Math.min(halftoneScale, 1)));
		if (HalftoneStipples == null) {
			HalftoneStipples = new HashMap();
			for (int index = 0; index <= 8; index++) {
				double key = index / 8.0f;
				JunOpenGLStipple value = JunOpenGLStipple.Image_(JunImageProcessor.Halftone_(key));
				HalftoneStipples.put(new Double(key), value);
			}
		}

		JunOpenGLStipple stipple = null;
		Double key = new Double(halftone);
		if (HalftoneStipples.containsKey(key)) {
			stipple = (JunOpenGLStipple) HalftoneStipples.get(key);
		} else {
			stipple = new JunOpenGLStipple(JunImageProcessor.Halftone_(halftone));
		}
		return stipple;
	}

	/**
	 * Create a new instance of JunOpenGLStipple with the specified image.
	 * 
	 * @param anImage java.awt.Image
	 * @return jp.co.sra.jun.opengl.texture.JunOpenGLStipple
	 * @category Instance creation
	 */
	public static JunOpenGLStipple Image_(Image anImage) {
		return new JunOpenGLStipple(anImage);
	}

	/**
	 * Create a new instance of JunOpenGLStipple with the specified image.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @return jp.co.sra.jun.opengl.texture.JunOpenGLStipple
	 * @category Instance creation
	 */
	public static JunOpenGLStipple Image_(StImage anImage) {
		return new JunOpenGLStipple(anImage);
	}

	/**
	 * Answer my current image.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category accessing
	 */
	public StImage image() {
		if (stippleImage == null) {
			stippleImage = JunImageProcessor.Halftone_(0.5);
		}
		return stippleImage;
	}

	/**
	 * Set my new image.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @category accessing
	 */
	public void image_(StImage anImage) {
		if (anImage.width() == 0 || anImage.height() == 0) {
			return;
		}

		stippleImage = this.convertToStippleImage_(anImage);
		this.flushPointerOfPixels();
	}

	/**
	 * Answer the cached pixels.
	 * 
	 * @return byte[]
	 * @category externals
	 */
	public byte[] pointerOfPixels() {
		if (cachedPixels == null) {
			int[] bits = this._hexedBits();
			byte[] bytes = new byte[bits.length];
			for (int index = 0; index < bits.length; index++) {
				bytes[index] = (byte) bits[index];
			}

			cachedPixels = bytes;
		}
		return cachedPixels;
	}

	/**
	 * Flush the cached pixels.
	 * 
	 * @category externals
	 */
	protected void flushPointerOfPixels() {
		cachedPixels = null;
	}

	/**
	 * Enable the stipple on the rendering context.
	 * 
	 * @param renderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @category stipple
	 */
	public void enableStippleOn_(JunOpenGLRenderingContext renderingContext) {
		renderingContext.polygonStipple_(this);
		renderingContext.enablePolygonStipple();
	}

	/**
	 * Disable the stipple on the rendering context.
	 * 
	 * @param renderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @category stipple
	 */
	public void disableStippleOn_(JunOpenGLRenderingContext renderingContext) {
		renderingContext.disablePolygonStipple();
	}

	/**
	 * Hexagonal bits.  In StImage, all images has 24bit bits in natural (even
	 * if B/W).  But in some situation, some methods expect 8 bit bits.  This
	 * method returns it.
	 * 
	 * @return int[]
	 * @category private
	 */
	protected int[] _hexedBits() {
		StImage anImage = this.image();
		int rowByteSize = 4;
		int width = anImage.width();
		int height = anImage.height();
		int[] pixels = anImage.getPixels();
		int[] hexedBits = new int[rowByteSize * height];
		for (int y = 0; y < height; y++) {
			for (int x = 0; x < width; x++) {
				int pixel = pixels[(y * width) + x];
				if (pixel != -1) {
					int dX = x / 8;
					hexedBits[(y * rowByteSize) + dX] = hexedBits[(y * rowByteSize) + dX] + (int) Math.pow(2, (7 - (x % 8)));
				}
			}
		}
		return hexedBits;
	}

	/**
	 * In JAVA, StImage does not require palette matching (in Bit Operations).
	 * So method "convertToStippleImage_()" does not use this method. This is
	 * why this method is empty stub method. Please refer to the corresponding
	 * method in Smalltalk.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @return jp.co.sra.smalltalk.StImage
	 * @category private
	 */
	protected StImage convertToBitmap_(StImage anImage) {
		return anImage;
	}

	/**
	 * Convert the image to a stipple image.
	 * 
	 * @param anImage jp.co.sra.smalltalk.StImage
	 * @return StImage jp.co.sra.smalltalk.StImage
	 * @category private
	 */
	protected StImage convertToStippleImage_(StImage anImage) {
		StImage maskImage = new StImage(32, 32);
		maskImage.tile_from_in_rule_(new Rectangle(0, 0, 32, 32), new Point(0, 0), anImage, StImage.Over);
		return maskImage;
	}

}
