package jp.co.sra.jun.opengl.parameterizedbody;

import java.awt.Color;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.goodies.parameter.JunParameter;
import jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.system.support.JunSystem;
import jp.co.sra.jun.system.support.JunTestExamples;
import jp.co.sra.jun.topology.elements.JunBody;
import jp.co.sra.jun.topology.globaloperators.*;

/**
 * JunParameterizedBodyTestExamples class
 * 
 *  @author    UNKNOWN
 *  @created   UNKNOWN
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunParameterizedBodyTestExamples.java,v 8.11 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunParameterizedBodyTestExamples extends JunTestExamples {
	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunParameterizedBody aParameterizedBody;

		aParameterizedBody = JunParameterizedBody.Name_with_with_with_with_("chair", JunPaintedBody.Name_body_paint_("foot", JunBody.CubeOrigin_corner_(new Jun3dPoint(-3.5, -3.5, -4), new Jun3dPoint(3.5, 3.5, -3)), Color.blue), JunPaintedBody
				.Name_body_paint_("leg", JunBody.CubeOrigin_corner_(new Jun3dPoint(-0.5, -0.5, -3), new Jun3dPoint(0.5, 0.5, 3)), Color.green), JunPaintedBody.Name_body_paint_("seat", JunBody.CubeOrigin_corner_(new Jun3dPoint(-4, -4, 3), new Jun3dPoint(4,
				4, 4)), Color.yellow), JunPaintedBody.Name_body_paint_("back", JunBody.CubeOrigin_corner_(new Jun3dPoint(-5, -4, 6), new Jun3dPoint(-4, 4, 12)), Color.red));
		aParameterizedBody.show();

		return true;
	}

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunParameter height;
		JunParameterizedOperator scaleOperator;
		JunParameterizedOperator moveOperator;
		JunParameterizedBody aParameterizedBody;

		height = new JunParameter("height", new double[] { 6, 3, 12 }, JunSystem.$String("Height"));
		scaleOperator = JunParameterizedOperator.Parameter_sExpression_(height, "(PlaneSCALE 0 0 -3 0 0 1 (/ height 6))");
		moveOperator = JunParameterizedOperator.Parameter_sExpression_(height, "(MOVE 0 0 (- height 6))");
		aParameterizedBody = JunParameterizedBody.Name_with_with_with_("chair", JunPaintedBody.Name_body_paint_("foot", JunBody.CubeOrigin_corner_(new Jun3dPoint(-3.5, -3.5, -4), new Jun3dPoint(3.5, 3.5, -3)), Color.blue), JunParameterizedBody
				.Name_parameterizedOperator_with_("scaled leg", scaleOperator, JunPaintedBody.Name_body_paint_("leg", JunBody.CubeOrigin_corner_(new Jun3dPoint(-0.5, -0.5, -3), new Jun3dPoint(0.5, 0.5, 3)), Color.green)), JunParameterizedBody
				.ParameterizedOperator_with_with_(moveOperator, JunPaintedBody.Name_body_paint_("seat", JunBody.CubeOrigin_corner_(new Jun3dPoint(-4, -4, 3), new Jun3dPoint(4, 4, 4)), Color.yellow), JunPaintedBody.Name_body_paint_("back", JunBody
						.CubeOrigin_corner_(new Jun3dPoint(-5, -4, 6), new Jun3dPoint(-4, 4, 12)), Color.red)));
		aParameterizedBody.show();

		return true;
	}

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunParameter height;
		JunParameter angle;
		JunParameterizedOperator scaleOperator;
		JunParameterizedOperator moveOperator;
		JunParameterizedOperator rotateOperator;
		JunParameterizedBody aParameterizedBody;

		height = new JunParameter("height", new double[] { 6, 3, 12 }, JunSystem.$String("Height"));
		angle = new JunParameter("angle", new double[] { 15, 0, 60 }, JunSystem.$String("Angle"));
		scaleOperator = JunParameterizedOperator.Parameter_sExpression_(height, "(PlaneSCALE 0 0 -3 0 0 1 (/ height 6))");
		moveOperator = JunParameterizedOperator.Parameter_sExpression_(height, "(MOVE 0 0 (- height 6))");
		rotateOperator = JunParameterizedOperator.Parameter_sExpression_(angle, "(ROTATEDeg -4 0 4 0 1 0 (- 0 angle))");
		aParameterizedBody = JunParameterizedBody.Name_with_with_with_("chair", JunPaintedBody.Name_body_paint_("foot", JunBody.CubeOrigin_corner_(new Jun3dPoint(-3.5, -3.5, -4), new Jun3dPoint(3.5, 3.5, -3)), Color.blue), JunParameterizedBody
				.Name_parameterizedOperator_with_("scaled leg", scaleOperator, JunPaintedBody.Name_body_paint_("leg", JunBody.CubeOrigin_corner_(new Jun3dPoint(-0.5, -0.5, -3), new Jun3dPoint(0.5, 0.5, 3)), Color.green)), JunParameterizedBody
				.ParameterizedOperator_with_with_(moveOperator, JunPaintedBody.Name_body_paint_("seat", JunBody.CubeOrigin_corner_(new Jun3dPoint(-4, -4, 3), new Jun3dPoint(4, 4, 4)), Color.yellow), JunParameterizedBody.Name_parameterizedOperator_with_(
						"leaned back", rotateOperator, JunPaintedBody.Name_body_paint_("back", JunBody.CubeOrigin_corner_(new Jun3dPoint(-5, -4, 6), new Jun3dPoint(-4, 4, 12)), Color.red))));
		aParameterizedBody.show();

		return true;
	}

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunParameter footsize;
		JunParameter height;
		JunParameter width;
		JunParameter depth;
		JunParameter angle;
		JunParameterizedBody aParameterizedBody;

		footsize = new JunParameter("footsize", new double[] { 7, 2, 12, 1 }, JunSystem.$String("Foot Size"));
		height = new JunParameter("height", new double[] { 6, 3, 12, 1 }, JunSystem.$String("Height"));
		width = new JunParameter("width", new double[] { 8, 2, 12, 1 }, JunSystem.$String("Width"));
		depth = new JunParameter("depth", new double[] { 8, 2, 12, 1 }, JunSystem.$String("Depth"));
		angle = new JunParameter("angle", new double[] { 15, 0, 60, 5 }, JunSystem.$String("Angle"));
		aParameterizedBody = JunParameterizedBody.Name_with_with_with_("chair", JunParameterizedBody.Name_parameterizedOperator_with_("scaled foot", JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { footsize },
				"(LineSCALE 0 0 -3.5 0 0 1 (/ footsize 7))"), JunPaintedBody.Name_body_paint_("foot", JunBody.CubeOrigin_corner_(new Jun3dPoint(-3.5, -3.5, -4), new Jun3dPoint(3.5, 3.5, -3)), Color.blue)), JunParameterizedBody
				.Name_parameterizedOperator_with_("scaled leg", JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { height }, "(PlaneSCALE 0 0 -3 0 0 1 (/ height 6))"), JunPaintedBody.Name_body_paint_("leg", JunBody.CubeOrigin_corner_(
						new Jun3dPoint(-0.5, -0.5, -3), new Jun3dPoint(0.5, 0.5, 3)), Color.green)), JunParameterizedBody.ParameterizedOperator_with_with_(JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { height },
				"(MOVE 0 0 (- height 6))"), JunParameterizedBody.Name_parameterizedOperator_with_("scaled seat", JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { width, depth },
				"(COMPOUND (PlaneSCALE 0 0 3.5 0 1 0 (/ width 8)) (PlaneSCALE 0 0 3.5 1 0 0 (/ depth 8)))"), JunPaintedBody.Name_body_paint_("seat", JunBody.CubeOrigin_corner_(new Jun3dPoint(-4, -4, 3), new Jun3dPoint(4, 4, 4)), Color.yellow)),
				JunParameterizedBody.Name_parameterizedOperator_with_("leaned back", JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { width, angle, depth },
						"(COMPOUND (PlaneSCALE -4 0 4 0 1 0 (/ width 8)) (ROTATEDeg -4 0 4 0 1 0 (- 0 angle)) (MOVE (/ (- 8 depth) 2) 0 0))"), JunPaintedBody.Name_body_paint_("back", JunBody.CubeOrigin_corner_(new Jun3dPoint(-5, -4, 6), new Jun3dPoint(-4,
						4, 12)), Color.red))));
		aParameterizedBody.show();

		return true;
	}

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		_CreateDataForExample5().show();

		return true;
	}

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		_CreateDataForExample6().show();

		return true;
	}

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6Flux() {
		JunParameterizedBody aParameterizedBody;
		JunOpenGL3dCompoundObject objects;
		JunOpenGLFluxMutableObject flux;

		aParameterizedBody = _CreateDataForExample6();
		objects = new JunOpenGL3dCompoundObject();

		for (int each = 0; each <= 90; each += 5) {
			aParameterizedBody.namedParameter_value_("spin1", each);
			aParameterizedBody.namedParameter_value_("fold1", each);
			aParameterizedBody.namedParameter_value_("spin2", each);
			aParameterizedBody.namedParameter_value_("fold2", each);
			aParameterizedBody.namedParameter_value_("spin3", each);
			objects.add_(aParameterizedBody.asJunOpenGL3dObject());
		}

		for (int each = 90; 0 <= each; each -= 5) {
			aParameterizedBody.namedParameter_value_("spin1", each);
			objects.add_(aParameterizedBody.asJunOpenGL3dObject());
		}

		for (int each = 90; 0 <= each; each -= 5) {
			aParameterizedBody.namedParameter_value_("fold1", each);
			objects.add_(aParameterizedBody.asJunOpenGL3dObject());
		}

		for (int each = 90; 0 <= each; each -= 5) {
			aParameterizedBody.namedParameter_value_("spin2", each);
			objects.add_(aParameterizedBody.asJunOpenGL3dObject());
		}

		for (int each = 90; 0 <= each; each -= 5) {
			aParameterizedBody.namedParameter_value_("fold2", each);
			objects.add_(aParameterizedBody.asJunOpenGL3dObject());
		}

		for (int each = 90; 0 <= each; each -= 5) {
			aParameterizedBody.namedParameter_value_("spin3", each);
			objects.add_(aParameterizedBody.asJunOpenGL3dObject());
		}

		flux = new JunOpenGLFluxMutableObject(objects);
		flux.show();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunParameterizedBodyTestExamples();
	}

	/**
	 * Create data for Example5.
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 * @category Private
	 */
	protected static JunParameterizedBody _CreateDataForExample5() {
		JunParameter footsize;
		JunParameter height;
		JunParameter width;
		JunParameter depth;
		JunParameter angle;
		JunBody unitCube;
		JunParameterizedBody aParameterizedBody;

		footsize = new JunParameter("footsize", new double[] { 7, 2, 12, 1 }, JunSystem.$String("Foot Size"));
		height = new JunParameter("height", new double[] { 6, 3, 12, 1 }, JunSystem.$String("Height"));
		width = new JunParameter("width", new double[] { 8, 2, 12, 1 }, JunSystem.$String("Width"));
		depth = new JunParameter("depth", new double[] { 8, 2, 12, 1 }, JunSystem.$String("Depth"));
		angle = new JunParameter("angle", new double[] { 15, 0, 60, 5 }, JunSystem.$String("Angle"));
		unitCube = JunBody.CubeOrigin_corner_(new Jun3dPoint(-0.5, -0.5, -0.5), new Jun3dPoint(0.5, 0.5, 0.5));
		aParameterizedBody = JunParameterizedBody.Name_with_with_with_("chair", JunParameterizedBody.Name_parameterizedOperator_with_("foot", JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { footsize },
				"(COMPOUND (LineSCALE 0 0 0 0 0 1 footsize) (MOVE 0 0 -3.5))"), JunPaintedBody.Body_paint_(unitCube, Color.blue)), JunParameterizedBody.Name_parameterizedOperator_with_("leg", JunParameterizedOperator.Parameters_sExpression_(
				new JunParameter[] { height }, "(COMPOUND (PlaneSCALE 0 0 -0.5 0 0 1 height) (MOVE 0 0 -2.5))"), JunPaintedBody.Body_paint_(unitCube, Color.green)), JunParameterizedBody.ParameterizedOperator_with_with_(JunParameterizedOperator
				.Parameters_sExpression_(new JunParameter[] { height }, "(MOVE 0 0 (- height 2.5))"), JunParameterizedBody.Name_parameterizedOperator_with_("seat", JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { width, depth },
				"(COMPOUND (PlaneSCALE 0 0 0 0 1 0 width) (PlaneSCALE 0 0 0 1 0 0 depth))"), JunPaintedBody.Body_paint_(unitCube, Color.yellow)), JunParameterizedBody.Name_parameterizedOperator_with_("back", JunParameterizedOperator
				.Parameters_sExpression_(new JunParameter[] { width, angle, depth }, "(COMPOUND (MOVE -0.5 0 2.5) (PlaneSCALE 0 0 0 0 1 0 width) (PlaneSCALE 0 0 2 0 0 1 6) (ROTATEDeg 0 0 0 0 1 0 (- 0 angle)) (MOVE (- 0 (/ depth 2)) 0 0.5))"),
				JunPaintedBody.Body_paint_(unitCube, Color.red))));

		return aParameterizedBody;
	}

	/**
	 * Create data for Example6.
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunParameterizedBody
	 * @category Private
	 */
	protected static JunParameterizedBody _CreateDataForExample6() {
		double segmentLength;
		int cylinderDiviisions;
		JunParameter spin1;
		JunParameter fold1;
		JunParameter spin2;
		JunParameter fold2;
		JunParameter spin3;
		JunBody unitCube;
		JunBody segment;
		JunBody cylinder;
		JunParameterizedBody carpal;
		JunParameterizedBody antebrachii;
		JunParameterizedBody humerus;
		JunParameterizedBody aParameterizedBody;

		segmentLength = 2;
		cylinderDiviisions = 8;
		spin1 = new JunParameter("spin1", new double[] { 0, -90, 90, 10 }, JunSystem.$String("Spin") + "1");
		fold1 = new JunParameter("fold1", new double[] { 0, 0, 90, 5 }, JunSystem.$String("Fold") + "1");
		spin2 = new JunParameter("spin2", new double[] { 0, -90, 90, 10 }, JunSystem.$String("Spin") + "2");
		fold2 = new JunParameter("fold2", new double[] { 0, 0, 90, 5 }, JunSystem.$String("Fold") + "2");
		spin3 = new JunParameter("spin3", new double[] { 0, -90, 90, 10 }, JunSystem.$String("Spin") + "3");
		unitCube = JunBody.CubeOrigin_corner_(new Jun3dPoint(-0.5, -0.5, -0.5), new Jun3dPoint(0.5, 0.5, 0.5));

		//segment = (JunBody) unitCube.copy();
		segment = JunBody.CubeOrigin_corner_(new Jun3dPoint(-0.5, -0.5, -0.5), new Jun3dPoint(0.5, 0.5, 0.5));
		JunLineSCALE.Body_point_vector_factor_(segment, new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 1), 0.8).doOperation();
		JunPlaneSCALE.Body_point_vector_factor_(segment, new Jun3dPoint(0, 0, -0.5), new Jun3dPoint(0, 0, 1), segmentLength).doOperation();
		cylinder = (JunBody) JunBody.UnitCylinderArrayDivisions_(cylinderDiviisions)[0];
		JunPointSCALE.Body_factor_(cylinder, 0.4).doOperation();
		JunPlaneSCALE.Body_point_vector_factor_(cylinder, new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 1), 0.9).doOperation();
		JunROTATE.Body_point_vector_angle_(cylinder, new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0), JunAngle.FromDeg_(90)).doOperation();
		carpal = JunParameterizedBody.Name_parameterizedOperator_with_("carpal", JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { spin3 }, "(COMPOUND (ROTATEDeg 0 0 0 0 0 1 spin3) (MOVE 0 0 " + segmentLength + "))"), JunPaintedBody
				.Body_paint_(cylinder, new Color(159, 31, 223)));
		// Color purple
		antebrachii = JunParameterizedBody.Name_parameterizedOperator_with_with_("antebrachii", JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { spin2 }, "(COMPOUND (ROTATEDeg 0 0 0 0 0 1 spin2) (MOVE 0 0 " + segmentLength + "))"),
				JunPaintedBody.Body_paint_(cylinder, new Color(255, 127, 0)), JunParameterizedBody.ParameterizedOperator_with_with_(JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { fold2 },
						"(COMPOUND (MOVE 0 0 1) (ROTATEDeg 0 0 0 0 1 0 fold2))"), JunPaintedBody.Body_paint_(segment, Color.red), carpal));
		humerus = JunParameterizedBody.Name_parameterizedOperator_with_with_("humerus", JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { spin1 }, "(ROTATEDeg 0 0 0 0 0 1 spin1)"), JunPaintedBody.Body_paint_(cylinder, Color.green),
				JunParameterizedBody.ParameterizedOperator_with_with_(JunParameterizedOperator.Parameters_sExpression_(new JunParameter[] { fold1 }, "(COMPOUND (MOVE 0 0 1) (ROTATEDeg 0 0 0 0 1 0 fold1))"), JunPaintedBody
						.Body_paint_(segment, Color.yellow), antebrachii));
		aParameterizedBody = JunParameterizedBody.Name_with_with_("robot arm", JunParameterizedBody.Name_parameterizedOperator_with_("basement", JunParameterizedOperator.SExpression_("(COMPOUND (LineSCALE 0 0 0 0 0 1 4.8) (MOVE 0 0 -1))"), JunPaintedBody
				.Body_paint_(unitCube, Color.blue)), humerus);

		return aParameterizedBody;
	}
}
