package jp.co.sra.jun.opengl.parameterizedbody;

import java.awt.Color;
import jp.co.sra.smalltalk.DependentEvent;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StModel;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.topology.elements.JunBody;

/**
 * JunPaintedBody class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/12/08 (by MATSUDA Ryouichi)
 *  @updated   2004/10/21 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun582 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunPaintedBody.java,v 8.10 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunPaintedBody extends StModel implements JunParameterizedOrPaintedBody {
	/** The name of the object. */
	protected String name;

	/** The body of the object. */
	protected JunBody body;

	/** The paint of the object. */
	protected Color paint;

	/** The cached3dObject of the object. */
	protected JunOpenGL3dObject cached3dObject;

	/**
	 * Create a new instance of JunPaintedBody and set aBody.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunPaintedBody
	 */
	public static JunPaintedBody Body_(JunBody aBody) {
		JunPaintedBody aPaintedBody;

		aPaintedBody = new JunPaintedBody();
		aPaintedBody.body_(aBody);

		return aPaintedBody;
	}

	/**
	 * Create a new instance of JunPaintedBody and set parameters.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aColorValue java.awt.Color
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunPaintedBody
	 */
	public static JunPaintedBody Body_paint_(JunBody aBody, Color aColorValue) {
		JunPaintedBody aPaintedBody;

		aPaintedBody = new JunPaintedBody();
		aPaintedBody.body_(aBody);
		aPaintedBody.paint_(aColorValue);

		return aPaintedBody;
	}

	/**
	 * Create a new instance of JunPaintedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunPaintedBody
	 */
	public static JunPaintedBody Name_body_(String aString, JunBody aBody) {
		JunPaintedBody aPaintedBody;

		aPaintedBody = new JunPaintedBody();
		aPaintedBody.body_(aBody);
		aPaintedBody.name_(aString);

		return aPaintedBody;
	}

	/**
	 * Create a new instance of JunPaintedBody and set parameters.
	 * 
	 * @param aString java.lang.String
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 * @param aColorValue java.awt.Color
	 * 
	 * @return jp.co.sra.jun.opengl.parameterizedbody.JunPaintedBody
	 */
	public static JunPaintedBody Name_body_paint_(String aString, JunBody aBody, Color aColorValue) {
		JunPaintedBody aPaintedBody;

		aPaintedBody = Body_paint_(aBody, aColorValue);
		aPaintedBody.name_(aString);

		return aPaintedBody;
	}

	/**
	 * Convert recevier to JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		if ((cached3dObject == null) && (this.body() != null)) {
			cached3dObject = this.body().asJunOpenGL3dObject();
			cached3dObject.objectsDo_(new StBlockClosure() {
				public Object value_(Object each) {
					((JunOpenGL3dObject) each).paint_(JunPaintedBody.this.paint());
					return null;
				}
			});
		}
		return cached3dObject;
	}

	/**
	 * Answer the body.
	 * 
	 * @return jp.co.sra.jun.topology.elements.JunBody
	 */
	public final JunBody body() {
		return body;
	}

	/**
	 * Set the body.
	 * 
	 * @param aBody jp.co.sra.jun.topology.elements.JunBody
	 */
	public void body_(JunBody aBody) {
		body = aBody;
		this.flushCache();
	}

	/**
	 * Flush the cached3dObject.
	 */
	public void flushCache() {
		cached3dObject = null;
		this.changed();
	}

	/**
	 * Answer the name.
	 * 
	 * @return java.lang.String
	 */
	public final String name() {
		return name;
	}

	/**
	 * Set the name.
	 * 
	 * @param aString java.lang.String
	 */
	public final void name_(String aString) {
		name = aString;
	}

	/**
	 * Answer the paint.
	 * 
	 * @return java.awt.Color
	 */
	public final Color paint() {
		return paint;
	}

	/**
	 * Set the paint.
	 * 
	 * @param aColorValue java.awt.Color
	 */
	public void paint_(Color aColorValue) {
		paint = aColorValue;
		this.flushCache();
	}

	/**
	 * Display receiver.
	 */
	public void show() {
		this.asJunOpenGL3dObject().show();
	}

	/**
	 * Action for the update notification.
	 * 
	 * @param evt jp.co.sra.smalltalk.DependentEvent
	 */
	public void update_(DependentEvent evt) {
		this.flushCache();
	}
}
