package jp.co.sra.jun.opengl.objects.typical;

import java.util.ArrayList;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;

/**
 * JunOpenGL3dTypicalObjectsTorus class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsTorus.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsTorus extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical object - torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects torus
	 */
	public static JunOpenGL3dObject Torus() {
		return Torus_divisions_radius_divisions_(3.0 / 4.0, 72, 1.0 / 4.0, 27);
	}

	/**
	 * Typical object - torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param torusRadius double
	 * @param torusDivision int
	 * @param sectionRadius double
	 * @param sectionDivision int
	 * @category Typical objects torus
	 */
	public static JunOpenGL3dObject Torus_divisions_radius_divisions_(double torusRadius, int torusDivision, double sectionRadius, int sectionDivision) {
		ArrayList sectionPoints = new ArrayList();
		double aStep = 360.0d / sectionDivision;
		for (double angle = 0; angle < 360; angle += aStep) {
			double radians = JunAngle._DegreesToRadians(angle);
			Jun3dPoint point = new Jun3dPoint(Math.cos(radians), Math.sin(radians), 0).scaledBy_(sectionRadius).translatedBy_(new Jun3dPoint(0, torusRadius, 0));
			sectionPoints.add(point);
		}
		Jun3dPoint[] sectionPointArray = (Jun3dPoint[]) sectionPoints.toArray(new Jun3dPoint[sectionPoints.size()]);

		ArrayList sectionCenters = new ArrayList();
		ArrayList torusSections = new ArrayList();
		aStep = 360.0d / torusDivision;
		for (double angle = 0; angle < 360; angle += aStep) {
			double radians = JunAngle._DegreesToRadians(angle);
			Jun3dPoint point = new Jun3dPoint(0, Math.cos(radians), Math.sin(radians)).scaledBy_(torusRadius);
			sectionCenters.add(point);
			Jun3dPoint[] transformedSection = new Jun3dPoint[sectionPointArray.length];
			for (int j = 0; j < sectionPointArray.length; j++) {
				transformedSection[j] = sectionPointArray[j].transform_(Jun3dTransformation.RotateX_(radians));
			}
			torusSections.add(transformedSection);
		}
		Jun3dPoint[][] torusSectionArray = (Jun3dPoint[][]) torusSections.toArray(new Jun3dPoint[torusSections.size()][]);
		Jun3dPoint[] sectionCenterArray = (Jun3dPoint[]) sectionCenters.toArray(new Jun3dPoint[sectionCenters.size()]);

		JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < torusSectionArray.length; i++) {
			int firstSectionIndex = i;
			int secondSectionIndex = (i == torusSectionArray.length - 1) ? 0 : i + 1;
			Jun3dPoint[] firstSectionPoints = torusSectionArray[firstSectionIndex];
			Jun3dPoint[] secondSectionPoints = torusSectionArray[secondSectionIndex];
			Jun3dPoint firstSectionCenter = sectionCenterArray[firstSectionIndex];
			Jun3dPoint secondSectionCenter = sectionCenterArray[secondSectionIndex];
			for (int j = 0; j < sectionPointArray.length; j++) {
				int firstIndex = j;
				int secondIndex = (j == sectionPointArray.length - 1) ? 0 : j + 1;

				Jun3dPoint p1 = firstSectionPoints[firstIndex];
				Jun3dPoint p2 = firstSectionPoints[secondIndex];
				Jun3dPoint p3 = secondSectionPoints[secondIndex];
				Jun3dPoint p4 = secondSectionPoints[firstIndex];
				Jun3dPoint v1 = firstSectionCenter.to_(p1).normalUnitVector();
				Jun3dPoint v2 = firstSectionCenter.to_(p2).normalUnitVector();
				Jun3dPoint v3 = secondSectionCenter.to_(p3).normalUnitVector();
				Jun3dPoint v4 = secondSectionCenter.to_(p4).normalUnitVector();
				JunOpenGL3dPolygon aPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { p1, p2, p3, p4 }, new Jun3dPoint[] { v1, v2, v3, v4 });
				aBody.add_(aPolygon);
			}
		}
		aBody.name_("torus");
		aBody.flushAllPaints();
		aBody.paint_(DefaultPaint());
		return aBody;
	}

	/**
	 * Typical object - torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param torusRadius int
	 * @param sectionRadius double
	 * @category Typical objects torus
	 */
	public static JunOpenGL3dObject Torus_radius_(int torusRadius, double sectionRadius) {
		return Torus_divisions_radius_divisions_(torusRadius, 36, sectionRadius, 18);
	}

	/**
	 * Typical object - torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param torusRadius double
	 * @param torusDivision int
	 * @param tubeRadius double
	 * @param tubeDivision int
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects torus
	 */
	public static JunOpenGL3dObject TorusRadius_divisions_tubeRadius_divisions_(double torusRadius, int torusDivision, double tubeRadius, int tubeDivision) {
		if (torusRadius > tubeRadius == false) {
			throw new IllegalArgumentException("can not create torus.");
		}

		double stepDegrees = 1.0d / torusDivision;
		ArrayList thetaCollection = new ArrayList();
		for (double theta = 0.0d; theta <= 1.0d - (stepDegrees / 2.0d); theta += stepDegrees) {
			thetaCollection.add(new Double(theta));
		}
		thetaCollection.add(new Double(1.0));
		Double[] thetaArray = (Double[]) thetaCollection.toArray(new Double[thetaCollection.size()]);

		stepDegrees = 1.0d / tubeDivision;
		ArrayList phiCollection = new ArrayList();
		for (double phi = 0.0d; phi <= 1.0d - (stepDegrees / 2.0d); phi += stepDegrees) {
			phiCollection.add(new Double(phi));
		}
		phiCollection.add(new Double(1.0));
		Double[] phiArray = (Double[]) phiCollection.toArray(new Double[phiCollection.size()]);

		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < thetaArray.length - 1; i++) {
			double firstTheta = thetaArray[i].doubleValue();
			double secondTheta = thetaArray[(i == thetaArray.length - 2) ? 0 : i + 1].doubleValue();
			Jun3dPoint[] firstPoints = new Jun3dPoint[phiArray.length];
			Jun3dPoint[] secondPoints = new Jun3dPoint[phiArray.length];
			JunAngle theta = JunAngle.FromRad_(JunGeometry.DoublePi() * firstTheta);
			double x = torusRadius * theta.cos();
			double y = torusRadius * theta.sin();
			double z = 0;
			Jun3dPoint firstCenter = new Jun3dPoint(x, y, z);
			theta = JunAngle.FromRad_(JunGeometry.DoublePi() * secondTheta);
			x = torusRadius * theta.cos();
			y = torusRadius * theta.sin();
			z = 0;
			Jun3dPoint secondCenter = new Jun3dPoint(x, y, z);
			for (int j = 0; j < phiArray.length; j++) {
				double phi = phiArray[j].doubleValue();
				firstPoints[j] = JunGeometry.TorusRadius_normalizedTheta_tubeRadius_normalizedPhi_(torusRadius, firstTheta, tubeRadius, phi);
				secondPoints[j] = JunGeometry.TorusRadius_normalizedTheta_tubeRadius_normalizedPhi_(torusRadius, secondTheta, tubeRadius, phi);
			}
			JunOpenGL3dCompoundObject ringBody = new JunOpenGL3dCompoundObject();
			for (int j = 0; j < firstPoints.length - 1; j++) {
				int firstIndex = j;
				int secondIndex = j + 1;
				Jun3dPoint p1 = firstPoints[firstIndex];
				Jun3dPoint p2 = secondPoints[firstIndex];
				Jun3dPoint p3 = firstPoints[secondIndex];
				Jun3dPoint p4 = secondPoints[secondIndex];
				Jun3dPoint v1 = firstCenter.to_(p1).normalUnitVector();
				Jun3dPoint v2 = secondCenter.to_(p2).normalUnitVector();
				Jun3dPoint v3 = firstCenter.to_(p3).normalUnitVector();
				Jun3dPoint v4 = secondCenter.to_(p4).normalUnitVector();
				JunOpenGL3dPolygon firstPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { p1, p2, p3 }, new Jun3dPoint[] { v1, v2, v3 });
				JunOpenGL3dPolygon secondPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { p2, p4, p3 }, new Jun3dPoint[] { v2, v4, v3 });
				ringBody.add_(firstPolygon);
				ringBody.add_(secondPolygon);
			}
			compoundObject.add_(ringBody);
		}
		compoundObject.name_("torus");
		compoundObject.flushAllPaints();
		compoundObject.paint_(DefaultPaint());
		return compoundObject;
	}

	/**
	 * Typical object - torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param torusRadius double
	 * @param tubeRadius double
	 * @category Typical objects torus
	 */
	public static JunOpenGL3dObject TorusRadius_tubeRadius_(double torusRadius, double tubeRadius) {
		return TorusRadius_divisions_tubeRadius_divisions_(torusRadius, 72, tubeRadius, 36);
	}
}
