package jp.co.sra.jun.opengl.objects.typical;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunOpenGL3dTypicalObjectsCircle class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsCircle.java,v 8.4 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsCircle extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects - circle
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects circle
	 */
	public static JunOpenGL3dObject Circle() {
		return JunOpenGL3dObject.CircleBy_(10);
	}

	/**
	 * Typical objects - circle
	 * 
	 * @param degrees double
	 * @category Typical objects circle
	 */
	public static JunOpenGL3dObject CircleBy_(double degrees) {
		return JunOpenGL3dObject.CircleBy_radius_(degrees, 1);
	}

	/**
	 * Typical objects - circle
	 * 
	 * @param degrees double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects circle
	 */
	public static JunOpenGL3dObject CircleBy_radius_(double degrees, double radius) {
		JunOpenGL3dObject aCircle = JunOpenGL3dObject.PieFrom_to_by_radius_(0, 360, degrees, radius);
		aCircle.paint_(JunOpenGL3dObject.DefaultPaint());
		aCircle.name_("circle");
		return aCircle;
	}

	/**
	 * Typical objects - circle
	 * 
	 * @param byDegrees double
	 * @param radiusValue double
	 * @param upVector jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects circle
	 */
	public static JunOpenGL3dObject CircleBy_radius_upVector_(double byDegrees, double radiusValue, Jun3dPoint upVector) {
		JunOpenGL3dObject aCircle = From_to_height_depth_with_(new Jun3dPoint(0, 0, 0), upVector, radiusValue, radiusValue, JunOpenGL3dObject.CircleBy_(byDegrees).transform_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90))));
		return aCircle;
	}

	/**
	 * Typical objects - circle
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects circle
	 */
	public static JunOpenGL3dObject XUnitCircle() {
		return JunOpenGL3dObject.Circle().transform_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90)));
	}
}
