package jp.co.sra.jun.opengl.objects.typical;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon;

/**
 * JunOpenGL3dTypicalObjectsBox class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/08/24 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun683 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTypicalObjectsBox.java,v 8.5 2008/02/20 06:32:47 nisinaka Exp $
 */
public class JunOpenGL3dTypicalObjectsBox extends JunOpenGL3dTypicalObjects {
	/**
	 * Typical objects - box
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject Box() {
		return JunOpenGL3dObject.Box_(new Jun3dPoint(1, 1, 1));
	}

	/**
	 * Typical objects - box
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject Box_(Jun3dPoint aPoint) {
		Jun3dPoint p0 = new Jun3dPoint(0, 0, 0);
		Jun3dPoint p1 = new Jun3dPoint(0, 0, 1);
		Jun3dPoint p2 = new Jun3dPoint(0, 1, 0);
		Jun3dPoint p3 = new Jun3dPoint(0, 1, 1);
		Jun3dPoint p4 = new Jun3dPoint(1, 0, 0);
		Jun3dPoint p5 = new Jun3dPoint(1, 0, 1);
		Jun3dPoint p6 = new Jun3dPoint(1, 1, 0);
		Jun3dPoint p7 = new Jun3dPoint(1, 1, 1);
		Jun3dPoint[] floorPoints = { p1.multipliedBy_(aPoint), p5.multipliedBy_(aPoint), p7.multipliedBy_(aPoint), p3.multipliedBy_(aPoint) };
		Jun3dPoint[] ceilPoints = { p2.multipliedBy_(aPoint), p6.multipliedBy_(aPoint), p4.multipliedBy_(aPoint), p0.multipliedBy_(aPoint) };
		Jun3dPoint[] leftPoints = { p4.multipliedBy_(aPoint), p6.multipliedBy_(aPoint), p7.multipliedBy_(aPoint), p5.multipliedBy_(aPoint) };
		Jun3dPoint[] rightPoints = { p1.multipliedBy_(aPoint), p3.multipliedBy_(aPoint), p2.multipliedBy_(aPoint), p0.multipliedBy_(aPoint) };
		Jun3dPoint[] nearPoints = { p3.multipliedBy_(aPoint), p7.multipliedBy_(aPoint), p6.multipliedBy_(aPoint), p2.multipliedBy_(aPoint) };
		Jun3dPoint[] farPoints = { p0.multipliedBy_(aPoint), p4.multipliedBy_(aPoint), p5.multipliedBy_(aPoint), p1.multipliedBy_(aPoint) };
		JunOpenGL3dCompoundObject box = new JunOpenGL3dCompoundObject();
		box.name_("box");
		box.add_(new JunOpenGL3dPolygon(floorPoints));
		box.add_(new JunOpenGL3dPolygon(ceilPoints));
		box.add_(new JunOpenGL3dPolygon(leftPoints));
		box.add_(new JunOpenGL3dPolygon(rightPoints));
		box.add_(new JunOpenGL3dPolygon(nearPoints));
		box.add_(new JunOpenGL3dPolygon(farPoints));
		box.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(null);
				return null;
			}
		});
		box.paint_(DefaultPaint());
		return box;
	}

	/**
	 * Typical objects - color cube
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject ColorCube() {
		JunOpenGL3dCompoundObject aCompoundObject = new JunOpenGL3dCompoundObject();
		aCompoundObject.add_(JunOpenGL3dObject.PlateBMWC());
		aCompoundObject.add_(JunOpenGL3dObject.PlateGCWY());
		aCompoundObject.add_(JunOpenGL3dObject.PlateKBCG());
		aCompoundObject.add_(JunOpenGL3dObject.PlateKGYR());
		aCompoundObject.add_(JunOpenGL3dObject.PlateKRMB());
		aCompoundObject.add_(JunOpenGL3dObject.PlateRYWM());
		aCompoundObject.name_("color cube");
		return aCompoundObject;
	}

	/**
	 * Typical objects - cube
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject Cube() {
		return Box().scaledBy_(2).translatedBy_(-1);
	}

	/**
	 * Typical objects - box
	 * 
	 * @param originPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param cornerPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject Origin_corner_(Jun3dPoint originPoint, Jun3dPoint cornerPoint) {
		double originX = Math.min(originPoint.x(), cornerPoint.x());
		double originY = Math.min(originPoint.y(), cornerPoint.y());
		double originZ = Math.min(originPoint.z(), cornerPoint.z());
		Jun3dPoint extent = (Jun3dPoint) cornerPoint.minus_(originPoint).abs();
		return Origin_extent_(new Jun3dPoint(originX, originY, originZ), extent);
	}

	/**
	 * Typical objects - box
	 * 
	 * @param originPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param extentPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject Origin_extent_(Jun3dPoint originPoint, Jun3dPoint extentPoint) {
		JunOpenGL3dObject box = Box_(extentPoint);
		Jun3dTransformation transformation = Jun3dTransformation.Align_with_(Jun3dPoint.Zero(), originPoint);
		return box.transform_(transformation);
	}

	/**
	 * Typical objects - x unit box
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject XUnitBox() {
		return Box().transform_(Jun3dTransformation.Translate_(new Jun3dPoint(-0.5, -0.5, 0)).product_(Jun3dTransformation.RotateY_(JunAngle.FromDeg_(90))));
	}
}
