package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGL3dTransformedObjectTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/11/29 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dTransformedObjectTestExamples.java,v 8.14 2008/02/20 06:32:35 nisinaka Exp $
 */
public class JunOpenGL3dTransformedObjectTestExamples extends JunTestExamples {

	/**
	 * Example4: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunOpenGL3dObject baseSphere = JunOpenGL3dObject.Ball_(2);
		baseSphere.flushAllPaints();

		JunOpenGL3dCompoundObject halfBody = new JunOpenGL3dCompoundObject();
		halfBody.add_(new JunOpenGL3dTransformedObject(baseSphere, Jun3dTransformation.Translate_(new Jun3dPoint(2, 1, 0)), Color.red));
		halfBody.add_(new JunOpenGL3dTransformedObject(baseSphere, Jun3dTransformation.Translate_(new Jun3dPoint(0, 2, 0)), Color.green));
		halfBody.add_(new JunOpenGL3dTransformedObject(baseSphere, Jun3dTransformation.Translate_(new Jun3dPoint(0, 3, 2)), Color.blue));
		halfBody.establishAllNormalVectors();

		JunOpenGL3dCompoundObject fullBody = new JunOpenGL3dCompoundObject();
		fullBody.add_(halfBody);
		fullBody.add_(new JunOpenGL3dTransformedObject(halfBody, Jun3dTransformation.MirrorY()));
		fullBody.add_(JunOpenGL3dObject.Axes().scaledBy_(5));

		fullBody.show();

		return true;
	}

	/**
	 * Example5: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunOpenGL3dObject baseSphere = new JunOpenGL3dTransformedObject(JunOpenGL3dObject.Ball_(2));
		baseSphere.flushAllPaints();

		JunOpenGL3dCompoundObject halfBody = new JunOpenGL3dCompoundObject();
		JunOpenGL3dObject anObject = baseSphere.translatedBy_(new Jun3dPoint(2, 1, 0));
		anObject.paint_(Color.red);
		halfBody.add_(anObject);
		anObject = baseSphere.translatedBy_(new Jun3dPoint(0, 2, 0));
		anObject.paint_(Color.green);
		halfBody.add_(anObject);
		anObject = baseSphere.translatedBy_(new Jun3dPoint(0, 3, 2));
		anObject.paint_(Color.blue);
		halfBody.add_(anObject);
		halfBody.establishAllNormalVectors();

		JunOpenGL3dCompoundObject fullBody = new JunOpenGL3dCompoundObject();
		fullBody.add_(halfBody);
		fullBody.add_(new JunOpenGL3dTransformedObject(halfBody, Jun3dTransformation.MirrorY()));
		fullBody.add_(JunOpenGL3dObject.Axes().scaledBy_(5));

		fullBody.show();

		return true;
	}

	/**
	 * Example6_1: MirrorY transformation
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6_1() {
		return Example6(false);
	}

	/**
	 * Example6_2: MirrorY transformation in the right hand coordination.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6_2() {
		return Example6(true);
	}

	/**
	 * Example6:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	protected static boolean Example6(boolean isRightHandCoordination) {
		JunOpenGL3dPolygon originalPolygon = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(1, 1, 0), new Jun3dPoint(2, 1, 0), new Jun3dPoint(1, 2, 0) });
		originalPolygon.paint_(Color.red);
		originalPolygon.halftone_(0.75);

		if (isRightHandCoordination) {
			originalPolygon.flushAllNormalVectors();
		} else {
			originalPolygon.establishAllNormalVectors();
		}

		Jun3dTransformation aTransformation = Jun3dTransformation.MirrorY();
		JunOpenGL3dVertexesObject junTransformedPolygon = (JunOpenGL3dVertexesObject) originalPolygon.transform_(aTransformation);
		JunOpenGL3dTransformedObject glTransformedPolygon = new JunOpenGL3dTransformedObject(originalPolygon, aTransformation);

		JunOpenGL3dCompoundObject originalPolygonAndNormalVector = new JunOpenGL3dCompoundObject();
		originalPolygonAndNormalVector.add_(originalPolygon);
		originalPolygonAndNormalVector.add_(originalPolygon.normalVectorObject());

		JunOpenGL3dCompoundObject junTransformedPolygonAndNormalVector = new JunOpenGL3dCompoundObject();
		junTransformedPolygonAndNormalVector.add_(junTransformedPolygon);
		junTransformedPolygonAndNormalVector.add_(junTransformedPolygon.normalVectorObject());

		final JunOpenGL3dCompoundObject glTransformedPolygonAndNormalVector = new JunOpenGL3dCompoundObject();
		glTransformedPolygon.polygonsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) each;
				glTransformedPolygonAndNormalVector.add_(aPolygon);
				glTransformedPolygonAndNormalVector.add_(aPolygon.normalVectorObject());
				return null;
			}
		});

		JunOpenGL3dPolygon mirrorPlane = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, -1), new Jun3dPoint(0, 0, 1), new Jun3dPoint(1, 0, 1), new Jun3dPoint(1, 0, -1) });
		mirrorPlane.paint_(Color.cyan);
		mirrorPlane.halftone_(0.25);

		JunOpenGL3dCompoundObject junDisplayObject = new JunOpenGL3dCompoundObject(originalPolygonAndNormalVector, junTransformedPolygonAndNormalVector, JunOpenGL3dObject.XyzArrows().scaledBy_(3), mirrorPlane.scaledBy_(3));
		JunOpenGL3dCompoundObject glDisplayObject = new JunOpenGL3dCompoundObject(originalPolygonAndNormalVector, glTransformedPolygonAndNormalVector, JunOpenGL3dObject.XyzArrows().scaledBy_(3), mirrorPlane.scaledBy_(3));

		Hashtable projectionTable = new Hashtable();
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("eyePoint"), new Jun3dPoint(40, 8, 20));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("upVector"), new Jun3dPoint(0, 0, 1));
		projectionTable.put($("viewFactor"), new Double(10));
		projectionTable.put($("zoomHeight"), new Double(6));

		JunOpenGLDisplayModel[] anArray = new JunOpenGLDisplayModel[2];
		anArray[0] = junDisplayObject.showProjectionTable_in_(projectionTable, new Rectangle(100, 270, 300, 300));
		anArray[1] = glDisplayObject.showProjectionTable_in_(projectionTable, new Rectangle(100, 600, 300, 300));
		for (int i = 0; i < anArray.length; i++) {
			anArray[i].closeTogether_(anArray);
		}

		return true;
	}

	/**
	 * Example7:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7() {
		JunOpenGL3dObject originalHedron = JunOpenGL3dObject.RegularDodecahedron().rotatedBy_(JunAngle.FromDeg_(30)).translatedBy_(new Jun3dPoint(1, 1.8, 0));
		originalHedron.flushAllPaints();
		final ArrayList polygonCollection = new ArrayList();
		originalHedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object polygon) {
				polygonCollection.add(polygon);
				return null;
			}
		});
		JunOpenGL3dPolygon[] polygons = new JunOpenGL3dPolygon[polygonCollection.size()];
		polygonCollection.toArray(polygons);
		for (int i = 0; i < polygons.length; i++) {
			polygons[i].paint_(new Color(Color.HSBtoRGB((float) i / polygons.length, 1, 1)));
			polygons[i].halftone_(0.75);
		}

		originalHedron.establishAllNormalVectors();
		Jun3dTransformation aTransformation = Jun3dTransformation.MirrorY();
		JunOpenGL3dObject junTransformedHedron = originalHedron.transform_(aTransformation);
		JunOpenGL3dTransformedObject glTransformedHedron = new JunOpenGL3dTransformedObject(originalHedron, aTransformation);

		final JunOpenGL3dCompoundObject originalHedronAndNormalVectors = new JunOpenGL3dCompoundObject();
		originalHedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) each;
				originalHedronAndNormalVectors.add_(aPolygon);
				originalHedronAndNormalVectors.add_(aPolygon.normalVectorObject());
				return null;
			}
		});
		final JunOpenGL3dCompoundObject junTransformedHedronAndNormalVectors = new JunOpenGL3dCompoundObject();
		junTransformedHedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) each;
				junTransformedHedronAndNormalVectors.add_(aPolygon);
				junTransformedHedronAndNormalVectors.add_(aPolygon.normalVectorObject());
				return null;
			}
		});
		final JunOpenGL3dCompoundObject glTransfomedHedronAndNormalVectors = new JunOpenGL3dCompoundObject();
		glTransformedHedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) each;
				glTransfomedHedronAndNormalVectors.add_(aPolygon);
				glTransfomedHedronAndNormalVectors.add_(aPolygon.normalVectorObject());
				return null;
			}
		});

		JunOpenGL3dPolygon mirrorPlane = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, -1), new Jun3dPoint(0, 0, 1), new Jun3dPoint(1, 0, 1), new Jun3dPoint(1, 0, -1) });
		mirrorPlane.paint_(Color.cyan);
		mirrorPlane.halftone_(0.25);

		JunOpenGL3dCompoundObject junDisplayObject = new JunOpenGL3dCompoundObject(originalHedronAndNormalVectors, junTransformedHedronAndNormalVectors, JunOpenGL3dObject.XyzArrows().scaledBy_(4), mirrorPlane.scaledBy_(4));
		JunOpenGL3dCompoundObject glDisplayObject = new JunOpenGL3dCompoundObject(originalHedronAndNormalVectors, glTransfomedHedronAndNormalVectors, JunOpenGL3dObject.XyzArrows().scaledBy_(4), mirrorPlane.scaledBy_(4));

		Hashtable projectionTable = new Hashtable();
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("eyePoint"), new Jun3dPoint(40, 8, 20));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("upVector"), new Jun3dPoint(0, 0, 1));
		projectionTable.put($("viewFactor"), new Double(10));
		projectionTable.put($("zoomHeight"), new Double(8));

		JunOpenGLDisplayModel[] anArray = new JunOpenGLDisplayModel[2];
		anArray[0] = junDisplayObject.showProjectionTable_in_(projectionTable, new Rectangle(100, 270, 300, 300));
		anArray[1] = glDisplayObject.showProjectionTable_in_(projectionTable, new Rectangle(100, 600, 300, 300));
		for (int i = 0; i < anArray.length; i++) {
			anArray[i].closeTogether_(anArray);
		}

		return true;
	}

	/**
	 * Example8: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		JunOpenGL3dObject baseBody = JunOpenGL3dObject.Cube().scaledBy_(0.4);
		baseBody.flushAllPaints();
		JunOpenGL3dObject firstBody = new JunOpenGL3dTransformedObject(baseBody, Jun3dTransformation.Translate_(new Jun3dPoint(1, 0, 0)));
		JunOpenGL3dObject secondBody = new JunOpenGL3dTransformedObject(baseBody, Jun3dTransformation.Translate_(new Jun3dPoint(0, 1, 0)));
		JunOpenGL3dObject thirdBody = new JunOpenGL3dTransformedObject(baseBody, Jun3dTransformation.Translate_(new Jun3dPoint(0, 0, 1)));
		firstBody.paint_(Color.red);
		secondBody.paint_(Color.green);
		thirdBody.paint_(Color.blue);
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.add_(baseBody);
		compoundObject.add_(firstBody);
		compoundObject.add_(secondBody);
		compoundObject.add_(thirdBody);
		compoundObject.showWithAxes();

		return true;
	}

	/**
	 * Example9: Compare the transformed objects.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example9() {
		JunOpenGL3dObject baseBody = JunOpenGL3dObject.Ball();
		baseBody.establishAllNormalVectors();
		JunOpenGL3dTransformedObject aTransformedObject = new JunOpenGL3dTransformedObject(baseBody);
		aTransformedObject = (JunOpenGL3dTransformedObject) aTransformedObject.scaledBy_(new Jun3dPoint(0.65, 1, 1.1));
		aTransformedObject.showWithAxesIn_(new Rectangle(100, 300, 400, 400));
		aTransformedObject.transformedObject().showWithAxesIn_(new Rectangle(500, 300, 400, 400));

		return true;
	}

	/**
	 * ExampleA: 
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleA() {
		JunOpenGL3dObject aBall = JunOpenGL3dObject.Ball_(1);
		aBall.objectsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				((JunOpenGL3dObject) each).paint_(null);
				return null;
			}
		});
		Jun3dTransformation aTransformation = Jun3dTransformation.Scale_(new Jun3dPoint(1.0 / 25, 1.0 / 25, 1.0 / 25));
		aBall = new JunOpenGL3dTransformedObject(aBall, aTransformation);
		int howMany = 25;
		Collection ballCollection = new ArrayList();
		Jun3dLine aLine = new Jun3dPoint(0, -1, 0).to_(new Jun3dPoint(1, 0, 0));
		for (int i = 0; i <= howMany; i++) {
			float n = 1.0f / howMany * i;
			JunOpenGL3dObject anObject = aBall.transform_(Jun3dTransformation.Translate_(aLine.atT_(n)));
			anObject.paint_(Color.getHSBColor(n * howMany / (howMany + 1), 1, 1));
			ballCollection.add(anObject);
		}

		JunOpenGL3dObject xyzArrows = JunOpenGL3dObject.XyzArrows().scaledBy_(new Jun3dPoint(1.2, 1.2, 1.2));
		JunOpenGLDisplayModel aViewfinder = new JunOpenGLDisplayModel(xyzArrows);
		aViewfinder.openIn_(new Rectangle(100, 100, 400, 400));
		howMany = 100;
		aLine = new Jun3dPoint(1, 0, 0).to_(new Jun3dPoint(0, 1, 0));
		JunOpenGL3dObject[] balls = (JunOpenGL3dObject[]) ballCollection.toArray(new JunOpenGL3dObject[ballCollection.size()]);

		long initialMicroseconds = System.currentTimeMillis();
		for (int i = 0; i <= howMany; i++) {
			double n = 1.0f / howMany * i;
			JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
			for (int j = 0; j < balls.length; j++) {
				aBody.add_(balls[j].transform_(Jun3dTransformation.Translate_(aLine.atT_(n).minus_(aLine.first()))));
			}
			aBody.add_(xyzArrows);
			aViewfinder.displayObject_(aBody);
			aViewfinder.changed_($("object"));
		}
		long millisecondsToRun = System.currentTimeMillis() - initialMicroseconds;
		System.out.println(Long.toString(millisecondsToRun));

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGL3dTransformedObjectTestExamples();
	}

}
