package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StSymbol;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.curves.Jun3dPolyline;
import jp.co.sra.jun.geometry.surfaces.Jun3dPolygon;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.opengl.texture.JunOpenGLStipple;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;

/**
 * JunOpenGL3dPolygon class
 * 
 *  @author    nisinaka
 *  @created   1998/10/13 (by nisinaka)
 *  @updated   1999/08/04 (by nisinaka)
 *  @updated   2001/11/20 (by nisinaka)
 *  @updated   2004/05/14 (by nisinaka)
 *  @updated   2004/09/29 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dPolygon.java,v 8.15 2008/02/20 06:32:35 nisinaka Exp $
 */
public class JunOpenGL3dPolygon extends JunOpenGL3dVertexesObject {
	/** A stipple of a JunOpenGL3dPolygon. */
	protected JunOpenGLStipple stipple;

	/** A texture of a JunOpenGL3dPolygon. */
	protected JunOpenGLTexture texture;

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon() {
		super();
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with an array of 3d points.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Jun3dPoint[] anArrayOf3dPoints) {
		super(anArrayOf3dPoints);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with an array of 3d points and a Color.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param aColor java.awt.Color
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Jun3dPoint[] anArrayOf3dPoints, Color aColor) {
		super(anArrayOf3dPoints, aColor);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with an array of 3d points, a Color and alpha value.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Jun3dPoint[] anArrayOf3dPoints, Color aColor, float aNumber) {
		super(anArrayOf3dPoints, aColor, aNumber);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with a collection of 3d points.
	 * 
	 * @param aCollectionOf3dPoints java.util.Collection
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Collection aCollectionOf3dPoints) {
		super(aCollectionOf3dPoints);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with a collection of 3d points.
	 * 
	 * @param aCollectionOf3dPoints java.util.Collection
	 * @param aColor java.awt.Color
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Collection aCollectionOf3dPoints, Color aColor) {
		super(aCollectionOf3dPoints, aColor);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with a collection of 3d points, a color and alpha value.
	 * 
	 * @param aCollectionOf3dPoints java.util.Collection
	 * @param aColor java.awt.Color
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Collection aCollectionOf3dPoints, Color aColor, float aNumber) {
		super(aCollectionOf3dPoints, aColor, aNumber);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with an array of 3d points and an array of colors.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOfColors java.awt.Color[]
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Jun3dPoint[] anArrayOf3dPoints, Color[] anArrayOfColors) {
		super(anArrayOf3dPoints, anArrayOfColors);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with an array of 3d points, an array of colors and alpha value.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOfColors java.awt.Color[]
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Jun3dPoint[] anArrayOf3dPoints, Color[] anArrayOfColors, float aNumber) {
		super(anArrayOf3dPoints, anArrayOfColors, aNumber);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with an array of 3d points, and an array of 3d vectors.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOf3dVectors jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Jun3dPoint[] anArrayOf3dPoints, Jun3dPoint[] anArrayOf3dVectors) {
		super(anArrayOf3dPoints, anArrayOf3dVectors);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with an array of 3d points, an array of 3d vectors and an array of colors.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOf3dVectors jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOfColors java.awt.Color[]
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Jun3dPoint[] anArrayOf3dPoints, Jun3dPoint[] anArrayOf3dVectors, Color[] anArrayOfColors) {
		super(anArrayOf3dPoints, anArrayOf3dVectors, anArrayOfColors);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with an array of 3d points, an array of 3d vectors, an array of colors and alpha value.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOf3dVectors jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param anArrayOfColors java.awt.Color[]
	 * @param aNumber float
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(Jun3dPoint[] anArrayOf3dPoints, Jun3dPoint[] anArrayOf3dVectors, Color[] anArrayOfColors, float aNumber) {
		super(anArrayOf3dPoints, anArrayOf3dVectors, anArrayOfColors, aNumber);
	}

	/**
	 * Create a new instance of JunOpenGL3dPolygon and initialize it with the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunOpenGL3dPolygon(JunLispList aList) {
		super(aList);
	}

	/**
	 * Create a new instance of JunOpenGL3dPolygon and initialize it with an array of 3d points.
	 * 
	 * @param anArrayOf3dPoints java.util.Vector
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon
	 * @deprecated since Jun454, use the constructor.
	 * @category Instance creation
	 */
	public static JunOpenGL3dPolygon Vertexes_(Jun3dPoint[] anArrayOf3dPoints) {
		return new JunOpenGL3dPolygon(anArrayOf3dPoints);
	}

	/**
	 * Create a new instance of JunOpenGL3dPolygon and initialize it with a collection of 3d points.
	 * 
	 * @param aCollectionOf3dPoints java.util.Vector
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon
	 * @deprecated since Jun454, use the constructor.
	 * @category Instance creation
	 */
	public static JunOpenGL3dPolygon Vertexes_(Vector aCollectionOf3dPoints) {
		return new JunOpenGL3dPolygon(aCollectionOf3dPoints);
	}

	/**
	 * Create a new JunOpenGL3dPolygon and initialize it with an array of 3d points and a Color.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @param aColor java.awt.Color
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @deprecated since Jun454, use the constructor.
	 * @category Instance creation
	 */
	public static JunOpenGL3dObject Vertexes_paint_(Jun3dPoint[] anArrayOf3dPoints, Color aColor) {
		return new JunOpenGL3dPolygon(anArrayOf3dPoints, aColor);
	}

	/**
	 * Create a JunOpenGL3dPolygon from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @deprecated since Jun454, use the constructor.
	 * @category Lisp support
	 */
	public static JunOpenGL3dObject FromLispList_(JunLispCons aList) {
		return new JunOpenGL3dPolygon(aList);
	}

	/**
	 * Initialize the JunOpenGL3dPolygon.
	 * 
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		stipple = null;
		texture = null;
	}

	/**
	 * Set a stipple with the specified scale.
	 * 
	 * @param halftoneScale double
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#halftone_(double)
	 * @category accessing
	 */
	public void halftone_(double halftoneScale) {
		this.stipple_(JunOpenGLStipple.Halftone_(halftoneScale));
	}

	/**
	 * Answer the stipple of the receiver..
	 * 
	 * @return jp.co.sra.jun.opengl.texture.JunOpenGLStipple
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#stipple()
	 * @category accessing
	 */
	public JunOpenGLStipple stipple() {
		return stipple;
	}

	/**
	 * Set a stipple of the receiver..
	 * 
	 * @param aStipple jp.co.sra.jun.opengl.texture.JunOpenGLStipple
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#stipple_(jp.co.sra.jun.opengl.texture.JunOpenGLStipple)
	 * @category accessing
	 */
	public void stipple_(JunOpenGLStipple aStipple) {
		stipple = aStipple;
	}

	/**
	 * Answer the texture of the receiver.
	 * 
	 * @return jp.co.sra.jun.opengl.texture.JunOpenGLTexture
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#texture()
	 * @category accessing
	 */
	public JunOpenGLTexture texture() {
		return texture;
	}

	/**
	 * Set a texture of the receiver.
	 * 
	 * @param aTexture jp.co.sra.jun.opengl.texture.JunOpenGLTexture
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#texture_(jp.co.sra.jun.opengl.texture.JunOpenGLTexture)
	 * @category accessing
	 */
	public void texture_(JunOpenGLTexture aTexture) {
		texture = aTexture;
		super.texture_(aTexture);
	}

	/**
	 * Set the vertexes with an array of 3d points.
	 * 
	 * @param anArrayOf3dPoints jp.co.sra.jun.geometry.basic.Jun3dPoint[]
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject#vertexes_(jp.co.sra.jun.geometry.basic.Jun3dPoint[])
	 * @category accessing
	 */
	public void vertexes_(Jun3dPoint[] anArrayOf3dPoints) {
		if (anArrayOf3dPoints.length < 3) {
			throw SmalltalkException.Error("few vertexes");
		}

		super.vertexes_(anArrayOf3dPoints);
	}

	/**
	 * Find an adjacent polygon on the left side of the receiver.
	 * 
	 * @param vertex jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aList java.util.List
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon
	 * @category accessing
	 */
	protected JunOpenGL3dPolygon _findAdjacentOnLeft(Jun3dPoint vertex, List aList) {
		Jun3dPoint vertex2 = this.previousVertexOf(vertex);
		if (vertex2 == null) {
			return null;
		}

		Iterator i = aList.listIterator();
		while (i.hasNext()) {
			JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) i.next();
			if (vertex2.equal_(aPolygon.nextVertexOf(vertex))) {
				return aPolygon;
			}
		}
		return null;
	}

	/**
	 * Find an adjacent polygon on the left side of the receiver.
	 * 
	 * @param vertex jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aList java.util.List
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dPolygon
	 * @category accessing
	 */
	protected JunOpenGL3dPolygon _findAdjacentOnRight(Jun3dPoint vertex, List aList) {
		Jun3dPoint vertex2 = this.nextVertexOf(vertex);
		if (vertex2 == null) {
			return null;
		}

		Iterator i = aList.listIterator();
		while (i.hasNext()) {
			JunOpenGL3dPolygon aPolygon = (JunOpenGL3dPolygon) i.next();
			if (vertex2.equal_(aPolygon.previousVertexOf(vertex))) {
				return aPolygon;
			}
		}
		return null;
	}

	/**
	 * Answer true if this JunOpenGL3dObject has a stipple, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#hasStipple()
	 * @category testing
	 */
	public boolean hasStipple() {
		return stipple != null;
	}

	/**
	 * Answer true if this JunOpenGL3dObject has a texture, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#hasTexture()
	 * @category testing
	 */
	public boolean hasTexture() {
		return texture != null;
	}

	/**
	 * Answer true if the receiver is a kind of JunOpenGL3dPolygon, otherwise false.
	 * 
	 * @return boolean
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#isPolygon()
	 * @category testing
	 */
	public boolean isPolygon() {
		return true;
	}

	/**
	 * Render the OpenGL object on a rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#renderOn_(jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext)
	 * @category rendering
	 */
	public void renderOn_(JunOpenGLRenderingContext aRenderingContext) {
		float saveLineWidth = aRenderingContext.lineWidth();
		if (Float.isNaN(saveLineWidth) == false) {
			aRenderingContext.lineWidth_(1);
		}
		int oldTextureCoordinateIndex = Integer.MIN_VALUE;

		if (this.hasPaint()) {
			aRenderingContext.paint_(this.paint());
		}
		if (this.hasAlpha()) {
			aRenderingContext.alpha_(this.alpha());
		}
		if (this.hasStipple()) {
			this.stipple().enableStippleOn_(aRenderingContext);
		}
		if (this.hasTexture()) {
			oldTextureCoordinateIndex = aRenderingContext.textureCoordinateIndex();
			aRenderingContext.textureCoordinateIndex_(0);
			this.texture().enableTextureOn_(aRenderingContext);
		}
		if (this.hasTransparency()) {
			aRenderingContext.enableCullFace();
			aRenderingContext.disableDepthMask();
			aRenderingContext.enableBlending();
		}

		Jun3dPoint[] normalVectors = null;
		if (aRenderingContext.shading() == $("flat")) {
			normalVectors = new Jun3dPoint[] { this.normalVector() };
		} else {
			normalVectors = this.normalVectors();
		}
		aRenderingContext.displayPolygon_colors_normalVectors_(this.vertexes(), this.colors(), normalVectors);

		if (this.hasTransparency()) {
			aRenderingContext.disableCullFace();
			aRenderingContext.enableDepthMask();
			aRenderingContext.disableBlending();
		}
		if (this.hasTexture()) {
			this.texture().disableTextureOn_(aRenderingContext);
			aRenderingContext.textureCoordinateIndex_(oldTextureCoordinateIndex);
		}
		if (this.hasStipple()) {
			this.stipple().disableStippleOn_(aRenderingContext);
		}

		if (Float.isNaN(saveLineWidth) == false) {
			aRenderingContext.lineWidth_(saveLineWidth);
		}
	}

	/**
	 * Convert the receiver as an array of the <code>Jun3dLine</code>.
	 * 
	 * @return jp.co.sra.jun.geometry.curves.Jun3dLine[]
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject#asArrayOfLines()
	 * @category converting
	 */
	public Jun3dLine[] asArrayOfLines() {
		Jun3dPoint[] points = this.vertexes();
		boolean isLoop = points[0].equal_(points[points.length - 1]);

		Jun3dPoint[] collection = isLoop ? new Jun3dPoint[points.length] : new Jun3dPoint[points.length + 1];
		for (int i = 0; i < points.length; i++) {
			collection[i] = new Jun3dPoint(points[i]);
		}
		if (isLoop == false) {
			collection[collection.length - 1] = new Jun3dPoint(points[0]);
		}
		Jun3dPolyline polyline = new Jun3dPolyline(collection);
		return polyline.asArrayOfLines();
	}

	/**
	 * Enumerate every geometries and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#geometriesDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public Object geometriesDo_(StBlockClosure aBlock) {
		return aBlock.value_(Jun3dPolygon.Points_(vertexes));
	}

	/**
	 * Enumerate every polygons and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#polygonsDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public void polygonsDo_(StBlockClosure aBlock) {
		aBlock.value_(this);
	}

	/**
	 * Answer the number of polygons.
	 * 
	 * @return int
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#numberOfPolygons()
	 * @category utilities
	 */
	public int numberOfPolygons() {
		return 1;
	}

	/**
	 * Answer the StSymbol which represents the kind of the receiver.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dObject#kindName()
	 * @category lisp support
	 */
	public StSymbol kindName() {
		return $("Polygon");
	}

	/**
	 * Convert the receiver's stipple as a LispList.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject#stippleToLispList()
	 * @category lisp support
	 */
	protected JunLispList stippleToLispList() {
		if (!this.hasStipple()) {
			return this.lispNil();
		}

		JunLispCons list = this.lispCons();
		list.head_($("stipple"));
		list.tail_(this.stipple().image());
		return list;
	}

	/**
	 * Convert the receiver's texture as a LispList.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject#textureToLispList()
	 * @category lisp support
	 */
	protected JunLispList textureToLispList() {
		if (!this.hasTexture()) {
			return this.lispNil();
		}

		JunLispCons list = this.lispCons();
		list.head_($("texture"));
		list.tail_(this.texture().toLispList());
		return list;
	}

	/**
	 * Get my stipple from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject#stippleFromLispList(jp.co.sra.jun.goodies.lisp.JunLispList)
	 * @category lisp support
	 */
	protected void stippleFromLispList(JunLispList aList) {
		JunLispCons list = (JunLispCons) aList.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object anObject) {
				return new Boolean(anObject instanceof JunLispCons && (((JunLispCons) anObject).head() == $("stipple")));
			}
		}, new StBlockClosure());
		if (list == null) {
			return;
		}

		this.stipple_(JunOpenGLStipple.Image_((StImage) list.tail()));
	}

	/**
	 * Get my texture from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject#textureFromLispList(jp.co.sra.jun.goodies.lisp.JunLispList)
	 * @category lisp support
	 */
	protected void textureFromLispList(JunLispList aList) {
		JunLispCons list = (JunLispCons) aList.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object anObject) {
				return new Boolean(anObject instanceof JunLispCons && (((JunLispCons) anObject).head() == $("texture")));
			}
		}, new StBlockClosure());
		if (list == null) {
			return;
		}

		this.texture_(new JunOpenGLTexture((JunLispList) list.tail()));
	}

	/**
	 * Answer the name of my indexed set node.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject#vrml10IndexedSetName()
	 * @category vrml support
	 */
	protected String vrml10IndexedSetName() {
		return "IndexedFaceSet";
	}

	/**
	 * Answer the name of my indexed set node.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.jun.opengl.objects.JunOpenGL3dVertexesObject#vrml20IndexedSetName()
	 * @category vrml support
	 */
	protected String vrml20IndexedSetName() {
		return "IndexedFaceSet";
	}
}
