package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.opengl.texture.JunOpenGLTextureTestExamples;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGL3dPatchedObjectTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2004/06/15 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dPatchedObjectTestExamples.java,v 8.13 2008/02/20 06:32:35 nisinaka Exp $
 */
public class JunOpenGL3dPatchedObjectTestExamples extends JunTestExamples {

	/**
	 * Example1: Shows a patched object with two triangles.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunOpenGL3dPatchedObject patchedObject = new JunOpenGL3dPatchedObject();
		patchedObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, 0), new Jun3dPoint(1, 0, 0), new Jun3dPoint(1, 1, 0) }));
		patchedObject.add_(new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(1, 0, 0), new Jun3dPoint(2, 1, 0), new Jun3dPoint(1, 1, 0) }));
		patchedObject.paint_(Color.white);
		patchedObject.showWithUnitAxes();
		return true;
	}

	/**
	 * Example2: Check for the LST file format.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunOpenGL3dCompoundObject box = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Box();
		box.establishAllNormalVectors();
		JunOpenGL3dCompoundObject patchedObject = box.asPatchedObject();
		System.out.println(box.toLispList());
		System.out.println(patchedObject.toLispList());
		patchedObject.show();
		return true;
	}

	/**
	 * Example3: Check for the normal vectors.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunOpenGL3dCompoundObject patchedObject = (new JunOpenGL3dSphere(0.5, 40, 20)).asPatchedObject();
		patchedObject.paint_(Color.white);
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.displayObject_(patchedObject);
		displayModel.defaultShading_($("smoothShading"));
		displayModel.open();
		return true;
	}

	/**
	 * Example4: Check for the texture.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunOpenGL3dCompoundObject anObject = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Smalltalk();
		JunOpenGL3dPatchedObject patchedObject = anObject.asPatchedObject();
		patchedObject.show();

		return true;
	}

	/**
	 * Example5: Check for the texture.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		Object[] xyPointsAndSphere = JunOpenGL3dObject.XyPointsAndSphere_radius_longitude_latitude_(30, 1, 360, 180);
		Vector points = (Vector) xyPointsAndSphere[0];
		Jun2dPoint[] xyPoints = new Jun2dPoint[points.size()];
		for (int index = 0; index < points.size(); index++) {
			Jun2dPoint aPoint = (Jun2dPoint) points.elementAt(index);
			xyPoints[index] = new Jun2dPoint(aPoint.x(), 1 - aPoint.y());
		}
		JunOpenGL3dCompoundObject anObject = (JunOpenGL3dCompoundObject) xyPointsAndSphere[1];
		Image anImage = JunOpenGLTextureTestExamples.ImageEarth();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.coordinates_(xyPoints);
		anObject.texture_(aTexture);
		anObject.name_("earth");

		JunOpenGL3dPatchedObject patchedObject = anObject.asPatchedObject();
		patchedObject.show();

		return true;
	}

	/**
	 * Example6: Check for the colors.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		JunOpenGL3dPatchedObject patchedObject = new JunOpenGL3dPatchedObject();
		patchedObject.add_(JunOpenGL3dVertexesTestExamples.ColoredPolygon());
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.displayObject_(patchedObject);
		displayModel.defaultShading_($("smoothShading"));
		displayModel.open();

		return true;
	}

	/**
	 * Example7_1: MirrorY transformation.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7_1() {
		return Example7(false);
	}

	/**
	 * Example7_2: MirrorY transformation in the right hand coordination.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example7_2() {
		return Example7(true);
	}

	/**
	 * Example7:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	protected static boolean Example7(boolean isRightHandCoordination) {
		JunOpenGL3dObject originalHedron = JunOpenGL3dObject.RegularDodecahedron().rotatedBy_(JunAngle.FromDeg_(30)).translatedBy_(new Jun3dPoint(1, 1.8, 0));
		originalHedron = ((JunOpenGL3dCompoundObject) originalHedron).asPatchedObject();
		originalHedron.flushAllPaints();
		final ArrayList polygonCollection = new ArrayList();
		originalHedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object polygon) {
				polygonCollection.add(polygon);
				return null;
			}
		});
		JunOpenGL3dPolygon[] polygons = new JunOpenGL3dPolygon[polygonCollection.size()];
		polygonCollection.toArray(polygons);
		for (int i = 0; i < polygons.length; i++) {
			polygons[i].paint_(new Color(Color.HSBtoRGB((float) i / polygons.length, 1, 1)));
			polygons[i].halftone_(0.75);
		}

		if (isRightHandCoordination) {
			originalHedron.flushAllNormalVectors();
		} else {
			originalHedron.establishAllNormalVectors();
		}

		Jun3dTransformation aTransformation = Jun3dTransformation.MirrorY();
		JunOpenGL3dObject junTransformedHedron = originalHedron.transform_(aTransformation);
		JunOpenGL3dTransformedObject glTransformedHedron = new JunOpenGL3dTransformedObject(originalHedron, aTransformation);
		JunOpenGL3dCompoundObject originalHedronAndNormalVectors = new JunOpenGL3dCompoundObject();
		for (int i = 0; i < polygons.length; i++) {
			JunOpenGL3dCompoundObject polygonAndNormalVectorObject = new JunOpenGL3dCompoundObject();
			polygonAndNormalVectorObject.add_(polygons[i]);
			polygonAndNormalVectorObject.add_(polygons[i].normalVectorObject());
			originalHedronAndNormalVectors.add_(polygonAndNormalVectorObject);
		}
		final JunOpenGL3dCompoundObject junTransformedHedronAndNormalVectors = new JunOpenGL3dCompoundObject();
		junTransformedHedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dVertexesObject polygon = (JunOpenGL3dVertexesObject) obj;
				JunOpenGL3dCompoundObject polygonAndNormalVectorObject = new JunOpenGL3dCompoundObject();
				polygonAndNormalVectorObject.add_(polygon);
				polygonAndNormalVectorObject.add_(polygon.normalVectorObject());
				junTransformedHedronAndNormalVectors.add_(polygonAndNormalVectorObject);
				return null;
			}
		});
		final JunOpenGL3dCompoundObject glTransfomedHedronAndNormalVectors = new JunOpenGL3dCompoundObject();
		glTransformedHedron.polygonsDo_(new StBlockClosure() {
			public Object value_(Object obj) {
				JunOpenGL3dVertexesObject polygon = (JunOpenGL3dVertexesObject) obj;
				JunOpenGL3dCompoundObject polygonAndNormalVectorObject = new JunOpenGL3dCompoundObject();
				polygonAndNormalVectorObject.add_(polygon);
				polygonAndNormalVectorObject.add_(polygon.normalVectorObject());
				glTransfomedHedronAndNormalVectors.add_(polygonAndNormalVectorObject);
				return null;
			}
		});

		JunOpenGL3dPolygon mirrorPlane = new JunOpenGL3dPolygon(new Jun3dPoint[] { new Jun3dPoint(0, 0, -1), new Jun3dPoint(0, 0, 1), new Jun3dPoint(1, 0, 1), new Jun3dPoint(1, 0, -1) });
		mirrorPlane.paint_(Color.cyan);
		mirrorPlane.halftone_(0.25);

		JunOpenGL3dCompoundObject junDisplayObject = new JunOpenGL3dCompoundObject(originalHedronAndNormalVectors, junTransformedHedronAndNormalVectors, JunOpenGL3dObject.Axes().scaledBy_(4), mirrorPlane.scaledBy_(4));
		JunOpenGL3dCompoundObject glDisplayObject = new JunOpenGL3dCompoundObject(originalHedronAndNormalVectors, glTransfomedHedronAndNormalVectors, JunOpenGL3dObject.Axes().scaledBy_(4), mirrorPlane.scaledBy_(4));

		Hashtable projectionTable = new Hashtable();
		projectionTable.put($("presentation"), $("solidPresentation"));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("eyePoint"), new Jun3dPoint(40, 8, 20));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("upVector"), new Jun3dPoint(0, 0, 1));
		projectionTable.put($("viewFactor"), new Double(10));
		projectionTable.put($("zoomHeight"), new Double(8));

		junDisplayObject.showProjectionTable_in_(projectionTable, new Rectangle(100, 270, 300, 300));
		glDisplayObject.showProjectionTable_in_(projectionTable, new Rectangle(400, 270, 300, 300));

		return true;
	}

	/**
	 * Example8:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8() {
		JunOpenGL3dCompoundObject aBall = (JunOpenGL3dCompoundObject) JunOpenGL3dObject.Ball();
		aBall.paint_(Color.red);
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.displayObject_(aBall);
		displayModel.defaultShading_($("smoothShading"));
		displayModel.openIn_(new Rectangle(100, 270, 300, 300));

		JunOpenGL3dCompoundObject patchedObject = aBall.asPatchedObject();
		displayModel = new JunOpenGLDisplayModel();
		displayModel.displayObject_(patchedObject);
		displayModel.defaultShading_($("smoothShading"));
		displayModel.openIn_(new Rectangle(400, 270, 300, 300));

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGL3dPatchedObjectTestExamples();
	}

}
