package jp.co.sra.jun.opengl.objects;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

import jp.co.sra.smalltalk.SmalltalkException;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StSymbol;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.geometry.curves.Jun3dLine;
import jp.co.sra.jun.geometry.surfaces.Jun3dTriangle;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispNil;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.opengl.display.JunOpenGL3dModel;
import jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjects;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsArrow;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsBall;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsBox;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsChemical;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsCircle;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsCone;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsCylinder;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsHedron;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsImage;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsMisc;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsMobius;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsPie;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsPlate;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsShpere;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsSpring;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsText;
import jp.co.sra.jun.opengl.objects.typical.JunOpenGL3dTypicalObjectsTorus;
import jp.co.sra.jun.opengl.support.JunOpenGLRenderingContext;
import jp.co.sra.jun.opengl.texture.JunOpenGLStipple;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.system.framework.JunAbstractObject;
import jp.co.sra.jun.vrml.support.JunVrmlRenderingContext;

/**
 * JunOpenGL3dObject class
 * 
 *  @author    nisinaka
 *  @created   1998/10/13 (by nisinaka)
 *  @updated   1999/08/04 (by nisinaka)
 *  @updated   2000/01/06 (by nisinaka)
 *  @updated   2001/11/20 (by nisinaka)
 *  @updated   2004/05/14 (by nisinaka)
 *  @updated   2004/09/29 (by m-asada)
 *  @updated   2004/11/12 (by m-asada)
 *  @updated   2006/04/11 (by m-asada)
 *  @updated   2006/04/18 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dObject.java,v 8.38 2008/02/20 06:32:35 nisinaka Exp $
 */
public abstract class JunOpenGL3dObject extends JunAbstractObject {
	/** unique clock value for id */
	private static long IdClock = System.currentTimeMillis();

	/** unique id number */
	private static long IdNumber = 0;

	/** A string for an indentation of VRML output */
	protected static final String INDENT = "\t";

	/** The name of the object. */
	protected String name;

	/** The color of the object. */
	protected Color paint;

	/** The alpha of the object. */
	protected float alpha;

	/** The bounding box of the object. */
	protected Jun3dBoundingBox bounds;

	/**
	 * Answer the default color to paint JunOpenGL3dObject.
	 * 
	 * @return java.awt.Color
	 * @category Defaults
	 */
	public static Color DefaultPaint() {
		return Color.white;
	}

	/**
	 * Load a JunOpenGL3dObject from the object.
	 * 
	 * @param anObject java.lang.Object
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Lisp support
	 */
	public static JunOpenGL3dObject LoadFrom_(Object anObject) {
		JunLispList aList = (JunLispList) JunLispParser.Parse_(anObject);
		if ((aList != null) && aList instanceof JunLispCons) {
			return JunOpenGL3dCompoundObject.ObjectFromLispList_((JunLispCons) aList);
		} else {
			return null;
		}
	}

	/**
	 * Popup a window which displays the Lisp List.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Lisp support
	 */
	public static JunLispList ShowLispList_(JunLispList aList) {
		TextArea textArea = new TextArea(5, 40);
		textArea.setEditable(false);
		textArea.append(aList.saveString());

		Frame aFrame = new Frame();
		aFrame.add("Center", textArea);
		aFrame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		aFrame.setTitle("Lisp List");
		aFrame.pack();
		aFrame.setVisible(true);

		return aList;
	}

	/**
	 * Get a transformation from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @return jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category Lisp support
	 */
	public static Jun3dTransformation TransformationFromLispList_(JunLispList aList) {
		JunLispCons list = (JunLispCons) aList.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object anObject) {
				return new Boolean(anObject instanceof JunLispCons && (((JunLispCons) anObject).head() == $("transformation")));
			}
		}, new StBlockClosure());

		if (list == null) {
			return null;
		}

		Object[] anArray = ((JunLispCons) list.tail()).asArray();
		double[] array = new double[16];
		for (int i = 0; i < 16; i++) {
			array[i] = ((Number) anArray[i]).doubleValue();
		}

		return Jun3dTransformation.FromArray_(array);
	}

	/**
	 * Create a lisp list from the Jun3dTransformation.
	 * 
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Lisp support
	 */
	public static JunLispList TransformationToLispList_(Jun3dTransformation aTransformation) {
		double[] array = aTransformation.asArray();

		JunLispCons list = JunLispCons.Cell();
		list.head_($("transformation"));
		list.add_(new Double(array[0]));
		list.add_(new Double(array[1]));
		list.add_(new Double(array[2]));
		list.add_(new Double(array[3]));
		list.add_(new Double(array[4]));
		list.add_(new Double(array[5]));
		list.add_(new Double(array[6]));
		list.add_(new Double(array[7]));
		list.add_(new Double(array[8]));
		list.add_(new Double(array[9]));
		list.add_(new Double(array[10]));
		list.add_(new Double(array[11]));
		list.add_(new Double(array[12]));
		list.add_(new Double(array[13]));
		list.add_(new Double(array[14]));
		list.add_(new Double(array[15]));
		return list;
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowFrom_to_(Jun3dPoint fromPoint, Jun3dPoint toPoint) {
		return JunOpenGL3dTypicalObjectsArrow.ArrowFrom_to_(fromPoint, toPoint);
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param colorValue java.awt.Color
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowFrom_to_color_(Jun3dPoint fromPoint, Jun3dPoint toPoint, Color colorValue) {
		return JunOpenGL3dTypicalObjectsArrow.ArrowFrom_to_color_(fromPoint, toPoint, colorValue);
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param colorValue java.awt.Color
	 * @param lineWidth float
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowFrom_to_color_lineWidth_(Jun3dPoint fromPoint, Jun3dPoint toPoint, Color colorValue, float lineWidth) {
		return JunOpenGL3dTypicalObjectsArrow.ArrowFrom_to_color_lineWidth_(fromPoint, toPoint, colorValue, lineWidth);
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param aLine jp.co.sra.jun.geometry.curves.Jun3dLine
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowLine_(Jun3dLine aLine) {
		return JunOpenGL3dTypicalObjectsArrow.ArrowLine_(aLine);
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param aLine jp.co.sra.jun.geometry.curves.Jun3dLine
	 * @param colorValue java.awt.Color
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowLine_color_lineWidth_(Jun3dLine aLine, Color colorValue) {
		return JunOpenGL3dTypicalObjectsArrow.ArrowLine_color_lineWidth_(aLine, colorValue);
	}

	/**
	 * Typical objects - Arrow
	 * 
	 * @param aLine jp.co.sra.jun.geometry.curves.Jun3dLine
	 * @param colorValue java.awt.Color
	 * @param lineWidth float
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ArrowLine_color_lineWidth_(Jun3dLine aLine, Color colorValue, float lineWidth) {
		return JunOpenGL3dTypicalObjectsArrow.ArrowLine_color_lineWidth_(aLine, colorValue, lineWidth);
	}

	/**
	 * Typical objects - xArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XArrow() {
		return JunOpenGL3dTypicalObjectsArrow.XArrow();
	}

	/**
	 * Typical objects - xUnitArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XUnitArrow() {
		return JunOpenGL3dTypicalObjectsArrow.XUnitArrow();
	}

	/**
	 * Typical objects - xyArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XyArrows() {
		return JunOpenGL3dTypicalObjectsArrow.XyArrows();
	}

	/**
	 * Typical objects - xyUnitArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XyUnitArrows() {
		return JunOpenGL3dTypicalObjectsArrow.XyUnitArrows();
	}

	/**
	 * Typical objects - xyzArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XyzArrows() {
		return JunOpenGL3dTypicalObjectsArrow.XyzArrows();
	}

	/**
	 * Typical objects - xyzUnitArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject XyzUnitArrows() {
		return JunOpenGL3dTypicalObjectsArrow.XyzUnitArrows();
	}

	/**
	 * Typical objects - yArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject YArrow() {
		return JunOpenGL3dTypicalObjectsArrow.YArrow();
	}

	/**
	 * Typical objects - yUnitArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject YUnitArrow() {
		return JunOpenGL3dTypicalObjectsArrow.YUnitArrow();
	}

	/**
	 * Typical objects - yzArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject YzArrows() {
		return JunOpenGL3dTypicalObjectsArrow.YzArrows();
	}

	/**
	 * Typical objects - yzUnitArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject YzUnitArrows() {
		return JunOpenGL3dTypicalObjectsArrow.YzUnitArrows();
	}

	/**
	 * Typical objects - zArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ZArrow() {
		return JunOpenGL3dTypicalObjectsArrow.ZArrow();
	}

	/**
	 * Typical objects - zUnitArrow
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ZUnitArrow() {
		return JunOpenGL3dTypicalObjectsArrow.ZUnitArrow();
	}

	/**
	 * Typical objects - zxArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ZxArrows() {
		return JunOpenGL3dTypicalObjectsArrow.ZxArrows();
	}

	/**
	 * Typical objects - zxUnitArrows
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects arrow
	 */
	public static JunOpenGL3dObject ZxUnitArrows() {
		return JunOpenGL3dTypicalObjectsArrow.ZxUnitArrows();
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball() {
		return JunOpenGL3dTypicalObjectsBall.Ball();
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param smoothInteger int
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball_(int smoothInteger) {
		return JunOpenGL3dTypicalObjectsBall.Ball_(smoothInteger);
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param smoothInteger int
	 * @param radius double
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball_radius_(int smoothInteger, double radius) {
		return JunOpenGL3dTypicalObjectsBall.Ball_radius_(smoothInteger, radius);
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param smoothInteger int
	 * @param radius double
	 * @param center jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball_radius_center_(int smoothInteger, double radius, Jun3dPoint center) {
		return JunOpenGL3dTypicalObjectsBall.Ball_radius_center_(smoothInteger, radius, center);
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param aBall jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param anInteger int
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball_smooth_(JunOpenGL3dObject aBall, int anInteger) {
		return JunOpenGL3dTypicalObjectsBall.Ball_smooth_(aBall, anInteger);
	}

	/**
	 * Typical objects - ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param aBall jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param anInteger int
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Ball_smooth_interim_(JunOpenGL3dObject aBall, int anInteger, StBlockClosure aBlock) {
		return JunOpenGL3dTypicalObjectsBall.Ball_smooth_interim_(aBall, anInteger, aBlock);
	}

	/**
	 * Typical objects - ball hedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject BallHedron() {
		return JunOpenGL3dTypicalObjectsBall.BallHedron();
	}

	/**
	 * Typical objects - color ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject ColorBall() {
		return JunOpenGL3dTypicalObjectsBall.ColorBall();
	}

	/**
	 * Typical objects - color ball
	 * 
	 * @param smoothInteger int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject ColorBall_(int smoothInteger) {
		return JunOpenGL3dTypicalObjectsBall.ColorBall_(smoothInteger);
	}

	/**
	 * Typical objects - color ball
	 * 
	 * @param smoothInteger int
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject ColorBall_radius_(int smoothInteger, double radius) {
		return JunOpenGL3dTypicalObjectsBall.ColorBall_radius_(smoothInteger, radius);
	}

	/**
	 * Typical objects - color ball
	 * 
	 * @param smoothInteger int
	 * @param radius double
	 * @param center jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject ColorBall_radius_center_(int smoothInteger, double radius, Jun3dPoint center) {
		return JunOpenGL3dTypicalObjectsBall.ColorBall_radius_center_(smoothInteger, radius, center);
	}

	/**
	 * Typical objects - earth
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject Earth() {
		return JunOpenGL3dTypicalObjectsBall.Earth();
	}

	/**
	 * Typical objects - soccer ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject SoccerBall() {
		return JunOpenGL3dTypicalObjectsBall.SoccerBall();
	}

	/**
	 * Typical objects - x unit ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects ball
	 */
	public static JunOpenGL3dObject XUnitBall() {
		return JunOpenGL3dTypicalObjectsBall.XUnitBall();
	}

	/**
	 * Typical objects - box
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject Box() {
		return JunOpenGL3dTypicalObjectsBox.Box();
	}

	/**
	 * Typical objects - box
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject Box_(Jun3dPoint aPoint) {
		return JunOpenGL3dTypicalObjectsBox.Box_(aPoint);
	}

	/**
	 * Typical objects - color cube
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject ColorCube() {
		return JunOpenGL3dTypicalObjectsBox.ColorCube();
	}

	/**
	 * Typical objects - cube
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject Cube() {
		return JunOpenGL3dTypicalObjectsBox.Cube();
	}

	/**
	 * Typical objects - box
	 * 
	 * @param originPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param cornerPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject Origin_corner_(Jun3dPoint originPoint, Jun3dPoint cornerPoint) {
		return JunOpenGL3dTypicalObjectsBox.Origin_corner_(originPoint, cornerPoint);
	}

	/**
	 * Typical objects - box
	 * 
	 * @param originPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param extentPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject Origin_extent_(Jun3dPoint originPoint, Jun3dPoint extentPoint) {
		return JunOpenGL3dTypicalObjectsBox.Origin_extent_(originPoint, extentPoint);
	}

	/**
	 * Typical objects - x unit box
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects box
	 */
	public static JunOpenGL3dObject XUnitBox() {
		return JunOpenGL3dTypicalObjectsBox.XUnitBox();
	}

	/**
	 * Typical objects - acetylcholine
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Acetylcholine() {
		return JunOpenGL3dTypicalObjectsChemical.Acetylcholine();
	}

	/**
	 * Typical objects - adrenaline
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Adrenaline() {
		return JunOpenGL3dTypicalObjectsChemical.Adrenaline();
	}

	/**
	 * Typical objects - alanine
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Alanine() {
		return JunOpenGL3dTypicalObjectsChemical.Alanine();
	}

	/**
	 * Typical objects - anthracene
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Anthracene() {
		return JunOpenGL3dTypicalObjectsChemical.Anthracene();
	}

	/**
	 * Typical objects - benzene
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Benzene() {
		return JunOpenGL3dTypicalObjectsChemical.Benzene();
	}

	/**
	 * Typical objects - capsaicin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Capsaicin() {
		return JunOpenGL3dTypicalObjectsChemical.Capsaicin();
	}

	/**
	 * Typical objects - catechin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Catechin() {
		return JunOpenGL3dTypicalObjectsChemical.Catechin();
	}

	/**
	 * Typical objects - chloroform
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Chloroform() {
		return JunOpenGL3dTypicalObjectsChemical.Chloroform();
	}

	/**
	 * Typical objects - cystine
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Cystine() {
		return JunOpenGL3dTypicalObjectsChemical.Cystine();
	}

	/**
	 * Typical objects - dopamine
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Dopamine() {
		return JunOpenGL3dTypicalObjectsChemical.Dopamine();
	}

	/**
	 * Typical objects - luminol
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Luminol() {
		return JunOpenGL3dTypicalObjectsChemical.Luminol();
	}

	/**
	 * Typical objects - melatonin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Melatonin() {
		return JunOpenGL3dTypicalObjectsChemical.Melatonin();
	}

	/**
	 * Typical objects - methane
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Methane() {
		return JunOpenGL3dTypicalObjectsChemical.Methane();
	}

	/**
	 * Typical objects - naphthalene
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Naphthalene() {
		return JunOpenGL3dTypicalObjectsChemical.Naphthalene();
	}

	/**
	 * Typical objects - serotonin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Serotonin() {
		return JunOpenGL3dTypicalObjectsChemical.Serotonin();
	}

	/**
	 * Typical objects - tryptophan
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Tryptophan() {
		return JunOpenGL3dTypicalObjectsChemical.Tryptophan();
	}

	/**
	 * Typical objects - tyrosine
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Tyrosine() {
		return JunOpenGL3dTypicalObjectsChemical.Tyrosine();
	}

	/**
	 * Typical objects - Water
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects chemical
	 */
	public static JunOpenGL3dObject Water() {
		return JunOpenGL3dTypicalObjectsChemical.Water();
	}

	/**
	 * Typical objects - circle
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects circle
	 */
	public static JunOpenGL3dObject Circle() {
		return JunOpenGL3dTypicalObjectsCircle.Circle();
	}

	/**
	 * Typical objects - circle
	 * 
	 * @param degrees double
	 * @category Typical objects circle
	 */
	public static JunOpenGL3dObject CircleBy_(double degrees) {
		return JunOpenGL3dTypicalObjectsCircle.CircleBy_(degrees);
	}

	/**
	 * Typical objects - circle
	 * 
	 * @param degrees double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects circle
	 */
	public static JunOpenGL3dObject CircleBy_radius_(double degrees, double radius) {
		return JunOpenGL3dTypicalObjectsCircle.CircleBy_radius_(degrees, radius);
	}

	/**
	 * Typical objects - circle
	 * 
	 * @param byDegrees double
	 * @param radiusValue double
	 * @param upVector jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects circle
	 */
	public static JunOpenGL3dObject CircleBy_radius_upVector_(double byDegrees, double radiusValue, Jun3dPoint upVector) {
		return JunOpenGL3dTypicalObjectsCircle.CircleBy_radius_upVector_(byDegrees, radiusValue, upVector);
	}

	/**
	 * Typical objects - circle
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects circle
	 */
	public static JunOpenGL3dObject XUnitCircle() {
		return JunOpenGL3dTypicalObjectsCircle.XUnitCircle();
	}

	/**
	 * Typical objects - cone
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject ColorCone() {
		return JunOpenGL3dTypicalObjectsCone.ColorCone();
	}

	/**
	 * Typical objects - cone
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject Cone() {
		return JunOpenGL3dTypicalObjectsCone.Cone();
	}

	/**
	 * Typical objects - cone
	 * 
	 * @param degrees double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject Cone_(double degrees) {
		return JunOpenGL3dTypicalObjectsCone.Cone_(degrees);
	}

	/**
	 * Typical objects - cone
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param height double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject Cone_radius_height_(double degrees, double radius, double height) {
		return JunOpenGL3dTypicalObjectsCone.Cone_radius_height_(degrees, radius, height);
	}

	/**
	 * Typical object - cone.
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aRadius double
	 * @param divisionNumber int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject ConeFrom_to_radius_by_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double aRadius, int divisionNumber) {
		return JunOpenGL3dTypicalObjectsCone.ConeFrom_to_radius_by_(fromPoint, toPoint, aRadius, divisionNumber);
	}

	/**
	 * Typical object - cone.
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param widthFactor double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject ConeFrom_to_width_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double widthFactor) {
		return JunOpenGL3dTypicalObjectsCone.ConeFrom_to_width_(fromPoint, toPoint, widthFactor);
	}

	/**
	 * Typical object - xUnitCone.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cone
	 */
	public static JunOpenGL3dObject XUnitCone() {
		return JunOpenGL3dTypicalObjectsCone.XUnitCone();
	}

	/**
	 * Typical object - cylinder.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject Cylinder() {
		return JunOpenGL3dTypicalObjectsCylinder.Cylinder();
	}

	/**
	 * Typical object - cylinder with the specified degree.
	 * 
	 * @param degree double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderBy_(double degree) {
		return JunOpenGL3dTypicalObjectsCylinder.CylinderBy_(degree);
	}

	/**
	 * Typical object - cylinder with the specified degree and radius.
	 * 
	 * @param degree double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderBy_radius_(double degree, double radius) {
		return JunOpenGL3dTypicalObjectsCylinder.CylinderBy_radius_(degree, radius);
	}

	/**
	 * Typical object - cylinder with the specified degree, radius and height.
	 * 
	 * @param degree double
	 * @param radius double
	 * @param height double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderBy_radius_height_(double degree, double radius, double height) {
		return JunOpenGL3dTypicalObjectsCylinder.CylinderBy_radius_height_(degree, radius, height);
	}

	/**
	 * Typical object - cylinder with the specified from point, to point, radius and division.
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param aRadius double
	 * @param divisionNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderFrom_to_radius_by_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double aRadius, double divisionNumber) {
		return JunOpenGL3dTypicalObjectsCylinder.CylinderFrom_to_radius_by_(fromPoint, toPoint, aRadius, divisionNumber);
	}

	/**
	 * Typical object - cylinder with the specified from point, to point and width factor.
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param widthFactor double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderFrom_to_width_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double widthFactor) {
		return JunOpenGL3dTypicalObjectsCylinder.CylinderFrom_to_width_(fromPoint, toPoint, widthFactor);
	}

	/**
	 * Typical object - cylinder with the specified from point, to point, width factor and degree.
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param widthFactor double
	 * @param byDegree double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject CylinderFrom_to_width_by_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double widthFactor, double byDegree) {
		return JunOpenGL3dTypicalObjectsCylinder.CylinderFrom_to_width_by_(fromPoint, toPoint, widthFactor, byDegree);
	}

	/**
	 * Typical object - xUnitCylinder.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects cylinder
	 */
	public static JunOpenGL3dObject XUnitCylinder() {
		return JunOpenGL3dTypicalObjectsCylinder.XUnitCylinder();
	}

	/**
	 * Typical objects - cuboctahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject Cuboctahedron() {
		return JunOpenGL3dTypicalObjectsHedron.Cuboctahedron();
	}

	/**
	 * Typical objects - icosidodecahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject Icosidodecahedron() {
		return JunOpenGL3dTypicalObjectsHedron.Icosidodecahedron();
	}

	/**
	 * Typical objects - pentakis dodecahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject PentakisDodecahedron() {
		return JunOpenGL3dTypicalObjectsHedron.PentakisDodecahedron();
	}

	/**
	 * Typical objects - regular dodecahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject RegularDodecahedron() {
		return JunOpenGL3dTypicalObjectsHedron.RegularDodecahedron();
	}

	/**
	 * Typical objects - regular hexahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject RegularHexahedron() {
		return JunOpenGL3dTypicalObjectsHedron.RegularHexahedron();
	}

	/**
	 * Typical objects - regular icosahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject RegularIcosahedron() {
		return JunOpenGL3dTypicalObjectsHedron.RegularIcosahedron();
	}

	/**
	 * Typical objects - regular octahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject RegularOctahedron() {
		return JunOpenGL3dTypicalObjectsHedron.RegularOctahedron();
	}

	/**
	 * Typical objects - regular tetrahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject RegularTetrahedron() {
		return JunOpenGL3dTypicalObjectsHedron.RegularTetrahedron();
	}

	/**
	 * Typical objects - tetrakis hexahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TetrakisHexahedron() {
		return JunOpenGL3dTypicalObjectsHedron.TetrakisHexahedron();
	}

	/**
	 * Typical objects - triakis icosahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TriakisIcosahedron() {
		return JunOpenGL3dTypicalObjectsHedron.TriakisIcosahedron();
	}

	/**
	 * Typical objects - triakis octahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TriakisOctahedron() {
		return JunOpenGL3dTypicalObjectsHedron.TriakisOctahedron();
	}

	/**
	 * Typical objects - truncated dodecahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TruncatedDodecahedron() {
		return JunOpenGL3dTypicalObjectsHedron.TruncatedDodecahedron();
	}

	/**
	 * Typical objects - truncated hexahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TruncatedHexahedron() {
		return JunOpenGL3dTypicalObjectsHedron.TruncatedHexahedron();
	}

	/**
	 * Typical objects - truncated icosahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TruncatedIcosahedron() {
		return JunOpenGL3dTypicalObjectsHedron.TruncatedIcosahedron();
	}

	/**
	 * Typical objects - truncated octahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TruncatedOctahedron() {
		return JunOpenGL3dTypicalObjectsHedron.TruncatedOctahedron();
	}

	/**
	 * Typical objects - truncated tetrahedron
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects hedron
	 */
	public static JunOpenGL3dObject TruncatedTetrahedron() {
		return JunOpenGL3dTypicalObjectsHedron.TruncatedTetrahedron();
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageBMWC() {
		return JunOpenGL3dTypicalObjectsImage.ImageBMWC();
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageBMWC_(int imageSize) {
		return JunOpenGL3dTypicalObjectsImage.ImageBMWC_(imageSize);
	}

	/**
	 * Typical objects - image earth
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageEarth() {
		return JunOpenGL3dTypicalObjectsImage.ImageEarth();
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageGCWY() {
		return JunOpenGL3dTypicalObjectsImage.ImageGCWY();
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageGCWY_(int imageSize) {
		return JunOpenGL3dTypicalObjectsImage.ImageGCWY_(imageSize);
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageKBCG() {
		return JunOpenGL3dTypicalObjectsImage.ImageKBCG();
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageKBCG_(int imageSize) {
		return JunOpenGL3dTypicalObjectsImage.ImageKBCG_(imageSize);
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageKGYR() {
		return JunOpenGL3dTypicalObjectsImage.ImageKGYR();
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageKGYR_(int imageSize) {
		return JunOpenGL3dTypicalObjectsImage.ImageKGYR_(imageSize);
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageKRMB() {
		return JunOpenGL3dTypicalObjectsImage.ImageKRMB();
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageKRMB_(int imageSize) {
		return JunOpenGL3dTypicalObjectsImage.ImageKRMB_(imageSize);
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageRBBR() {
		return JunOpenGL3dTypicalObjectsImage.ImageRBBR();
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageRBBR_(int imageSize) {
		return JunOpenGL3dTypicalObjectsImage.ImageRBBR_(imageSize);
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageRGBR() {
		return JunOpenGL3dTypicalObjectsImage.ImageRGBR();
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageRGBR_(int imageSize) {
		return JunOpenGL3dTypicalObjectsImage.ImageRGBR_(imageSize);
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category Typical objects image
	 */
	public static StImage ImageRYWM() {
		return JunOpenGL3dTypicalObjectsImage.ImageRYWM();
	}

	/**
	 * Typical objects - objects image
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @param imageSize int
	 * @category Typical objects image
	 */
	public static StImage ImageRYWM_(int imageSize) {
		return JunOpenGL3dTypicalObjectsImage.ImageRYWM_(imageSize);
	}

	/**
	 * Typical objects - Anpanman
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Anpanman() {
		return JunOpenGL3dTypicalObjectsMisc.Anpanman();
	}

	/**
	 * Typical objects - Aoki
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Aoki() {
		return JunOpenGL3dTypicalObjectsMisc.Aoki();
	}

	/**
	 * Typical objects - Aoki1
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Aoki1() {
		return JunOpenGL3dTypicalObjectsMisc.Aoki1();
	}

	/**
	 * Typical objects - Aoki2
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Aoki2() {
		return JunOpenGL3dTypicalObjectsMisc.Aoki2();
	}

	/**
	 * Typical objects - Arowana
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Arowana() {
		return JunOpenGL3dTypicalObjectsMisc.Arowana();
	}

	/**
	 * Typical objects - axes
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Axes() {
		return JunOpenGL3dTypicalObjectsMisc.Axes();
	}

	/**
	 * Typical objects - axes
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Axes2() {
		return JunOpenGL3dTypicalObjectsMisc.Axes2();
	}

	/**
	 * Typical objects - Baby
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Baby() {
		return JunOpenGL3dTypicalObjectsMisc.Baby();
	}

	/**
	 * Typical objects - Bell
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Bell() {
		return JunOpenGL3dTypicalObjectsMisc.Bell();
	}

	/**
	 * Typical objects - Dolphin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Dolphin() {
		return JunOpenGL3dTypicalObjectsMisc.Dolphin();
	}

	/**
	 * Typical objects - Doraemon
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Doraemon() {
		return JunOpenGL3dTypicalObjectsMisc.Doraemon();
	}

	/**
	 * Typical objects - Earl
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Earl() {
		return JunOpenGL3dTypicalObjectsMisc.Earl();
	}

	/**
	 * typical objects misc
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Eddy() {
		return JunOpenGL3dTypicalObjectsMisc.Eddy();
	}

	/**
	 * Typical objects - Hand
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Hand() {
		return JunOpenGL3dTypicalObjectsMisc.Hand();
	}

	/**
	 * Typical object - Mickey
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Mickey() {
		return JunOpenGL3dTypicalObjectsMisc.Mickey();
	}

	/**
	 * Typical object - Mickey1
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Mickey1() {
		return JunOpenGL3dTypicalObjectsMisc.Mickey1();
	}

	/**
	 * Typical object - Mickey3
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Mickey3() {
		return JunOpenGL3dTypicalObjectsMisc.Mickey3();
	}

	/**
	 * Typical object - Minnie
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Minnie() {
		return JunOpenGL3dTypicalObjectsMisc.Minnie();
	}

	/**
	 * Typical object - Mouse
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Mouse() {
		return JunOpenGL3dTypicalObjectsMisc.Mouse();
	}

	/**
	 * Typical objects - Oni
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Oni() {
		return JunOpenGL3dTypicalObjectsMisc.Oni();
	}

	/**
	 * Typical objects - Panda
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Panda() {
		return JunOpenGL3dTypicalObjectsMisc.Panda();
	}

	/**
	 * Typical objects - Panda2
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Panda2() {
		return JunOpenGL3dTypicalObjectsMisc.Panda2();
	}

	/**
	 * Typical objects - Penguin
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Penguin() {
		return JunOpenGL3dTypicalObjectsMisc.Penguin();
	}

	/**
	 * Typical object - Pooh
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Pooh() {
		return JunOpenGL3dTypicalObjectsMisc.Pooh();
	}

	/**
	 * Typical objects - Raptor
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Raptor() {
		return JunOpenGL3dTypicalObjectsMisc.Raptor();
	}

	/**
	 * Typical object - Smalltalk.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Smalltalk() {
		return JunOpenGL3dTypicalObjectsMisc.Smalltalk();
	}

	/**
	 * Typical object - Smalltalk Cube.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject SmalltalkCube() {
		return JunOpenGL3dTypicalObjectsMisc.SmalltalkCube();
	}

	/**
	 * Typical object - Smalltalk Plane.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject SmalltalkPlane() {
		return JunOpenGL3dTypicalObjectsMisc.SmalltalkPlane();
	}

	/**
	 * typical objects misc
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Stack() {
		return JunOpenGL3dTypicalObjectsMisc.Stack();
	}

	/**
	 * Typical objects - Triple Ball
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Triball() {
		return JunOpenGL3dTypicalObjectsMisc.Triball();
	}

	/**
	 * Typical objects - Wasp
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Wasp() {
		return JunOpenGL3dTypicalObjectsMisc.Wasp();
	}

	/**
	 * Typical objects - Wyvern
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects misc
	 */
	public static JunOpenGL3dObject Wyvern() {
		return JunOpenGL3dTypicalObjectsMisc.Wyvern();
	}

	/**
	 * Typical object - mobius
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject Mobius() {
		return JunOpenGL3dTypicalObjectsMobius.Mobius();
	}

	/**
	 * Typical object - mobius
	 * 
	 * @param mobiusRadius double
	 * @param mobiusDivision int
	 * @param stripRadius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusRadius_divisions_stripRadius_(double mobiusRadius, int mobiusDivision, double stripRadius) {
		return JunOpenGL3dTypicalObjectsMobius.MobiusRadius_divisions_stripRadius_(mobiusRadius, mobiusDivision, stripRadius);
	}

	/**
	 * Typical object - mobius
	 * 
	 * @param mobiusRadius double
	 * @param mobiusDivision int
	 * @param stripRadius double
	 * @param stripDivision int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusRadius_divisions_stripRadius_divisions_(double mobiusRadius, int mobiusDivision, double stripRadius, int stripDivision) {
		return JunOpenGL3dTypicalObjectsMobius.MobiusRadius_divisions_stripRadius_divisions_(mobiusRadius, mobiusDivision, stripRadius, stripDivision);
	}

	/**
	 * Typical object - mobius
	 * 
	 * @param mobiusRadius double
	 * @param mobiusDivision int
	 * @param stripRadius double
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusRadius_divisions_stripRadius_locusDo_(double mobiusRadius, int mobiusDivision, double stripRadius, StBlockClosure aBlock) {
		return JunOpenGL3dTypicalObjectsMobius.MobiusRadius_divisions_stripRadius_locusDo_(mobiusRadius, mobiusDivision, stripRadius, aBlock);
	}

	/**
	 * Typical object - mobius
	 * 
	 * @param mobiusRadius double
	 * @param stripRadius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusRadius_stripRadius_(double mobiusRadius, double stripRadius) {
		return JunOpenGL3dTypicalObjectsMobius.MobiusRadius_stripRadius_(mobiusRadius, stripRadius);
	}

	/**
	 * Typical object - mobius strip
	 * 
	 * @param mobiusRadius double
	 * @param stripRadius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusStrip() {
		return JunOpenGL3dTypicalObjectsMobius.MobiusStrip();
	}

	/**
	 * Typical object - mobius strip
	 * 
	 * @param mobiusRadius double
	 * @param mobiusDivision int
	 * @param stripRadius double
	 * @param stripDivision int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusStripRadius_divisions_stripRadius_divisions_(double mobiusRadius, int mobiusDivision, double stripRadius, int stripDivision) {
		return JunOpenGL3dTypicalObjectsMobius.MobiusStripRadius_divisions_stripRadius_divisions_(mobiusRadius, mobiusDivision, stripRadius, stripDivision);
	}

	/**
	 * Typical object - mobius strip
	 * 
	 * @param mobiusRadius double
	 * @param mobiusDivision int
	 * @param stripRadius double
	 * @param stripDivision int
	 * @param thicknessFactor double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects mobius
	 */
	public static JunOpenGL3dObject MobiusStripRadius_divisions_stripRadius_divisions_thicknessFactor_(double mobiusRadius, int mobiusDivision, double stripRadius, int stripDivision, double thicknessFactor) {
		return JunOpenGL3dTypicalObjectsMobius.MobiusStripRadius_divisions_stripRadius_divisions_thicknessFactor_(mobiusRadius, mobiusDivision, stripRadius, stripDivision, thicknessFactor);
	}

	/**
	 * Typical object - chunk of pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject ChunkOfPieFrom_to_by_(double fromDegree, double toDegree, double byDegree) {
		return JunOpenGL3dTypicalObjectsPie.ChunkOfPieFrom_to_by_(fromDegree, toDegree, byDegree);
	}

	/**
	 * Typical object - chunk of pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject ChunkOfPieFrom_to_by_radius_(double fromDegree, double toDegree, double byDegree, double radius) {
		return JunOpenGL3dTypicalObjectsPie.ChunkOfPieFrom_to_by_radius_(fromDegree, toDegree, byDegree, radius);
	}

	/**
	 * Typical object - chunk of pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @param thickness double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject ChunkOfPieFrom_to_by_radius_thickness_(double fromDegree, double toDegree, double byDegree, double radius, double thickness) {
		return JunOpenGL3dTypicalObjectsPie.ChunkOfPieFrom_to_by_radius_thickness_(fromDegree, toDegree, byDegree, radius, thickness);
	}

	/**
	 * Typical object - pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject PieFrom_to_by_(double fromDegree, double toDegree, double byDegree) {
		return JunOpenGL3dTypicalObjectsPie.PieFrom_to_by_(fromDegree, toDegree, byDegree);
	}

	/**
	 * Typical object - pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject PieFrom_to_by_radius_(double fromDegree, double toDegree, double byDegree, double radius) {
		return JunOpenGL3dTypicalObjectsPie.PieFrom_to_by_radius_(fromDegree, toDegree, byDegree, radius);
	}

	/**
	 * Typical object - pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @param thickness double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject PieFrom_to_by_radius_thickness_(double fromDegree, double toDegree, double byDegree, double radius, double thickness) {
		return JunOpenGL3dTypicalObjectsPie.PieFrom_to_by_radius_thickness_(fromDegree, toDegree, byDegree, radius, thickness);
	}

	/**
	 * Typical object - sliced pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject SlicedPieFrom_to_by_(double fromDegree, double toDegree, double byDegree) {
		return JunOpenGL3dTypicalObjectsPie.SlicedPieFrom_to_by_(fromDegree, toDegree, byDegree);
	}

	/**
	 * Typical object - sliced pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject SlicedPieFrom_to_by_radius_(double fromDegree, double toDegree, double byDegree, double radius) {
		return JunOpenGL3dTypicalObjectsPie.SlicedPieFrom_to_by_radius_(fromDegree, toDegree, byDegree, radius);
	}

	/**
	 * Typical object - sliced pie.
	 * 
	 * @param fromDegree double
	 * @param toDegree double
	 * @param byDegree double
	 * @param radius double
	 * @param thickness double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects pie
	 */
	public static JunOpenGL3dObject SlicedPieFrom_to_by_radius_thickness_(double fromDegree, double toDegree, double byDegree, double radius, double thickness) {
		return JunOpenGL3dTypicalObjectsPie.SlicedPieFrom_to_by_radius_thickness_(fromDegree, toDegree, byDegree, radius, thickness);
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateBMWC() {
		return JunOpenGL3dTypicalObjectsPlate.PlateBMWC();
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateGCWY() {
		return JunOpenGL3dTypicalObjectsPlate.PlateGCWY();
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateKBCG() {
		return JunOpenGL3dTypicalObjectsPlate.PlateKBCG();
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateKGYR() {
		return JunOpenGL3dTypicalObjectsPlate.PlateKGYR();
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateKRMB() {
		return JunOpenGL3dTypicalObjectsPlate.PlateKRMB();
	}

	/**
	 * Typical objects - objects plate
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects plate
	 */
	public static JunOpenGL3dObject PlateRYWM() {
		return JunOpenGL3dTypicalObjectsPlate.PlateRYWM();
	}

	/**
	 * Typical objects - globe
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Globe() {
		return JunOpenGL3dTypicalObjectsShpere.Globe();
	}

	/**
	 * Typical objects - globe
	 * 
	 * @param degrees double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Globe_(double degrees) {
		return JunOpenGL3dTypicalObjectsShpere.Globe_(degrees);
	}

	/**
	 * Typical objects - globe
	 * 
	 * @param degrees double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Globe_radius_(double degrees, double radius) {
		return JunOpenGL3dTypicalObjectsShpere.Globe_radius_(degrees, radius);
	}

	/**
	 * Typical objects - globe
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param center jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Globe_radius_center_(double degrees, double radius, Jun3dPoint center) {
		return JunOpenGL3dTypicalObjectsShpere.Globe_radius_center_(degrees, radius, center);
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Hemisphere() {
		return JunOpenGL3dTypicalObjectsShpere.Hemisphere();
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Hemisphere_(double degrees) {
		return JunOpenGL3dTypicalObjectsShpere.Hemisphere_(degrees);
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Hemisphere_redius_(double degrees, double radius) {
		return JunOpenGL3dTypicalObjectsShpere.Hemisphere_redius_(degrees, radius);
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param center jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Hemisphere_redius_center_(double degrees, double radius, Jun3dPoint center) {
		return JunOpenGL3dTypicalObjectsShpere.Hemisphere_redius_center_(degrees, radius, center);
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Sphere() {
		return JunOpenGL3dTypicalObjectsShpere.Sphere();
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Sphere_(double degrees) {
		return JunOpenGL3dTypicalObjectsShpere.Sphere_(degrees);
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @param radius double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Sphere_radius_(double degrees, double radius) {
		return JunOpenGL3dTypicalObjectsShpere.Sphere_radius_(degrees, radius);
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param center jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Sphere_radius_center_(double degrees, double radius, Jun3dPoint center) {
		return JunOpenGL3dTypicalObjectsShpere.Sphere_radius_center_(degrees, radius, center);
	}

	/**
	 * Typical objects - sphere
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param longitude double
	 * @param latitude double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects sphere
	 */
	public static JunOpenGL3dObject Sphere_radius_longitude_latitude_(double degrees, double radius, double longitude, double latitude) {
		return JunOpenGL3dTypicalObjectsShpere.Sphere_radius_longitude_latitude_(degrees, radius, longitude, latitude);
	}

	/**
	 * Answer the array which includes a collection of points and a sphere.
	 * 
	 * @param degrees double
	 * @param radius double
	 * @param longitude double
	 * @param latitude double
	 * @return java.lang.Object[]
	 * @category Typical objects sphere
	 */
	public static Object[] XyPointsAndSphere_radius_longitude_latitude_(double degrees, double radius, double longitude, double latitude) {
		return JunOpenGL3dTypicalObjectsShpere.XyPointsAndSphere_radius_longitude_latitude_(degrees, radius, longitude, latitude);
	}

	/**
	 * Typical objects - spring
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject Spring() {
		return JunOpenGL3dTypicalObjectsSpring.Spring();
	}

	/**
	 * Typical objects - spring
	 * 
	 * @param degree int
	 * @param radius double
	 * @param height height
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject SpringBy_radius_height_(int degree, double radius, int height) {
		return JunOpenGL3dTypicalObjectsSpring.SpringBy_radius_height_(degree, radius, height);
	}

	/**
	 * Typical objects - spring
	 * 
	 * @param degree int
	 * @param radius double
	 * @param height height
	 * @param repeat int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject SpringBy_radius_height_repeat_(int degree, double radius, int height, int repeat) {
		return JunOpenGL3dTypicalObjectsSpring.SpringBy_radius_height_repeat_(degree, radius, height, repeat);
	}

	/**
	 * Typical objects - spring
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param widthFactor double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject SpringFrom_to_width_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double widthFactor) {
		return JunOpenGL3dTypicalObjectsSpring.SpringFrom_to_width_(fromPoint, fromPoint, widthFactor);
	}

	/**
	 * Typical objects - spring
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param widthFactor double
	 * @param howMany int
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject SpringFrom_to_width_repeat_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double widthFactor, int howMany) {
		return JunOpenGL3dTypicalObjectsSpring.SpringFrom_to_width_repeat_(fromPoint, fromPoint, widthFactor, howMany);
	}

	/**
	 * Typical objects - spring
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects spring
	 */
	public static JunOpenGL3dObject XUnitSpring() {
		return JunOpenGL3dTypicalObjectsSpring.XUnitSpring();
	}

	/**
	 * Typical objects misc - characterN
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject CharacterN() {
		return JunOpenGL3dTypicalObjectsText.CharacterN();
	}

	/**
	 * Typical objects - Text
	 * 
	 * @param aComposedText jp.co.sra.smalltalk.StComposedText
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text_(StComposedText aComposedText) {
		return JunOpenGL3dTypicalObjectsText.Text_(aComposedText);
	}

	/**
	 * Typical objects - Text
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text_(String aString) {
		return JunOpenGL3dTypicalObjectsText.Text_(aString);
	}

	/**
	 * Typical objects - Text
	 * 
	 * @param aString java.lang.String
	 * @param aFont java.awt.Font
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text_font_(String aString, Font aFont) {
		return JunOpenGL3dTypicalObjectsText.Text_font_(aString, aFont);
	}

	/**
	 * Typical objects - 2D Text
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text2d_(String aString) {
		return JunOpenGL3dTypicalObjectsText.Text2d_(aString);
	}

	/**
	 * Typical objects - 2D Text
	 * 
	 * @param aString java.lang.String
	 * @param aNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text2d_weight_(String aString, double aNumber) {
		return JunOpenGL3dTypicalObjectsText.Text2d_weight_(aString, aNumber);
	}

	/**
	 * Typical objects - 2D Text
	 * 
	 * @param aString java.lang.String
	 * @param aNumber double
	 * @param aFont java.awt.Font
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text2d_weight_font_(String aString, double aNumber, Font aFont) {
		return JunOpenGL3dTypicalObjectsText.Text2d_weight_font_(aString, aNumber, aFont);
	}

	/**
	 * Typical objects - 2D Text
	 * 
	 * @param aComposedText jp.co.sra.smalltalk.StComposedText
	 * @param aNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text2d_weight_(StComposedText aComposedText, double aNumber) {
		return JunOpenGL3dTypicalObjectsText.Text2d_weight_(aComposedText, aNumber);
	}

	/**
	 * Typical objects - 3D Text
	 * 
	 * @param aString java.lang.String
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text3d_(String aString) {
		return JunOpenGL3dTypicalObjectsText.Text3d_(aString);
	}

	/**
	 * Typical objects - 3D Text
	 * 
	 * @param aString java.lang.String
	 * @param aNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text3d_weight_(String aString, double aNumber) {
		return JunOpenGL3dTypicalObjectsText.Text3d_weight_(aString, aNumber);
	}

	/**
	 * Typical objects - 3D Text
	 * 
	 * @param aString java.lang.String
	 * @param aNumber double
	 * @param aFont java.awt.Font
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text3d_weight_font_(String aString, double aNumber, Font aFont) {
		return JunOpenGL3dTypicalObjectsText.Text3d_weight_font_(aString, aNumber, aFont);
	}

	/**
	 * Typical objects - 3D Text
	 * 
	 * @param aComposedText jp.co.sra.smalltalk.StComposedText
	 * @param aNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects text
	 */
	public static JunOpenGL3dObject Text3d_weight_(StComposedText aComposedText, double aNumber) {
		return JunOpenGL3dTypicalObjectsText.Text3d_weight_(aComposedText, aNumber);
	}

	/**
	 * Typical object - torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Typical objects torus
	 */
	public static JunOpenGL3dObject Torus() {
		return JunOpenGL3dTypicalObjectsTorus.Torus();
	}

	/**
	 * Typical object - torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param torusRadius double
	 * @param torusDivision int
	 * @param sectionRadius double
	 * @param sectionDivision int
	 * @category Typical objects torus
	 */
	public static JunOpenGL3dObject Torus_divisions_radius_divisions_(double torusRadius, int torusDivision, double sectionRadius, int sectionDivision) {
		return JunOpenGL3dTypicalObjectsTorus.Torus_divisions_radius_divisions_(torusRadius, torusDivision, sectionRadius, sectionDivision);
	}

	/**
	 * Typical object - torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param torusRadius int
	 * @param sectionRadius double
	 * @category Typical objects torus
	 */
	public static JunOpenGL3dObject Torus_radius_(int torusRadius, double sectionRadius) {
		return JunOpenGL3dTypicalObjectsTorus.Torus_radius_(torusRadius, sectionRadius);
	}

	/**
	 * Typical object - torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param torusRadius double
	 * @param torusDivision int
	 * @param tubeRadius double
	 * @param tubeDivision int
	 * @throws java.lang.IllegalArgumentException
	 * @category Typical objects torus
	 */
	public static JunOpenGL3dObject TorusRadius_divisions_tubeRadius_divisions_(double torusRadius, int torusDivision, double tubeRadius, int tubeDivision) {
		return JunOpenGL3dTypicalObjectsTorus.TorusRadius_divisions_tubeRadius_divisions_(torusRadius, torusDivision, tubeRadius, tubeDivision);
	}

	/**
	 * Typical object - torus
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param torusRadius double
	 * @param tubeRadius double
	 * @category Typical objects torus
	 */
	public static JunOpenGL3dObject TorusRadius_tubeRadius_(double torusRadius, double tubeRadius) {
		return JunOpenGL3dTypicalObjectsTorus.TorusRadius_tubeRadius_(torusRadius, tubeRadius);
	}

	/**
	 * Answer the object to expanded size
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param heightFactor double
	 * @param depthFactor double
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Utilities
	 */
	public static JunOpenGL3dObject From_to_height_depth_with_(Jun3dPoint fromPoint, Jun3dPoint toPoint, double heightFactor, double depthFactor, JunOpenGL3dObject a3dObject) {
		return JunOpenGL3dTypicalObjects.From_to_height_depth_with_(fromPoint, toPoint, heightFactor, depthFactor, a3dObject);
	}

	/**
	 * Answer the object to expanded size
	 * 
	 * @param fromPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param toPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param a3dObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category Utilities
	 */
	public static JunOpenGL3dObject From_to_with_(Jun3dPoint fromPoint, Jun3dPoint toPoint, JunOpenGL3dObject a3dObject) {
		return JunOpenGL3dTypicalObjects.From_to_with_(fromPoint, toPoint, a3dObject);
	}

	/**
	 * Typical object - rotation
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @param arrayOfPoints jp.co.sra.jun.geometry.basic.Jun2dPoint[]
	 * @param divisionNumber int
	 * @category Utilities
	 */
	public static JunOpenGL3dObject Rotate_divisions_(Jun2dPoint[] arrayOfPoints, int divisionNumber) {
		return JunOpenGL3dTypicalObjects.Rotate_divisions_(arrayOfPoints, divisionNumber);
	}

	/**
	 * Answer a Color.
	 * 
	 * @return java.awt.Color
	 * @category Utilities
	 */
	public static Color SampleColor() {
		Vector symbols = StColorValue.ConstantNames();
		StSymbol symbol = (StSymbol) symbols.elementAt((int) Math.round(Math.random() * (symbols.size() - 1)));
		return StColorValue._GetColorByName_(symbol.toString());
	}

	/**
	 * Show the object with its normal vectors.
	 * 
	 * @param anObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category Utilities
	 */
	public static JunOpenGLDisplayModel ShowWithNormalVectors_(JunOpenGL3dObject anObject) {
		final JunOpenGL3dCompoundObject objectWithNormalVectors = new JunOpenGL3dCompoundObject();
		objectWithNormalVectors.add_(anObject);

		anObject.polygonsDo_(new StBlockClosure() {
			public Object value_(Object object) {
				JunOpenGL3dPolygon polygon = (JunOpenGL3dPolygon) object;
				for (int i = 0; i < polygon.numberOfVertexes(); i++) {
					if (i < polygon.normalVectors().length) {
						Jun3dPoint vertex = polygon.vertexAt(i);
						JunOpenGL3dPolyline line = new JunOpenGL3dPolyline(new Jun3dPoint[] { vertex, vertex.plus_(polygon.normalVectors()[i]) });
						objectWithNormalVectors.add_(line);
					}
				}
				return null;
			}
		});

		return objectWithNormalVectors.show();
	}

	/**
	 * Answer a unique id string.
	 * 
	 * @return java.lang.String
	 * @category Utilities
	 */
	public static String UniqueId() {
		long currentClock = System.currentTimeMillis();
		if (currentClock == IdClock) {
			IdNumber = IdNumber + 1;
		} else {
			IdClock = currentClock;
			IdNumber = 0;
		}
		return "id" + new Long(IdClock).toString() + new Long(IdNumber).toString();
	}

	/**
	 * Create a new instance of JunOpenGL3dObject.
	 * 
	 * @category Instance creation
	 */
	public JunOpenGL3dObject() {
		super();
	}

	/**
	 * Create a new instance of JunOpenGL3dObject and initialize it with the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	protected JunOpenGL3dObject(JunLispList aList) {
		this();
		this.fromLispList(aList);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();

		name = null;
		paint = null;
		alpha = Float.NaN;
		bounds = null;
	}

	/**
	 * Answer the alpha number of this JunOpenGL3dObject.
	 * 
	 * @return float
	 * @category accessing
	 */
	public float alpha() {
		if (!this.hasAlpha()) {
			return this.defaultAlpha();
		}

		return alpha;
	}

	/**
	 * Set the alpha number of this JunOpenGL3dObject.
	 * 
	 * @param aNumber float
	 * @category accessing
	 */
	public void alpha_(float aNumber) {
		alpha = aNumber;
	}

	/**
	 * Answer the area of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double area() {
		double area = 0;
		Jun3dTriangle[] triangles = this.asTriangles();
		for (int i = 0; i < triangles.length; i++) {
			area += triangles[i].area();
		}
		return area;
	}

	/**
	 * Set the specified halftone scale as 0.5.
	 * 
	 * @category accessing
	 */
	public void halftone() {
		this.halftone_(0.5);
	}

	/**
	 * Set the specified halftone scale.
	 * 
	 * @param halftoneScale double
	 * @category accessing
	 */
	public void halftone_(double halftoneScale) {
		// do nothing
	}

	/**
	 * Answer my legal name.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String legalName() {
		StringWriter writer = new StringWriter();
		String name = this.name();
		if (Character.isLetter(name.charAt(0)) == false) {
			writer.write("id");
		}
		for (int index = 0; index < name.length(); index++) {
			char character = name.charAt(index);
			if (Character.isLetterOrDigit(character)) {
				writer.write(character);
			} else {
				writer.write("_");
			}
		}
		return writer.toString();
	}

	/**
	 * Answer the name of this JunOpenGL3dObject.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String name() {
		if (name == null) {
			return this.defaultName();
		}

		return name;
	}

	/**
	 * Set name of this JunOpenGL3dObject.
	 * 
	 * @param aString java.lang.String
	 * @category accessing
	 */
	public void name_(String aString) {
		name = aString;
	}

	/**
	 * Answer the color of this JunOpenGL3dObject.
	 * 
	 * @return java.awt.Color
	 * @category accessing
	 */
	public Color paint() {
		if (paint == null) {
			return this.defaultPaint();
		}

		return paint;
	}

	/**
	 * Set the color of this JunOpenGL3dObject.
	 * 
	 * @param aColor java.awt.Color
	 * @category accessing
	 */
	public void paint_(Color aColor) {
		paint = aColor;
	}

	/**
	 * Set the alpha number of this JunOpenGL3dObject.
	 * 
	 * @param aColorValue java.awt.Color
	 * @param aNumber float
	 * @category accessing
	 */
	public void paint_alpha_(Color aColorValue, float aNumber) {
		this.paint_(aColorValue);
		this.alpha_(aNumber);
	}

	/**
	 * Answer my current smoothing angle.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunAngle
	 * @category accessing
	 */
	public JunAngle smoothingAngle() {
		return null;
	}

	/**
	 * Answer the stipple of the receiver. Does not have a stipple as a default.
	 * 
	 * @return jp.co.sra.jun.opengl.texture.JunOpenGLStipple
	 * @category accessing
	 */
	public JunOpenGLStipple stipple() {
		return null;
	}

	/**
	 * Set the stipple of the receiver. Do nothing as a default.
	 * 
	 * @param aStipple jp.co.sra.jun.opengl.texture.JunOpenGLStipple
	 * @category accessing
	 */
	public void stipple_(JunOpenGLStipple aStipple) {
	}

	/**
	 * Answer the texture of the receiver. Does not have a texture as a default.
	 * 
	 * @return jp.co.sra.jun.opengl.texture.JunOpenGLTexture
	 * @category accessing
	 */
	public JunOpenGLTexture texture() {
		return null;
	}

	/**
	 * Set the texture of the receiver.
	 * Do some initialization for subclasses.
	 * 
	 * @param aTexture jp.co.sra.jun.opengl.texture.JunOpenGLTexture
	 * @category accessing
	 */
	public void texture_(JunOpenGLTexture aTexture) {
		if (aTexture != null) {
			aTexture.object_(this);

			if (this.hasColor() == false) {
				this.paint_(Color.white);
			}
		}
	}

	/**
	 * Answer the bounding box of the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dBoundingBox
	 * @category bounds accessing
	 */
	public Jun3dBoundingBox boundingBox() {
		if (bounds == null) {
			bounds = this.preferredBoundingBox();
		}

		return bounds;
	}

	/**
	 * Answer my center point of the bounding box.
	 *
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category bounds accessing
	 */
	public Jun3dPoint center() {
		return this.boundingBox().center();
	}

	/**
	 * Answer my corner point of the bounding box.
	 *
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category bounds accessing
	 */
	public Jun3dPoint corner() {
		return this.boundingBox().corner();
	}

	/**
	 * Answer my depth of the bounding box.
	 *
	 * @return double
	 * @category bounds accessing
	 */
	public double depth() {
		return this.boundingBox().depth();
	}

	/**
	 * Answer my extent size of the bounding box.
	 *
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category bounds accessing
	 */
	public Jun3dPoint extent() {
		return this.boundingBox().extent();
	}

	/**
	 * Answer my height of the bounding box.
	 *
	 * @return double
	 * @category bounds accessing
	 */
	public double height() {
		return this.boundingBox().height();
	}

	/**
	 * Answer my origin point of the bounding box.
	 *
	 * @return jp.co.sra.jun.geometory.basic.Jun3dPoint
	 * @category bounds accessing
	 */
	public Jun3dPoint origin() {
		return this.boundingBox().origin();
	}

	/**
	 * Answer my width of the bounding box.
	 *
	 * @return double
	 * @category bounds accessing
	 */
	public double width() {
		return this.boundingBox().width();
	}

	/**
	 * Answer the preferred bounding box of the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dBoundingBox
	 * @category bounds accessing
	 */
	protected Jun3dBoundingBox preferredBoundingBox() {
		final StValueHolder minX = new StValueHolder(Double.POSITIVE_INFINITY);
		final StValueHolder minY = new StValueHolder(Double.POSITIVE_INFINITY);
		final StValueHolder minZ = new StValueHolder(Double.POSITIVE_INFINITY);
		final StValueHolder maxX = new StValueHolder(Double.NEGATIVE_INFINITY);
		final StValueHolder maxY = new StValueHolder(Double.NEGATIVE_INFINITY);
		final StValueHolder maxZ = new StValueHolder(Double.NEGATIVE_INFINITY);
		this.pointsDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				Jun3dPoint aPoint = (Jun3dPoint) anObject;
				minX.value_(Math.min(minX._doubleValue(), aPoint.x()));
				minY.value_(Math.min(minY._doubleValue(), aPoint.y()));
				minZ.value_(Math.min(minZ._doubleValue(), aPoint.z()));
				maxX.value_(Math.max(maxX._doubleValue(), aPoint.x()));
				maxY.value_(Math.max(maxY._doubleValue(), aPoint.y()));
				maxZ.value_(Math.max(maxZ._doubleValue(), aPoint.z()));
				return null;
			}
		});
		if (minX._doubleValue() == Double.POSITIVE_INFINITY) {
			minX.value_(0);
		}
		if (minY._doubleValue() == Double.POSITIVE_INFINITY) {
			minY.value_(0);
		}
		if (minZ._doubleValue() == Double.POSITIVE_INFINITY) {
			minZ.value_(0);
		}
		if (maxX._doubleValue() == Double.NEGATIVE_INFINITY) {
			maxX.value_(0);
		}
		if (maxY._doubleValue() == Double.NEGATIVE_INFINITY) {
			maxY.value_(0);
		}
		if (maxZ._doubleValue() == Double.NEGATIVE_INFINITY) {
			maxZ.value_(0);
		}
		Jun3dPoint originPoint = new Jun3dPoint(minX._doubleValue(), minY._doubleValue(), minZ._doubleValue());
		Jun3dPoint cornerPoint = new Jun3dPoint(maxX._doubleValue(), maxY._doubleValue(), maxZ._doubleValue());
		return Jun3dBoundingBox.Origin_corner_(originPoint, cornerPoint);
	}

	/**
	 * Establish all normal vectors.
	 * 
	 * @category vector accessing
	 */
	public void establishAllNormalVectors() {
		this.establishAllNormalVectorsWithSmoothingAngle_(this.defaultSmoothingAngle());
	}

	/**
	 * Establish all normal vectors with the specified smoothing angle.
	 * 
	 * @param anAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @category vector accessing
	 */
	public void establishAllNormalVectorsWithSmoothingAngle_(JunAngle anAngle) {
		// do nothing
	}

	/**
	 * Flush all alphas.
	 * 
	 * @category flushing
	 */
	public abstract void flushAllAlphas();

	/**
	 * Flush all alphas.
	 * 
	 * @deprecated since Jun499, renamed to flushAllAlphas()
	 * @category flushing
	 */
	public void flushAllAlpha() {
		this.flushAllAlphas();
	}

	/**
	 * Flush all bounds.
	 * 
	 * @category flushing
	 */
	public abstract void flushAllBounds();

	/**
	 * Flush all colors.
	 * 
	 * @category flushing
	 */
	public abstract void flushAllColors();

	/**
	 * Flush all names.
	 * 
	 * @category flushing
	 */
	public abstract void flushAllNames();

	/**
	 * Flush all names.
	 * 
	 * @deprecated since Jun499, renamed to flushAllNames()
	 * @category flushing
	 */
	public void flushAllName() {
		this.flushAllNames();
	}

	/**
	 * Flush all normal vectors.
	 * 
	 * @category flushing
	 */
	public abstract void flushAllNormalVectors();

	/**
	 * Flush all paints.
	 * 
	 * @category flushing
	 */
	public abstract void flushAllPaints();

	/**
	 * Flush all paints.
	 * 
	 * @deprecated since Jun499, renamed to flushAllPaints()
	 * @category flushing
	 */
	public void flushAllPaint() {
		this.flushAllPaints();
	}

	/**
	 * Flush my alpha.
	 * 
	 * @category flushing
	 */
	public void flushAlpha() {
		alpha = Float.NaN;
	}

	/**
	 * Flush my bounds.
	 * 
	 * @category flushing
	 */
	public void flushBounds() {
		bounds = null;
	}

	/**
	 * Flush my colors.
	 * 
	 * @category flushing
	 */
	public void flushColors() {
		// do nothing
	}

	/**
	 * Flush my name.
	 * 
	 * @category flushing
	 */
	public void flushName() {
		name = null;
	}

	/**
	 * Flush my normal vectors.
	 * 
	 * @category flushing
	 */
	public void flushNormalVectors() {
		// do nothing
	}

	/**
	 * Flush my paint.
	 * 
	 * @category flushing
	 */
	public void flushPaint() {
		paint = null;
	}

	/**
	 * Answer true if the alpha is specified, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasAlpha() {
		return !Float.isNaN(alpha);
	}

	/**
	 * Answer true if the color is specified, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasColor() {
		return (this.hasPaint() || this.hasAlpha());
	}

	/**
	 * Answer true if the colors are specified, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasColors() {
		return false;
	}

	/**
	 * Answer true if the receiver has a name, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasName() {
		return (name != null);
	}

	/**
	 * Answer true if the normal vectors are specified, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasNormalVectors() {
		return false;
	}

	/**
	 * Answer true if the paint is specified, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasPaint() {
		return (paint != null);
	}

	/**
	 * Answer true if this JunOpenGL3dObject has a stipple, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasStipple() {
		return false;
	}

	/**
	 * Answer true if this JunOpenGL3dObject has a texture, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasTexture() {
		return false;
	}

	/**
	 * Answer true if I have a transparency effect, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean hasTransparency() {
		return this.hasAlpha() && (this.alpha() < 1.0);
	}

	/**
	 * Answer true if the receiver is a compound object, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isCompound() {
		return false;
	}

	/**
	 * Answer true if the receiver is a kind of JunOpenGL3dPolygon, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isPolygon() {
		return false;
	}

	/**
	 * Answer true if the receiver is a kind of JunOpenGL3dPolyline, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isPolyline() {
		return false;
	}

	/**
	 * Answer true if the receiver is a kind of JunOpenGL3dPrimitiveObject, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isPrimitive() {
		return false;
	}

	/**
	 * Answer true if the receiver is a kind of JunOpenGL3dTransformedObject, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isTransformedObject() {
		return false;
	}

	/**
	 * Answer true if the receiver is a kind of JunOpenGL3dVertexesObject, otherwise false.
	 * 
	 * @return boolean
	 * @category testing
	 */
	public boolean isVertexesObject() {
		return false;
	}

	/**
	 * Render the OpenGL object on a rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.opengl.support.JunRenderingContext
	 * @category rendering
	 */
	public abstract void renderOn_(JunOpenGLRenderingContext aRenderingContext);

	/**
	 * Render the OpenGL object on a rendering context.
	 * 
	 * @param aRenderingContext jp.co.sra.jun.vrml.support.JunVrmlRenderingContext
	 * @category rendering
	 */
	public void renderOn_(JunVrmlRenderingContext aRenderingContext) {
		aRenderingContext.displayObject_(this);
	}

	/**
	 * Enumerate every geometries and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating
	 */
	public abstract Object geometriesDo_(StBlockClosure aBlock);

	/**
	 * Enumerate every objects and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating
	 */
	public abstract Object objectsDo_(StBlockClosure aBlock);

	/**
	 * Enumerate all of the primitive objects and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category enumerating
	 */
	public abstract Object primitivesDo_(StBlockClosure aBlock);

	/**
	 * Enumerate every points and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public abstract void pointsDo_(StBlockClosure aBlock);

	/**
	 * Enumerate every polygons and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public abstract void polygonsDo_(StBlockClosure aBlock);

	/**
	 * Enumerate every polylines and evaluate the Block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public abstract void polylinesDo_(StBlockClosure aBlock);

	/**
	 * Answer the new JunOpen3dObject transformed with aTransformation.
	 * 
	 * @param aTransformation jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category transforming
	 */
	public abstract JunOpenGL3dObject transform_(Jun3dTransformation aTransformation);

	/**
	 * Answer the transformation of the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category transforming
	 */
	public Jun3dTransformation transformation() {
		return Jun3dTransformation.Unity();
	}

	/**
	 * Rotate the receiver by the specified angle.
	 * 
	 * @param anAngle jp.co.sra.jun.geometry.basic.JunAngle
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category transforming
	 */
	public JunOpenGL3dObject rotatedBy_(JunAngle anAngle) {
		return this.transform_(Jun3dTransformation.Rotate_(anAngle));
	}

	/**
	 * Answer the copy of the receiver scaled by a specified size.
	 * 
	 * @param aNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category transforming
	 */
	public JunOpenGL3dObject scaledBy_(double aNumber) {
		return this.transform_(Jun3dTransformation.Scale_(aNumber));
	}

	/**
	 * Answer the copy of the receiver scaled by a specified size.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category transforming
	 */
	public JunOpenGL3dObject scaledBy_(Jun3dPoint aPoint) {
		return this.transform_(Jun3dTransformation.Scale_(aPoint));
	}

	/**
	 * Answer the copy of the receiver translated by a specified size.
	 * 
	 * @param aNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category transforming
	 */
	public JunOpenGL3dObject translatedBy_(double aNumber) {
		return this.transform_(Jun3dTransformation.Translate_(aNumber));
	}

	/**
	 * Answer the copy of the receiver translated by a specified size.
	 * 
	 * @param aPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category transforming
	 */
	public JunOpenGL3dObject translatedBy_(Jun3dPoint aPoint) {
		return this.transform_(Jun3dTransformation.Translate_(aPoint));
	}

	/**
	 * Convert the receiver to JunOpenGL3dCompoundObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category converting
	 */
	public abstract JunOpenGL3dCompoundObject asCompoundObject();

	/**
	 * Convert the receiver to an image as StImage.
	 * 
	 * @return jp.co.sra.smalltalk.StImage
	 * @category converting
	 */
	public StImage asImage() {
		Image anImage = this.toImage();
		return (anImage == null) ? null : new StImage(anImage);
	}

	/**
	 * Convert the receiver to an image as Image.
	 * 
	 * @return java.awt.Image
	 * @category converting
	 */
	public Image toImage() {
		return this.toImageExtent_(JunOpenGL3dModel.DefaultImageExtent);
	}

	/**
	 * Convert the receiver to an image with the specified extent.
	 * 
	 * @param imageExtent java.awt.Dimension
	 * @return java.awt.Image
	 * @category converting
	 */
	public Image toImageExtent_(Dimension imageExtent) {
		JunOpenGL3dModel displayModel = new JunOpenGL3dModel(this);
		return this.toImageExtent_eyePoint_sightPoint_upVector_(imageExtent, displayModel.defaultEyePoint(), displayModel.defaultSightPoint(), displayModel.defaultUpVector());
	}

	/**
	 * Convert the receiver to an image with the specified extent and the projection.
	 *  
	 * @param imageExtent java.awt.Dimension
	 * @param eyePoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param sightPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param upVector jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return java.awt.Image
	 * @category converting
	 */
	public Image toImageExtent_eyePoint_sightPoint_upVector_(Dimension imageExtent, Jun3dPoint eyePoint, Jun3dPoint sightPoint, Jun3dPoint upVector) {
		JunOpenGL3dModel displayModel = new JunOpenGL3dModel(this);
		displayModel.defaultEyePoint_(eyePoint);
		displayModel.defaultSightPoint_(sightPoint);
		displayModel.defaultUpVector_(upVector);
		displayModel.resetView();
		return displayModel.toImageExtent_(imageExtent);
	}

	/**
	 * Convert the receiver to a JunOpenGL3dObject.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category converting
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		return this;
	}

	/**
	 * Convert the receiver to an array of Jun3dPoint.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunPoint3d[]
	 * @category converting
	 */
	public Jun3dPoint[] asPointArray() {
		final ArrayList points = new ArrayList();
		this.pointsDo_(new StBlockClosure() {
			public Object value_(Object point) {
				points.add(point);
				return null;
			}
		});
		return (Jun3dPoint[]) points.toArray(new Jun3dPoint[points.size()]);
	}

	/**
	 * Convert the receiver to a set of Jun3dPoint.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunPoint3d[]
	 * @category converting
	 */
	public Jun3dPoint[] asPointSet() {
		final ArrayList points = new ArrayList();
		this.pointsDo_(new StBlockClosure() {
			public Object value_(Object point) {
				if (points.contains(point) == false) {
					points.add(point);
				}
				return null;
			}
		});
		return (Jun3dPoint[]) points.toArray(new Jun3dPoint[points.size()]);
	}

	/**
	 * Convert the receiver as an array of JunGeometry.
	 * 
	 * @return jp.co.sra.jun.geometry.abstracts.JunGeometry[]
	 * @category converting
	 */
	public JunGeometry[] asGeometryArray() {
		final ArrayList aList = new ArrayList();
		this.geometriesDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				aList.add(anObject);
				return null;
			}
		});
		return (JunGeometry[]) aList.toArray(new JunGeometry[aList.size()]);
	}

	/**
	 * Convert the receiver as a triangle.
	 * 
	 * @return jp.co.sra.jun.geometry.surfaces.Jun3dTriangle
	 * @category converting
	 */
	public Jun3dTriangle asTriangle() {
		Jun3dTriangle[] triangles = this.asTriangles();
		if (triangles.length == 0) {
			return null;
		}
		return triangles[0];
	}

	/**
	 * Convert the receiver as triangles.
	 * 
	 * @return jp.co.sra.jun.geometry.surfaces.Jun3dTriangle[]
	 * @category converting
	 */
	public Jun3dTriangle[] asTriangles() {
		ArrayList aList = new ArrayList();
		JunGeometry[] geometries = this.asGeometryArray();
		for (int i = 0; i < geometries.length; i++) {
			Jun3dTriangle[] triangles = geometries[i].asArrayOf3dTriangles();
			if (triangles != null) {
				for (int j = 0; j < triangles.length; j++) {
					aList.add(triangles[j]);
				}
			}
		}
		return (Jun3dTriangle[]) aList.toArray(new Jun3dTriangle[aList.size()]);
	}

	/**
	 * Answer the average vertex of the receiver.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category converting
	 */
	public Jun3dPoint averageVertex() {
		Jun3dPoint averageVertex = new Jun3dPoint(0, 0, 0);
		Jun3dPoint[] pointArray = this.asPointArray();
		if (pointArray.length > 0) {
			for (int i = 0; i < pointArray.length; i++) {
				averageVertex = averageVertex.plus_(pointArray[i]);
			}
			averageVertex = averageVertex.dividedBy_(pointArray.length);
		}
		return averageVertex;
	}

	/**
	 * Answer the receiver as flatten.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category converting
	 */
	public JunOpenGL3dCompoundObject flatten() {
		final JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
		this.primitivesDo_(new StBlockClosure() {
			public Object value_(Object aPolygon) {
				aBody.add_((JunOpenGL3dObject) aPolygon);
				return null;
			}
		});
		return aBody;
	}

	/**
	 * Answer the receiver as flatten as polygons.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category converting
	 */
	public JunOpenGL3dCompoundObject flattenAsPolygons() {
		final JunOpenGL3dCompoundObject aBody = new JunOpenGL3dCompoundObject();
		this.polygonsDo_(new StBlockClosure() {
			public Object value_(Object aPolygon) {
				aBody.add_((JunOpenGL3dObject) aPolygon);
				return null;
			}
		});
		return aBody;
	}

	/**
	 * Answer the reversed JunOpenGL3dObject of the receiver.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category converting
	 */
	public abstract JunOpenGL3dObject reversed();

	/**
	 * Answer myself and my normal vectors object.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category converting
	 */
	public JunOpenGL3dObject yourselfAndNormalVectorsObject() {
		return this;
	}

	/**
	 * Copy my attributes into the object.
	 * 
	 * @param anObject jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category copying
	 */
	public void _copyInto(JunOpenGL3dObject anObject) {
		if (this.hasName()) {
			anObject.name_(this.name());
		}
		if (this.hasAlpha()) {
			anObject.alpha_(this.alpha());
		}
		if (this.hasPaint()) {
			anObject.paint_(this.paint());
		}
		if (this.hasStipple()) {
			anObject.stipple_(this.stipple());
		}
		if (this.hasTexture()) {
			anObject.texture_(this.texture());
		}
	}

	/**
	 * Utility to show the receiver using JunOpenGLDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel show() {
		return this.showIn_(null);
	}

	/**
	 * Utility to show the receiver using JunOpenGLDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showAt_(Point aPoint) {
		return this.showIn_(new Rectangle(aPoint.x, aPoint.y, 300, 300));
	}

	/**
	 * Utility to show the receiver in the specified area.
	 * 
	 * @param aRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showIn_(Rectangle aRectangle) {
		return this.showEyePoint_sightPoint_upVector_viewFactor_in_(null, null, null, Double.NaN, aRectangle);
	}

	/**
	 * Utility to show the receiver using the specified projection.
	 * 
	 * @param eyePoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showEyePoint_(Jun3dPoint eyePoint) {
		return this.showEyePoint_sightPoint_(eyePoint, null);
	}

	/**
	 * Utility to show the receiver using the specified projection.
	 * 
	 * @param eyePoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param sightPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showEyePoint_sightPoint_(Jun3dPoint eyePoint, Jun3dPoint sightPoint) {
		return this.showEyePoint_sightPoint_upVector_(eyePoint, sightPoint, null);
	}

	/**
	 * Utility to show the receiver using the specified projection.
	 * 
	 * @param eyePoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param sightPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param upVector jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_(Jun3dPoint eyePoint, Jun3dPoint sightPoint, Jun3dPoint upVector) {
		return this.showEyePoint_sightPoint_upVector_viewFactor_(eyePoint, sightPoint, upVector, Double.NaN);
	}

	/**
	 * Utility to show the receiver using the specified projection.
	 * 
	 * @param eyePoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param sightPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param upVector jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param diplayRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_in_(Jun3dPoint eyePoint, Jun3dPoint sightPoint, Jun3dPoint upVector, Rectangle diplayRectangle) {
		return this.showEyePoint_sightPoint_upVector_viewFactor_in_(eyePoint, sightPoint, upVector, Double.NaN, diplayRectangle);
	}

	/**
	 * Utility to show the receiver using the specified projection.
	 * 
	 * @param eyePoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param sightPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param upVector jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param viewFactor double
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_viewFactor_(Jun3dPoint eyePoint, Jun3dPoint sightPoint, Jun3dPoint upVector, double viewFactor) {
		return this.showEyePoint_sightPoint_upVector_viewFactor_in_(eyePoint, sightPoint, upVector, viewFactor, null);
	}

	/**
	 * Utility to show the receiver using the specified projection.
	 * 
	 * @param eyePoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param sightPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param upVector jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param viewFactor double
	 * @param diplayRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_viewFactor_in_(Jun3dPoint eyePoint, Jun3dPoint sightPoint, Jun3dPoint upVector, double viewFactor, Rectangle diplayRectangle) {
		return this.showEyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(eyePoint, sightPoint, upVector, viewFactor, Double.NaN, diplayRectangle);
	}

	/**
	 * Utility to show the receiver using JunOpenGLDisplayModel.
	 * 
	 * @param eyePoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param sightPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param upVector jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param viewFactor double
	 * @param zoomHeight double
	 * @param diplayRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(Jun3dPoint eyePoint, Jun3dPoint sightPoint, Jun3dPoint upVector, double viewFactor, double zoomHeight, Rectangle diplayRectangle) {
		return JunOpenGLDisplayModel.Show_eyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(this, eyePoint, sightPoint, upVector, viewFactor, zoomHeight, diplayRectangle);
	}

	/**
	 * Utility to show the receiver using JunOpenGLDisplayModel.
	 * 
	 * @param eyePoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param sightPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param upVector jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param zoomHeight double
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_zoomHeight_(Jun3dPoint eyePoint, Jun3dPoint sightPoint, Jun3dPoint upVector, double zoomHeight) {
		return this.showEyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(eyePoint, sightPoint, upVector, Double.NaN, zoomHeight, null);
	}

	/**
	 * Utility to show the receiver using JunOpenGLDisplayModel.
	 * 
	 * @param eyePoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param sightPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param upVector jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @param zoomHeight double
	 * @param diplayRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showEyePoint_sightPoint_upVector_zoomHeight_in_(Jun3dPoint eyePoint, Jun3dPoint sightPoint, Jun3dPoint upVector, double zoomHeight, Rectangle diplayRectangle) {
		return this.showEyePoint_sightPoint_upVector_viewFactor_zoomHeight_in_(eyePoint, sightPoint, upVector, Double.NaN, zoomHeight, diplayRectangle);
	}

	/**
	 * Utility to show the receiver with the specified projection.
	 * 
	 * @param aMap java.util.Map
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showProjectionTable_(Map aMap) {
		return this.showProjectionTable_in_(aMap, null);
	}

	/**
	 * Utility to show the receiver with the specified projection in the specified area.
	 * 
	 * @param aMap java.util.Map
	 * @param aRectangle java.awt.Rectangle
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showProjectionTable_in_(Map aMap, Rectangle aRectangle) {
		return JunOpenGLDisplayModel.Show_projectionTable_in_(this, aMap, aRectangle);
	}

	/**
	 * Utility to show the receiver with an axes using JunOpenGLDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showWithAxes() {
		return this.withAxes().show();
	}

	/**
	 * Utility to show the receiver with an axes using JunOpenGLDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showWithAxesIn_(Rectangle aRectangle) {
		return this.withAxes().showIn_(aRectangle);
	}

	/**
	 * Utility to show the receiver with a translated axes using JunOpenGLDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showWithTranslatedAxes() {
		return this.withTranslatedAxes().show();
	}

	/**
	 * Utility to show the receiver with a translated axes using JunOpenGLDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showWithTranslatedAxesIn_(Rectangle aRectangle) {
		return this.withTranslatedAxes().showIn_(aRectangle);
	}

	/**
	 * Utility to show the receiver with a unit axes using JunOpenGLDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showWithUnitAxes() {
		return this.withUnitAxes().show();
	}

	/**
	 * Utility to show the receiver with a unit axes using JunOpenGLDisplayModel.
	 * 
	 * @return jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel
	 * @category viewing
	 */
	public JunOpenGLDisplayModel showWithUnitAxesIn_(Rectangle aRectangle) {
		return this.withUnitAxes().showIn_(aRectangle);
	}

	/**
	 * Answer a compound object with the receiver and an axes.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category viewing
	 */
	public JunOpenGL3dCompoundObject withAxes() {
		Jun3dBoundingBox box = this.boundingBox().merge_(Jun3dPoint.Zero().asBoundingBox());
		JunOpenGL3dObject axes = XyzArrows().scaledBy_(Math.max(Math.max(box.width(), box.height()), box.depth()) * 1.2);
		return new JunOpenGL3dCompoundObject(this, axes);
	}

	/**
	 * Answer a compound object with the receiver and a translated axes.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category viewing
	 */
	public JunOpenGL3dCompoundObject withTranslatedAxes() {
		Jun3dBoundingBox box = this.boundingBox();
		JunOpenGL3dObject axes = XyzArrows().scaledBy_(Math.max(Math.max(box.width(), box.height()), box.depth()) * 0.8).translatedBy_(box.center());
		return new JunOpenGL3dCompoundObject(this, axes);
	}

	/**
	 * Answer a compound object with the receiver and a unit axes.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category viewing
	 */
	public JunOpenGL3dCompoundObject withUnitAxes() {
		return new JunOpenGL3dCompoundObject(this, XyzArrows());
	}

	/**
	 * Answer the default alpha number.
	 * 
	 * @return float
	 * @category defaults
	 */
	public float defaultAlpha() {
		return 1.0f;
	}

	/**
	 * Answer the default line width.
	 * 
	 * @return float
	 * @category defaults
	 */
	public float defaultLineWidth() {
		return 1.0f;
	}

	/**
	 * Answer the default name.
	 * 
	 * @return java.lang.String
	 * @category defaults
	 */
	protected String defaultName() {
		return UniqueId();
	}

	/**
	 * Answer the default paint.
	 * 
	 * @return java.awt.Color
	 * @category defaults
	 */
	public Color defaultPaint() {
		return DefaultPaint();
	}

	/**
	 * Answer the default point.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @category defaults
	 */
	public Jun3dPoint defaultPoint() {
		return new Jun3dPoint(0, 0, 0);
	}

	/**
	 * Answer the default size.
	 * 
	 * @return float
	 * @category defaults
	 */
	public float defaultSize() {
		return 1.0f;
	}

	/**
	 * Answer the default smoothing angle.
	 * 
	 * @return jp.co.sra.jun.geometry.basic.JunAngle
	 * @category defaults
	 */
	public JunAngle defaultSmoothingAngle() {
		return JunAngle.FromDeg_(45);
	}

	/**
	 * Answer the default transformation as Jun3dTransformation.
	 * 
	 * @return jp.co.sra.jun.geometry.transformations.Jun3dTransformation
	 * @category defaults
	 */
	public Jun3dTransformation defaultTransformation() {
		return Jun3dTransformation.Unity();
	}

	/**
	 * Answer the number of polygons.
	 * 
	 * @return int
	 * @category utilities
	 */
	public abstract int numberOfPolygons();

	/**
	 * Answer the number of primitives.
	 * 
	 * @return int
	 * @category utilities
	 */
	public abstract int numberOfPrimitives();

	/**
	 * Answer the StSymbol which represents the kind of the receiver.
	 * 
	 * @return jp.co.sra.smalltalk.StSymbol
	 * @category lisp support
	 */
	public StSymbol kindName() {
		return this._className();
	}

	/**
	 * Create an instance of JunLispCons.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	public JunLispCons lispCons() {
		return (JunLispCons) JunLispList.Cell();
	}

	/**
	 * Create an instance of JunLispNil.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispNil
	 * @category lisp support
	 */
	public JunLispNil lispNil() {
		return (JunLispNil) JunLispList.NullList();
	}

	/**
	 * Convert the receiver as a lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	public JunLispCons toLispList() {
		JunLispCons list = this.lispCons();
		list.head_(this.kindName());
		if (this.hasName()) {
			list.add_(this.nameToLispList());
		}
		if (this.hasColor()) {
			list.add_(this.colorToLispList());
		}
		return list;
	}

	/**
	 * Convert the receiver's name as a JunLispList.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	protected JunLispList nameToLispList() {
		if (!this.hasName()) {
			return this.lispNil();
		}

		JunLispCons list = this.lispCons();
		list.head_($("name"));
		list.tail_(this.name());
		return list;
	}

	/**
	 * Convert the receiver's color as a JunLispList.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	protected JunLispList colorToLispList() {
		JunLispCons list = this.lispCons();
		list.head_($("color"));

		Color colorValue = this.paint();
		list.add_(new Float(colorValue.getRed() / 255f));
		list.add_(new Float(colorValue.getGreen() / 255f));
		list.add_(new Float(colorValue.getBlue() / 255f));
		if (this.hasAlpha()) {
			list.add_(new Float(this.alpha()));
		}
		return list;
	}

	/**
	 * Popup a window which displays the Lisp List of the receiver.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	public JunLispList showLispList() {
		return this.showLispList_(this.toLispList());
	}

	/**
	 * Popup a window which displays the Lisp List.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @return jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	public JunLispList showLispList_(JunLispList aList) {
		return ShowLispList_(aList);
	}

	/**
	 * Write the receiver's list representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws IOException if failed.
	 * @category lisp support
	 */
	public void saveOn_(Writer aWriter) throws IOException {
		JunLispList aList;
		JunCursors cursor = new JunCursors(new Cursor(Cursor.WAIT_CURSOR));
		try {
			cursor._show();
			aList = this.toLispList();
		} finally {
			cursor._restore();
		}
		aList.saveOn_(aWriter);
	}

	/**
	 * Get my attributes from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	public void fromLispList(JunLispList aList) {
		this.nameFromLispList(aList);
		this.colorFromLispList(aList);
	}

	/**
	 * Get my name from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	protected void nameFromLispList(JunLispList aList) {
		JunLispCons list = (JunLispCons) aList.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object anObject) {
				return new Boolean(anObject instanceof JunLispCons && (((JunLispCons) anObject).head() == $("name")));
			}
		}, new StBlockClosure());
		if (list == null) {
			return;
		}

		this.name_((String) ((JunLispCons) list).tail());
	}

	/**
	 * Get my color from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	protected void colorFromLispList(JunLispList aList) {
		JunLispCons list = (JunLispCons) aList.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object anObject) {
				return new Boolean(anObject instanceof JunLispCons && (((JunLispCons) anObject).head() == $("color")));
			}
		}, new StBlockClosure());
		if (list == null) {
			return;
		}

		list = (JunLispCons) list.tail();
		Number red = (Number) list.nth_(1);
		if (red instanceof Integer) {
			red = new Float(Math.max(0, Math.min(red.floatValue() / 255, 1)));
		}
		Number green = (Number) list.nth_(2);
		if (green instanceof Integer) {
			green = new Float(Math.max(0, Math.min(green.floatValue() / 255, 1)));
		}
		Number blue = (Number) list.nth_(3);
		if (blue instanceof Integer) {
			blue = new Float(Math.max(0, Math.min(blue.floatValue() / 255, 1)));
		}
		this.paint_(new Color(red.floatValue(), green.floatValue(), blue.floatValue()));

		if (list.length() >= 4) {
			Number alpha = (Number) list.nth_(4);
			if (alpha instanceof Integer) {
				alpha = new Float(Math.max(0, Math.min(alpha.floatValue() / 255, 1)));
			}
			this.alpha_(alpha.floatValue());
		}
	}

	/**
	 * Get my transformation from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	protected void transformationFromLispList(JunLispList aList) {
		Jun3dTransformation transformation = TransformationFromLispList_(aList);
		if (transformation != null) {
			this.transform_(transformation);
		}
	}

	/**
	 * Write the VRML string of the receiver on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @category vrml support
	 */
	public void vrmlOn_(Writer aWriter) {
		PrintWriter pw = (aWriter instanceof PrintWriter) ? (PrintWriter) aWriter : new PrintWriter(aWriter);
		try {
			this.vrml20On_(pw, "");
		} finally {
			pw.flush();
		}
	}

	/**
	 * Answer the VRML string of the receiver.
	 * 
	 * @return java.lang.String
	 * @category vrml support
	 */
	public String vrmlString() {
		return this.vrml20String();
	}

	/**
	 * Write the VRML1.0 string of the receiver on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @category vrml support
	 */
	public abstract void vrml10On_(Writer aWriter);

	/**
	 * Answer the VRML1.0 string of the receiver.
	 * 
	 * @return java.lang.String
	 * @throws SmalltalkException if failed.
	 * @category vrml support
	 */
	public String vrml10String() {
		StringWriter aWriter = new StringWriter();
		try {
			this.vrml10On_(aWriter);
			aWriter.close();
		} catch (Exception e) {
			new SmalltalkException(e);
		}
		return aWriter.toString();
	}

	/**
	 * Write my appearance as VRML1.0 on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws SmalltalkException if failed.
	 * @category vrml support
	 */
	protected void vrml10ColorOn_(Writer aWriter) {
		if (!this.hasColor()) {
			return;
		}

		try {
			BufferedWriter bw = (aWriter instanceof BufferedWriter) ? (BufferedWriter) aWriter : new BufferedWriter(aWriter);
			bw.write("\t");
			bw.write("Material {");
			bw.newLine();
			bw.write("\t\t");
			bw.write("diffuseColor ");

			Color color = this.paint();
			bw.write(String.valueOf(color.getRed() / 255f));
			bw.write(" ");
			bw.write(String.valueOf(color.getGreen() / 255f));
			bw.write(" ");
			bw.write(String.valueOf(color.getBlue() / 255f));
			bw.newLine();
			bw.write("\t");
			bw.write("} #Material");
			bw.newLine();
			bw.flush();
		} catch (IOException e) {
			throw new SmalltalkException(e);
		}
	}

	/**
	 * Write the VRML2.0 string of the receiver on the writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @category vrml support
	 */
	public void vrml20On_(Writer aWriter) {
		PrintWriter pw = (aWriter instanceof PrintWriter) ? (PrintWriter) aWriter : new PrintWriter(aWriter);
		this.vrml20On_(pw, "");
	}

	/**
	 * Write the VRML2.0 string of the receiver on the writer.
	 * 
	 * @param pw java.io.PrintWriter
	 * @param leader java.lang.String
	 * @category vrml support
	 */
	public void vrml20On_(PrintWriter pw, String leader) {
		this.vrml20ShapeOn_(pw, leader);
	}

	/**
	 * Answer the VRML2.0 string of the receiver.
	 * 
	 * @return java.lang.String
	 * @throws SmalltalkException if failed.
	 * @category vrml support
	 */
	public String vrml20String() {
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		try {
			this.vrml20On_(pw, "");
		} finally {
			pw.flush();
		}
		return sw.toString();
	}

	/**
	 * Write my shape as VRML2.0 on the writer.
	 * 
	 * @param pw java.io.PrintWriter
	 * @param leader java.lang.String
	 * @category vrml support
	 */
	protected void vrml20ShapeOn_(PrintWriter pw, String leader) {
		pw.println(leader + "# " + this.name());
		pw.println(leader + "Shape {");
		this.vrml20AppearanceOn_(pw, leader + INDENT);
		this.vrml20GeometryOn_(pw, leader + INDENT);
		pw.println(leader + "} #Shape");
	}

	/**
	 * Write my appearance as VRML2.0 on the writer.
	 * 
	 * @param pw java.io.PrintWriter
	 * @param leader java.lang.String
	 * @throws SmalltalkException if failed.
	 * @category vrml support
	 */
	protected void vrml20AppearanceOn_(PrintWriter pw, String leader) {
		if ((this.hasColor() == false) && (this.hasTexture() == false)) {
			return;
		}

		pw.println(leader + "appearance Appearance {");

		if (this.hasColor()) {
			this.vrml20MaterialOn_(pw, leader + INDENT);
		}
		if (this.hasTexture()) {
			this.vrml20TextureOn_(pw, leader + INDENT);
		}

		pw.println(leader + "} #Appearance");
	}

	/**
	 * Write my material as VRML2.0 on the writer.
	 * 
	 * @param pw java.io.PrintWriter
	 * @param leader java.lang.String
	 * @category vrml support
	 */
	protected void vrml20MaterialOn_(PrintWriter pw, String leader) {
		pw.println(leader + "material Material {");

		pw.print(leader + INDENT + "diffuseColor ");
		Color color = this.paint();
		pw.print(color.getRed() / 255f);
		pw.print(' ');
		pw.print(color.getGreen() / 255f);
		pw.print(' ');
		pw.print(color.getBlue() / 255f);
		pw.println();

		pw.println(leader + "} #Material");
	}

	/**
	 * Write my texture as VRML2.0 on the writer.
	 * 
	 * @param pw java.io.PrintWriter
	 * @param leader java.lang.String
	 * @category vrml support
	 */
	protected void vrml20TextureOn_(PrintWriter pw, String leader) {
		pw.println(leader + "texture PixelTexture {");

		pw.println(leader + INDENT + "image ");
		this.texture().vrmlSFImageOn_(pw);
		pw.println();
		pw.println(leader + INDENT + "repeatS " + (this.texture().repeat() ? "TRUE" : "FALSE"));
		pw.println(leader + INDENT + "repeatT " + (this.texture().repeat() ? "TRUE" : "FALSE"));

		pw.println(leader + "} #PixelTexture");
	}

	/**
	 * Write my geometry as VRML2.0 to the writer.
	 * 
	 * @param pw java.io.Writer
	 * @param leader java.lang.String
	 * @category vrml support
	 */
	protected void vrml20GeometryOn_(PrintWriter pw, String leader) {
		throw SmalltalkException.SubclassResponsibility();
	}

	/**
	 * Answer the receiver's raw alpha number.
	 * 
	 * @return float
	 * @category private
	 */
	protected float rawAlpha() {
		return alpha;
	}

	/**
	 * Answer the receiver's raw name.
	 * 
	 * @return java.lang.String
	 * @category private
	 */
	protected String rawName() {
		return name;
	}

	/**
	 * Answer the receiver's raw color.
	 * 
	 * @return java.awt.Color
	 * @category private
	 */
	protected Color rawPaint() {
		return paint;
	}
}
