package jp.co.sra.jun.opengl.grapher;

import java.awt.Color;
import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGL3dGrapherTestExamples class
 * 
 *  @author    Hirotsugu Kondo
 *  @created   1998/12/07 (by Hirotsugu Kondo)
 *  @updated   2003/05/15 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun475 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGL3dGrapherTestExamples.java,v 8.10 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGL3dGrapherTestExamples extends JunTestExamples {

	/**
	 * Example: Create a new instance of JunOpenGL3dGrapher and open it.
	 * 
	 * @return boolean
	 */
	public static boolean Example() {
		JunOpenGL3dGrapher grapher = new JunOpenGL3dGrapher();
		grapher.open();

		return true;
	}

	/**
	 * Example1:
	 * 
	 * @return boolean
	 */
	public static boolean Example1() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_(JunOpenGL3dGraphTestExamples._SubclassHierachyLispStringForStream());
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.generateTreeFromLispList_(list);
		graph.arrangeInterval_(new Jun3dPoint(3, 2, 4));
		graph.arrange2();
		graph.nodesDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dNode node = (JunOpenGL3dNode) each;
				JunOpenGLTexture texture = JunOpenGLTexture.TextureForString_foreColor_backColor_(node.entity().toString(), Color.black, node.color());
				node.texture_(texture);

				return null;
			}
		});

		JunOpenGL3dGrapher grapher = new JunOpenGL3dGrapher();
		grapher.displayObject_(graph);
		grapher.open();

		return true;
	}

	/**
	 * Example2: 
	 * 
	 * @return boolean
	 */
	public static boolean Example2() {
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.generateTreeFromLispList_((JunLispCons) JunLispParser.Parse_((JunOpenGL3dGraphTestExamples._SubclassHierachyLispStringForMagnitude())));
		graph.generateTreeFromLispList_((JunLispCons) JunLispParser.Parse_((JunOpenGL3dGraphTestExamples._SubclassHierachyLispStringForCollection())));
		graph.generateTreeFromLispList_((JunLispCons) JunLispParser.Parse_((JunOpenGL3dGraphTestExamples._SubclassHierachyLispStringForStream())));
		graph.generateTreeFromLispList_((JunLispCons) JunLispParser.Parse_((JunOpenGL3dGraphTestExamples._SubclassHierachyLispStringForView())));
		graph.arrangeInterval_(new Jun3dPoint(10, 1, 20));
		graph.arrange();

		Jun3dBoundingBox box = graph.boundingBox();
		final Jun3dPoint origin = (Jun3dPoint) box.origin();
		final double width = box.width();
		final double height = box.height();
		final double depth = box.depth();
		graph.nodesDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dNode node = (JunOpenGL3dNode) each;
				Jun3dPoint point = (Jun3dPoint) node.location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				node.color_(color);

				return null;
			}
		});
		graph.arcsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dArc arc = (JunOpenGL3dArc) each;
				Jun3dPoint point = (Jun3dPoint) arc.to().location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				arc.color_(color);
				arc.crank_(true);

				return null;
			}
		});
		graph.flushDisplayObject();

		JunOpenGL3dGrapher grapher = new JunOpenGL3dGrapher();
		grapher.displayObject_(graph);
		grapher.open();

		return true;
	}

	/**
	 * Example3:
	 * 
	 * @return boolean
	 */
	public static boolean Example3() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_((JunOpenGL3dGraphTestExamples._SubclassHierachyLispStringForObject()));
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.generateTreeFromLispList_(list);
		graph.arrangeInterval_(new Jun3dPoint(10, 1, 1));
		graph.arrange2();

		Jun3dBoundingBox box = graph.boundingBox();
		final Jun3dPoint origin = (Jun3dPoint) box.origin();
		final double width = box.width();
		final double height = box.height();
		final double depth = box.depth();
		graph.nodesDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dNode node = (JunOpenGL3dNode) each;
				Jun3dPoint point = (Jun3dPoint) node.location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				node.color_(color);

				return null;
			}
		});
		graph.arcsDo_(new StBlockClosure() {
			public Object value_(Object each) {
				JunOpenGL3dArc arc = (JunOpenGL3dArc) each;
				Jun3dPoint point = (Jun3dPoint) arc.to().location().minus_(origin);
				Color color = new Color((float) (point.x() / width), (float) (point.y() / height), (float) (point.z() / depth));
				arc.color_(color);

				return null;
			}
		});
		graph.flushDisplayObject();

		JunOpenGL3dGrapher grapher = new JunOpenGL3dGrapher();
		grapher.displayObject_(graph);
		grapher.open();

		return true;
	}

	/**
	 * ExampleX:
	 * 
	 * @return boolean
	 */
	public static boolean ExampleX() {
		JunLispCons list = (JunLispCons) JunLispParser.Parse_(JunOpenGL3dGraphTestExamples._SubclassHierachyLispStringForStream());
		JunOpenGL3dGraph graph = new JunOpenGL3dGraph();
		graph.generateTreeFromLispList_(list);
		graph.arrangeInterval_(new Jun3dPoint(3, 2, 4));
		graph.arrange2();

		JunOpenGL3dGrapher grapher = new JunOpenGL3dGrapher();
		grapher.displayObject_(graph);
		grapher.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 */
	public static void main(java.lang.String[] args) {
		new JunOpenGL3dGrapherTestExamples();
	}
}
