package jp.co.sra.jun.opengl.flux;

import java.util.ArrayList;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox;
import jp.co.sra.jun.goodies.lisp.JunLispCons;
import jp.co.sra.jun.goodies.lisp.JunLispList;
import jp.co.sra.jun.goodies.lisp.JunLispParser;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunOpenGLFluxObject class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1998/11/27 (by MATSUDA Ryouichi)
 *  @updated   2004/11/12 (by Mitsuhiro Asada)
 *  @updated   2006/10/12 (by nisinaka)
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLFluxObject.java,v 8.13 2008/02/20 06:32:34 nisinaka Exp $
 */
public class JunOpenGLFluxObject extends JunOpenGLFluxAbstract {

	protected ArrayList immutableObjects;
	protected ArrayList mutableObjects;
	protected Jun3dBoundingBox boundingBox;

	/**
	 * Load a JunOpenGLFluxObject from the object.
	 * 
	 * @param anObject java.lang.Object
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxObject
	 * @category Instance creation
	 */
	public static JunOpenGLFluxObject LoadFrom_(Object anObject) {
		JunLispList aList = (JunLispList) JunLispParser.Parse_(anObject);
		if ((aList != null) && aList instanceof JunLispCons) {
			return new JunOpenGLFluxObject((JunLispCons) aList);
		} else {
			return null;
		}
	}

	/**
	 * Create a new instance of JunOpenGLFluxObject and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunOpenGLFluxObject() {
		super();
	}

	/**
	 * Create a new instance of JunOpenGLFluxObject and initialize it.
	 *
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category Instance creation
	 */
	public JunOpenGLFluxObject(JunLispList aList) {
		this();
		this.fromLispList(aList);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.opengl.flux.JunOpenGLFluxAbstract#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		immutableObjects = null;
		mutableObjects = null;
		boundingBox = null;
	}

	/**
	 * Answer my current immutable objects.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxImmutableObject[]
	 * @category accessing
	 */
	public JunOpenGLFluxImmutableObject[] immutableObjects() {
		return (JunOpenGLFluxImmutableObject[]) this._immutableObjects().toArray(new JunOpenGLFluxImmutableObject[this._immutableObjects().size()]);
	}

	/**
	 * Answer the array list of immutable objects.
	 * 
	 * @return java.util.ArrayList
	 * @category accessing
	 */
	protected ArrayList _immutableObjects() {
		if (immutableObjects == null) {
			immutableObjects = new ArrayList();
		}
		return immutableObjects;
	}

	/**
	 * Answer my current mutable objects.
	 * 
	 * @return jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject[]
	 * @category accessing
	 */
	public JunOpenGLFluxMutableObject[] mutableObjects() {
		return (JunOpenGLFluxMutableObject[]) this._mutableObjects().toArray(new JunOpenGLFluxMutableObject[this._mutableObjects().size()]);
	}

	/**
	 * Answer the array list of mutable objects.
	 * 
	 * @return java.util.ArrayList
	 * @category accessing
	 */
	protected ArrayList _mutableObjects() {
		if (mutableObjects == null) {
			mutableObjects = new ArrayList();
		}
		return mutableObjects;
	}

	/**
	 * Answer the compound object.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category accessing
	 */
	public JunOpenGL3dCompoundObject compoundObject() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		JunOpenGLFluxImmutableObject[] immutableObjects = this.immutableObjects();
		for (int i = 0; i < immutableObjects.length; i++) {
			compoundObject.add_(immutableObjects[i].compoundObject());
		}
		JunOpenGLFluxMutableObject[] mutableObjects = this.mutableObjects();
		for (int i = 0; i < mutableObjects.length; i++) {
			compoundObject.add_(mutableObjects[i].compoundObject());
		}

		return compoundObject;
	}

	/**
	 * Answer the object at normalized number.
	 * 
	 * @param normalizedNumber double
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category accessing
	 */
	public JunOpenGL3dObject at_(double normalizedNumber) {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		JunOpenGLFluxImmutableObject[] immutableObjects = this.immutableObjects();
		for (int i = 0; i < immutableObjects.length; i++) {
			JunOpenGL3dObject object = immutableObjects[i].at_(normalizedNumber);
			if (object != null) {
				compoundObject.add_(object);
			}
		}
		JunOpenGLFluxMutableObject[] mutableObjects = this.mutableObjects();
		for (int i = 0; i < mutableObjects.length; i++) {
			JunOpenGL3dObject object = mutableObjects[i].at_(normalizedNumber);
			if (object != null) {
				compoundObject.add_(object);
			}
		}

		return compoundObject;
	}

	/**
	 * Answer the number of all elements.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int size() {
		int size = 0;

		JunOpenGLFluxMutableObject[] mutableObjects = this.mutableObjects();
		if (mutableObjects.length > 0) {
			size = mutableObjects[0].size();
			for (int i = 1; i < mutableObjects.length; i++) {
				size = Math.min(size, mutableObjects[i].size());
			}
		}

		return size;
	}

	/**
	 * Answer my name.
	 * 
	 * @return java.lang.String
	 * @category accessing
	 */
	public String name() {
		return JunOpenGL3dObject.UniqueId();
	}

	/**
	 * Answer my current bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @see jp.co.sra.jun.opengl.flux.JunOpenGLFluxAbstract#boundingBox()
	 * @category bounds accessing
	 */
	public Jun3dBoundingBox boundingBox() {
		if (boundingBox == null) {
			boundingBox = this.preferredBoundingBox();
		}
		return boundingBox;
	}

	/**
	 * Answer my preferred bounding box.
	 * 
	 * @return jp.co.sra.jun.geometry.boundaries.Jun3dBoundingBox
	 * @see jp.co.sra.jun.opengl.flux.JunOpenGLFluxAbstract#preferredBoundingBox()
	 * @category bounds accessing
	 */
	public Jun3dBoundingBox preferredBoundingBox() {
		Jun3dBoundingBox aBox = null;

		JunOpenGLFluxImmutableObject[] immutableObjects = this.immutableObjects();
		for (int i = 0; i < immutableObjects.length; i++) {
			if (aBox == null) {
				aBox = immutableObjects[i].boundingBox();
			} else {
				aBox = aBox.merge_(immutableObjects[i].boundingBox());
			}
		}
		JunOpenGLFluxMutableObject[] mutableObjects = this.mutableObjects();
		for (int i = 0; i < mutableObjects.length; i++) {
			if (aBox == null) {
				aBox = mutableObjects[i].boundingBox();
			} else {
				aBox = aBox.merge_(mutableObjects[i].boundingBox());
			}
		}
		if (aBox == null) {
			aBox = Jun3dBoundingBox.Origin_corner_(new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 0, 0));
		}

		return aBox;
	}

	/**
	 * Flush my bounds.
	 * 
	 * @see jp.co.sra.jun.opengl.flux.JunOpenGLFluxAbstract#flushBounds()
	 * @category bounds accessing
	 */
	public void flushBounds() {
		boundingBox = null;
	}

	/**
	 * Add the immutable object.
	 * 
	 * @param immutableObject jp.co.sra.jun.opengl.flux.JunOpenGLFluxImmutableObject
	 * @category adding
	 */
	public void addImmutable_(JunOpenGLFluxImmutableObject immutableObject) {
		if (this._immutableObjects().contains(immutableObject) == false) {
			this._immutableObjects().add(immutableObject);
			this.flushBounds();
		}
	}

	/**
	 * Add the mutable object.
	 * 
	 * @param mutableObject jp.co.sra.jun.opengl.flux.JunOpenGLFluxMutableObject
	 * @category adding
	 */
	public void addMutable_(JunOpenGLFluxMutableObject mutableObject) {
		if (this._mutableObjects().contains(mutableObject) == false) {
			this._mutableObjects().add(mutableObject);
			this.flushBounds();
		}
	}

	/**
	 * Enumerate every points and evaluate the block.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @see jp.co.sra.jun.opengl.flux.JunOpenGLFluxAbstract#pointsDo_(jp.co.sra.smalltalk.StBlockClosure)
	 * @category enumerating
	 */
	public void pointsDo_(StBlockClosure aBlock) {
		JunOpenGLFluxImmutableObject[] immutableObjects = this.immutableObjects();
		for (int i = 0; i < immutableObjects.length; i++) {
			immutableObjects[i].pointsDo_(aBlock);
		}
		JunOpenGLFluxMutableObject[] mutableObjects = this.mutableObjects();
		for (int i = 0; i < mutableObjects.length; i++) {
			mutableObjects[i].pointsDo_(aBlock);
		}
	}

	/**
	 * Show the receiver.
	 * 
	 * @category utilities
	 */
	public void show() {
		(new JunOpenGLFluxModel(this)).open();
	}

	/**
	 * Get my attributes from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	public void fromLispList(JunLispList aList) {
		this.immutableObjectsFromLispList(aList);
		this.mutableObjectsFromLispList(aList);
	}

	/**
	 * Convert the receiver as a lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	public JunLispCons toLispList() {
		JunLispCons list = this.lispCons();
		list.head_(this.kindName());
		list.add_(this.immutableObjectsToLispList());
		list.add_(this.mutableObjectsToLispList());
		return list;
	}

	/**
	 * Get my immutable objects from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	protected void immutableObjectsFromLispList(JunLispList aList) {
		JunLispCons list = (JunLispCons) aList.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object anObject) {
				return new Boolean(anObject instanceof JunLispCons && (((JunLispCons) anObject).head() == $("immutables")));
			}
		}, new StBlockClosure());
		if (list == null) {
			return;
		}

		((JunLispList) list.tail()).do_(new StBlockClosure() {
			public Object value_(Object each) {
				addImmutable_(new JunOpenGLFluxImmutableObject((JunLispList) each));
				return null;
			}
		});
	}

	/**
	 * Convert the immutable objects as a lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	protected JunLispList immutableObjectsToLispList() {
		JunLispCons list = this.lispCons();
		list.head_($("immutables"));

		JunOpenGLFluxImmutableObject[] immutables = this.immutableObjects();
		for (int i = 0; i < immutables.length; i++) {
			list.add_(immutables[i].toLispList());
		}
		return list;
	}

	/**
	 * Get my mutable objects from the lisp list.
	 * 
	 * @param aList jp.co.sra.jun.goodies.lisp.JunLispList
	 * @category lisp support
	 */
	protected void mutableObjectsFromLispList(JunLispList aList) {
		JunLispCons list = (JunLispCons) aList.detect_ifNone_(new StBlockClosure() {
			public Object value_(Object anObject) {
				return new Boolean(anObject instanceof JunLispCons && (((JunLispCons) anObject).head() == $("mutables")));
			}
		}, new StBlockClosure());
		if (list == null) {
			return;
		}

		((JunLispList) list.tail()).do_(new StBlockClosure() {
			public Object value_(Object each) {
				addMutable_(new JunOpenGLFluxMutableObject((JunLispList) each));
				return null;
			}
		});
	}

	/**
	 * Convert the mutable objects as a lisp list.
	 * 
	 * @return jp.co.sra.jun.goodies.lisp.JunLispCons
	 * @category lisp support
	 */
	protected JunLispList mutableObjectsToLispList() {
		JunLispCons list = this.lispCons();
		list.head_($("mutables"));

		JunOpenGLFluxMutableObject[] mutables = this.mutableObjects();
		for (int i = 0; i < mutables.length; i++) {
			list.add_(mutables[i].toLispList());
		}
		return list;
	}

}
