package jp.co.sra.jun.opengl.display;

import java.lang.reflect.Method;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGLDisplayObjectsTestExamples class
 * 
 *  @author    nisinaka
 *  @created   2006/07/25 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLDisplayObjectsTestExamples.java,v 8.11 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLDisplayObjectsTestExamples extends JunTestExamples {
	/**
	 * Example:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example() {
		JunOpenGLDisplayObjects displayObjects = new JunOpenGLDisplayObjects(JunOpenGLDisplayObjects.TypicalObjectMethods());
		displayObjects.open();

		return true;
	}

	/**
	 * Example:
	 * 
	 * @return boolean
	 * @throws NoSuchMethodException 
	 * @throws SecurityException
	 * @category Examples
	 */
	public static boolean Example1() throws SecurityException, NoSuchMethodException {
		JunOpenGLDisplayObjects displayObjects = new JunOpenGLDisplayObjects(new Method[] {
				JunOpenGL3dObject.class.getDeclaredMethod("Aoki", (Class[]) null),
				JunOpenGL3dObject.class.getDeclaredMethod("Doraemon", (Class[]) null),
				JunOpenGL3dObject.class.getDeclaredMethod("Mickey", (Class[]) null),
				JunOpenGL3dObject.class.getDeclaredMethod("Pooh", (Class[]) null) });
		displayObjects.open();

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGLDisplayObjectsTestExamples();
	}
}
