package jp.co.sra.jun.opengl.display;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.TreeSet;
import jp.co.sra.smalltalk.StObject;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunOpenGLDisplayObjects class
 * 
 *  @author    nisinaka
 *  @created   2006/07/25 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun682 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLDisplayObjects.java,v 8.13 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLDisplayObjects extends JunOpenGLDisplayModel {
	protected Method[] methods;
	protected int selectionIndex;

	/**
	 * Create a new instance of JunOpenGLDisplayObjects and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunOpenGLDisplayObjects(Method[] methods) {
		this.methods_(methods);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		methods = null;
		selectionIndex = -1;
	}

	/**
	 * Answer the method at the specified index.
	 * 
	 * @param index int
	 * @return java.lang.reflect.Method
	 * @category accessing
	 */
	public Method methodAt(int index) {
		if (this.methods() == null) {
			return null;
		}

		Method[] methods = this.methods();
		if (index < 0 || methods.length <= index) {
			return null;
		}

		return methods[index];
	}

	/**
	 * Answer my current methods.
	 * 
	 * @return java.lang.reflect.Method[]
	 * @category accessing
	 */
	public Method[] methods() {
		return methods;
	}

	/**
	 * Set my new methods.
	 * 
	 * @param newMethods java.lang.reflect.Method[]
	 * @category accessing
	 */
	public void methods_(Method[] newMethods) {
		methods = newMethods;
		this.changed_($("methods"));
	}

	/**
	 * Answer my current selection index.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int selectionIndex() {
		return selectionIndex;
	}

	/**
	 * Set my new selection index.
	 * 
	 * @param index int
	 * @category accessing
	 */
	public void selectionIndex_(int index) {
		JunOpenGL3dObject aBody = null;

		Method aMethod = this.methodAt(index);
		if (aMethod != null) {
			try {
				Object anObject = aMethod.invoke(null, (Object[]) null);
				if (anObject instanceof JunOpenGL3dObject) {
					aBody = (JunOpenGL3dObject) anObject;
				} else if (anObject instanceof StObject) {
					StObject anStObject = (StObject) anObject;
					if (anStObject.respondsTo_("asJunOpenGL3dObject")) {
						aBody = (JunOpenGL3dObject) anStObject.perform_("asJunOpenGL3dObject");
					}
				}
			} catch (Exception e) {
				throw new Error(e.getMessage());
			}
		}

		this.displayObject_(aBody);
		if (aBody == null) {
			this.changed_($("object"));
		} else {
			this.resetView();
		}
	}

	/**
	 * Answer a default view.
	 * 
	 * @return jp.co.sra.smalltalk.StView
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#defaultView()
	 * @category interface opening
	 */
	public StView defaultView() {
		if (GetDefaultViewMode() == VIEW_AWT) {
			return new JunOpenGLDisplayObjectsViewAwt(this);
		} else {
			return new JunOpenGLDisplayObjectsViewSwing(this);
		}
	}

	/**
	 * Answer this window title.
	 * 
	 * @return java.lang.String
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#windowTitle()
	 * @category interface opening
	 */
	protected String windowTitle() {
		return $String("Display Objects");
	}

	/**
	 * Answer the class to spawn.
	 * 
	 * @return java.lang.Class
	 * @see jp.co.sra.jun.opengl.display.JunOpenGLDisplayModel#classToSpawn()
	 * @category private
	 */
	protected Class classToSpawn() {
		return JunOpenGLDisplayModel.class;
	}

	/**
	 * Answer the methods for creating typical objects.
	 * 
	 * @return java.lang.reflect.Method[]
	 * @category Examples
	 */
	public static Method[] TypicalObjectMethods() {
		TreeSet aTreeSet = new TreeSet(new Comparator() {
			public int compare(Object o1, Object o2) {
				return ((Method) o1).getName().compareTo(((Method) o2).getName());
			}
		});

		Class aClass = JunOpenGL3dObject.class;
		Method[] methods = aClass.getDeclaredMethods();
		for (int i = 0; i < methods.length; i++) {
			Method aMethod = methods[i];
			int modifiers = aMethod.getModifiers();
			if (Modifier.isPublic(modifiers) == false) {
				continue;
			}
			if (Modifier.isStatic(modifiers) == false) {
				continue;
			}
			if (Modifier.isFinal(modifiers) == false) {
				continue;
			}
			if (aMethod.getParameterTypes().length > 0) {
				continue;
			}
			if (aMethod.getName().startsWith("Image")) {
				continue;
			}

			aTreeSet.add(aMethod);
		}

		return (Method[]) aTreeSet.toArray(new Method[aTreeSet.size()]);
	}
}
