package jp.co.sra.jun.opengl.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.menu.StMenuBar;

import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.geometry.transformations.Jun2dTransformation;
import jp.co.sra.jun.geometry.transformations.Jun3dTransformation;
import jp.co.sra.jun.goodies.utilities.JunSensorUtility;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.texture.JunOpenGLTexture;
import jp.co.sra.jun.opengl.texture.JunOpenGLTextureTestExamples;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunOpenGLDisplayModelTestExamples class
 * 
 *  @author    he
 *  @created   1998/11/09 (by he)
 *  @updated   2004/05/18 (by nisinaka)
 *  @version   699 (with StPL8.9) based on Jun696 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunOpenGLDisplayModelTestExamples.java,v 8.18 2008/02/20 06:32:19 nisinaka Exp $
 */
public class JunOpenGLDisplayModelTestExamples extends JunTestExamples {
	/**
	 * Example1: Shows an axes.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1_Axes() {
		JunOpenGL3dObject anAxes = JunOpenGL3dObject.XyzArrows();
		anAxes = anAxes.transform_(Jun3dTransformation.Scale_(2.0));
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel(anAxes);
		displayModel.open();
		return true;
	}

	/**
	 * Example2: Shows a cube.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2_Cube() {
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
		aCube.paint_(new Color(255, 235, 215));
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel(aCube);
		displayModel.open();
		return true;
	}

	/**
	 * Example3: Shows a globe.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3_Globe() {
		JunOpenGL3dObject aGlobe = JunOpenGL3dObject.Ball();
		aGlobe.paint_(Color.blue);
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel(aGlobe);
		displayModel.open();
		return true;
	}

	/**
	 * Example8: Shows a benzene.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example8_Benzene() {
		JunOpenGL3dObject displayObject = JunOpenGL3dObject.Benzene();
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.displayObject_(displayObject);
		displayModel.viewFactor_(1.2);
		displayModel.open();

		return true;
	}

	/**
	 * ExampleA: Shows a box with a texture.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleA_Texture() {
		Image anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.linear_(true);
		aTexture.clamp_(true);
		aTexture.modulate_(true);
		aTexture.mipmap_(true);
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
		aCube.texture_(aTexture);
		aCube.name_("balloon");
		aCube.show();

		return true;
	}

	/**
	 * ExampleB: Shows a box with a texture.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleB_Texture() {
		Image anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.linear_(true);
		aTexture.repeat_(true);
		aTexture.coordinates_(new Jun2dPoint[] { new Jun2dPoint(0, 0), new Jun2dPoint(1, 0), new Jun2dPoint(1, 1), new Jun2dPoint(0, 1) });
		JunOpenGL3dObject aCube = JunOpenGL3dObject.Cube();
		aCube.texture_(aTexture);
		aCube.name_("balloon2");
		aCube.show();

		return true;
	}

	/**
	 * ExampleC: Shows a globe with a texture.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleC_Texture() {
		Image anImage = JunOpenGLTextureTestExamples.ImageSmalltalkBalloon();
		JunOpenGLTexture aTexture = new JunOpenGLTexture(anImage);
		aTexture.linear_(true);
		aTexture.repeat_(true);
		JunOpenGL3dObject aGlobe = JunOpenGL3dObject.Ball_(2);
		aGlobe.texture_(aTexture);
		aGlobe.name_("balloon3");
		aGlobe.show();

		return true;
	}

	/**
	 * ExampleD: Shows four kinds of Earth.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleD() {
		StBlockClosure aBlock = new StBlockClosure() {
			public Object value_(Object anImage) {
				Object[] xyPointsAndSphere = JunOpenGL3dObject.XyPointsAndSphere_radius_longitude_latitude_(12, 1, 360, 180);
				Vector points = (Vector) xyPointsAndSphere[0];
				Jun2dPoint[] xyPoints = new Jun2dPoint[points.size()];

				for (int index = 0; index < points.size(); index++) {
					Jun2dPoint aPoint = (Jun2dPoint) points.elementAt(index);
					xyPoints[index] = new Jun2dPoint(aPoint.x(), 1 - aPoint.y());
				}

				JunOpenGL3dCompoundObject anObject = (JunOpenGL3dCompoundObject) xyPointsAndSphere[1];
				JunOpenGLTexture aTexture = new JunOpenGLTexture((Image) anImage);
				aTexture.coordinates_(xyPoints);
				anObject.texture_(aTexture);
				anObject.name_("earth");
				anObject.show();

				return null;
			}
		};

		aBlock.value_(JunOpenGLTextureTestExamples.ImageEarth());
		aBlock.value_(JunOpenGLTextureTestExamples.ImageEarth1());
		aBlock.value_(JunOpenGLTextureTestExamples.ImageEarth2());
		aBlock.value_(JunOpenGLTextureTestExamples.ImageEarth3());

		return true;
	}

	/**
	 * ExampleG:
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean ExampleG() {
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel() {
			public StMenuBar _menuBar() {
				return null;
			}
		};
		if (JunSensorUtility.ShiftDown()) {
			displayModel.displayObject_(JunOpenGL3dObject.SoccerBall());
		} else {
			displayModel.displayObject_(JunOpenGL3dObject.Earth());
		}

		Jun3dPoint upVector = new Jun3dPoint(0, 0, 1);
		upVector = upVector.transform_(Jun3dTransformation.RotateX_(JunAngle.FromDeg_(23.5)));
		Jun2dPoint movementVector = new Jun2dPoint(1, 0);
		movementVector = movementVector.transform_(Jun2dTransformation.RotateZ_(JunAngle.FromDeg_(-23.5)));
		movementVector = movementVector.scaledBy_(0.05);

		HashMap projectionTable = new HashMap();
		projectionTable.put($("eyePoint"), new Jun3dPoint(10, 0, 0));
		projectionTable.put($("sightPoint"), new Jun3dPoint(0, 0, 0));
		projectionTable.put($("upVector"), upVector);
		projectionTable.put($("zoomHeight"), new Double(2.5));

		displayModel.defaultProjectionTable_(projectionTable);
		displayModel.openViewIn_(displayModel.defaultViewWithoutWidgets(), new Rectangle(200, 250, 300 + 8, 300 + 27));
		displayModel.windowLabel_($String("Earth"));
		//displayModel.projectionTable_(projectionTable);
		displayModel.noControl_(true);
		displayModel.movementVector_(movementVector);

		return true;
	}

	/**
	 * Example_backgroundColor: Set the background color.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_backgroundColor() {
		JunOpenGL3dObject displayObject = JunOpenGL3dObject.Benzene();
		JunOpenGLDisplayModel displayModel = new JunOpenGLDisplayModel();
		displayModel.displayObject_(displayObject);
		displayModel.viewFactor_(1.2);
		displayModel.backgroundColor_(Color.black);
		displayModel.open();

		return true;
	}

	/**
	 * Example_superimpose: Superimposing
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example_superimpose() {
		JunOpenGL3dObject aBody = JunOpenGL3dObject.Box();
		aBody.polygonsDo_(new StBlockClosure() {
			public Object value_(Object anObject) {
				JunOpenGL3dObject aPolygon = (JunOpenGL3dObject) anObject;
				aPolygon.paint_(Color.red);
				aPolygon.halftone_(0.75);
				return null;
			}
		});

		final Jun3dPoint[] modelPoints = aBody.asPointSet();

		HashMap projectionTable = new HashMap();
		projectionTable.put($("presentation"), $("hiddenlinePresentation"));
		projectionTable.put($("eyePoint"), new Jun3dPoint(9.36371, 5.75695, 4.81826));
		projectionTable.put($("upVector"), new Jun3dPoint(-0.32669, 0.85981, -0.39241));
		projectionTable.put($("sightPoint"), new Jun3dPoint(-0.10112, 0.03549, 0.16195));
		projectionTable.put($("viewFactor"), new Integer(10));
		projectionTable.put($("shading"), $("smoothShading"));
		projectionTable.put($("zoomHeight"), new Double(2.39845));

		JunOpenGLDisplayModel aModel = new JunOpenGLDisplayModel();
		aModel.displayObject_(aBody);
		aModel.defaultProjectionTable_(projectionTable);
		aModel.backgroundColor_(Color.white);
		aModel.superimposeBlock_(new StBlockClosure() {
			public Object value_value_(Object o1, Object o2) {
				Graphics aGraphics = (Graphics) o1;
				JunOpenGL3dView aView = (JunOpenGL3dView) o2;

				Map.Entry[] entries = aView.convertModelPointsToView3dPointsSortedByZ_(modelPoints);
				for (int i = 0; i < entries.length; i++) {
					double z = ((Number) entries[i].getKey()).doubleValue();
					if (z <= 0) {
						Jun3dPoint[] value = (Jun3dPoint[]) entries[i].getValue();
						Jun3dPoint modelPoint = value[0];
						Jun3dPoint viewPoint = value[1];

						Font aFont = StComposedText.DefaultFont().deriveFont(11.0f);
						StComposedText aComposedText = new StComposedText(modelPoint.printString(), aFont);
						int x = (int) Math.round(viewPoint.x());
						int y = (int) Math.round(viewPoint.y());

						aView.getOpenGL3dModel().displayComposedText_on_at_textColor_vergeColor_alignmentSymbol_(aComposedText, aGraphics, new Point(x, y), StColorValue.Black, StColorValue.VeryLightGray, $("center"));
					}
				}

				return null;
			}
		});

		aModel.openIn_(new Rectangle(200, 300, 400, 300));

		return true;
	}

	/**
	 * Execute all examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunOpenGLDisplayModelTestExamples();
	}

}
