package jp.co.sra.jun.opengl.chart;

import java.awt.Color;
import java.util.Vector;

import jp.co.sra.smalltalk.SmalltalkException;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

/**
 * JunChartWithRoundShape class
 * 
 *  @author    nisinaka
 *  @created   1999/01/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartWithRoundShape.java,v 8.12 2008/02/20 06:32:17 nisinaka Exp $
 */
public abstract class JunChartWithRoundShape extends JunChartAbstract {

	public static final double DefaultRadius = 0.5;

	protected double radius;
	protected JunOpenGL3dObject axes;

	/**
	 * Create a new instance of <code>JunChartWithRoundShape</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	protected JunChartWithRoundShape() {
		super();
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection of sample.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @category Instance creation
	 */
	protected JunChartWithRoundShape(Vector aCollectionOfSample) {
		super(aCollectionOfSample);
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection of sample and a number of keys.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @param numberOfKeys int
	 * @category Instance creation
	 */
	protected JunChartWithRoundShape(Vector aCollectionOfSample, int numberOfKeys) {
		super(aCollectionOfSample, numberOfKeys);
	}

	/**
	 * Create a new instance of a Chart and initialize it with the JunChartData.
	 * 
	 * @param aChartData jp.co.sra.jun.opengl.chart.JunChartData
	 * @category Instance creation
	 */
	protected JunChartWithRoundShape(JunChartData aChartData) {
		super(aChartData);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		radius = DefaultRadius;
		axes = null;
	}

	/**
	 * Answer the radius of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double radius() {
		return radius;
	}

	/**
	 * Set the radius of the receiver.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void radius_(double aNumber) {
		radius = aNumber;
	}

	/**
	 * Answer the axes of the receiver.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category axes accessing
	 */
	public JunOpenGL3dObject axes() {
		return axes;
	}

	/**
	 * Hide the axes.
	 * 
	 * @category axes accessing
	 */
	public void hideAxes() {
		axes = null;
		this.flushDisplayObject();
		this.changed_($("object"));
	}

	/**
	 * Show the axes.
	 * 
	 * @category axes accessing
	 */
	public void showAxes() {
		axes = this.createAxes();
		this.flushDisplayObject();
		this.changed_($("object"));
	}

	/**
	 * Show the axes with labels.
	 * 
	 * @category axes accessing
	 */
	public void showAxesWithLabels() {
		axes = new JunOpenGL3dCompoundObject(this.createAxes(), this.createAxesLabels());
		this.flushDisplayObject();
		this.changed_($("object"));
	}

	/**
	 * Show the x-axis.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#showXAxis()
	 * @category axes accessing
	 */
	public void showXAxis() {
		// Do nothing.
	}

	/**
	 * Show the x-axis with labels.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#showXAxisWithLabels()
	 * @category axes accessing
	 */
	public void showXAxisWithLabels() {
		// Do nothing.
	}

	/**
	 * Show the y-axis.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#showYAxis()
	 * @category axes accessing
	 */
	public void showYAxis() {
		// Do nothing.
	}

	/**
	 * Show the y-axis with labels.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#showYAxisWithLabels()
	 * @category axes accessing
	 */
	public void showYAxisWithLabels() {
		// Do nothing.
	}

	/**
	 * Show the z-axis.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#showZAxis()
	 * @category axes accessing
	 */
	public void showZAxis() {
		// Do nothing.
	}

	/**
	 * Answer true if the axes of the receiver exists, otherwise false.
	 * 
	 * @return boolean
	 * @category axes testing
	 */
	public boolean hasAxes() {
		return (this.axes() != null);
	}

	/**
	 * Conver the receiver as a <code>JunOpenGL3dObject</code>.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#asJunOpenGL3dObject()
	 * @category converting
	 */
	public JunOpenGL3dObject asJunOpenGL3dObject() {
		JunOpenGL3dCompoundObject chart3dObject = this.createChart3dObject();
		if (this.hasZAxis()) {
			chart3dObject.add_(this.zAxis());
		}
		if (this.hasAxes()) {
			chart3dObject.add_(this.axes());
		}
		if (this.extra3dObjects() != null) {
			chart3dObject.addAll_(this.extra3dObjects());
		}
		return chart3dObject;
	}

	/**
	 * Initialize the receiver with the attributes of the chart.
	 * 
	 * @param aChart jp.co.sra.jun.opengl.chart.JunChartWithRoundShape
	 * @category copying
	 */
	protected void _copyAttributes(JunChartWithRoundShape aChart) {
		super._copyAttributes(aChart);

		aChart.radius_(radius);
		if (this.hasAxes()) {
			aChart.showAxes();
		} else {
			aChart.hideAxes();
		}
	}

	/**
	 * Answer the default colors.
	 * 
	 * @return java.awt.Color[]
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#defaultColors()
	 * @category defaults
	 */
	protected Color[] defaultColors() {
		if (this.samples() == null) {
			return super.defaultColors();
		}

		return this.defaultColors_(this.data().sheet().rowSize());
	}

	/**
	 * Flush the cached JunOpenGL3dObjects for axes.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#flushAxes()
	 * @category flushing
	 */
	protected void flushAxes() {
		super.flushAxes();
		axes = null;
	}

	/**
	 * Create a <code>JunOpenGL3dObject</code> of axes.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category private
	 */
	protected JunOpenGL3dObject createAxes() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		compoundObject.name_("round axes");
		int numberOfAxes = this.data().sheet().rowSize();
		Jun3dPoint[] points = { new Jun3dPoint(0, 0, 0), new Jun3dPoint(0, 1, 0) };
		JunOpenGL3dCompoundObject axis = (new JunOpenGL3dPolyline(points)).asCompoundObject();
		for (int i = 0; i < numberOfAxes; i++) {
			compoundObject.add_(axis.rotatedBy_(JunAngle.FromRad_((2 * Math.PI * i) / numberOfAxes)));
		}
		compoundObject.paint_(this.axisColor());
		return compoundObject;
	}

	/**
	 * Create a <code>JunOpenGL3dObject</code> of axes labels.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category private
	 */
	protected JunOpenGL3dObject createAxesLabels() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();
		JunOpenGL3dObject standardObjects = super.createYAxisLabels();
		int numberOfAxes = this.data().sheet().rowSize();
		for (int i = 0; i < numberOfAxes; i++) {
			compoundObject.add_(standardObjects.rotatedBy_(JunAngle.FromRad_((2 * Math.PI * i) / numberOfAxes)));
		}
		compoundObject.paint_(this.axisColor());
		return compoundObject;
	}

	/**
	 * Create a <code>JunOpenGL3dObject</code> of x-axis.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws jp.co.sra.smalltalk.SmalltalkException
	 * @category private
	 */
	protected JunOpenGL3dObject createXAxis() {
		throw new SmalltalkException("should not implement");
	}

	/**
	 * Create a <code>JunOpenGL3dObject</code> of x-axis label.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws jp.co.sra.smalltalk.SmalltalkException
	 * @category private
	 */
	protected JunOpenGL3dObject createXAxisLabels() {
		throw new SmalltalkException("should not implement");
	}

	/**
	 * Create a <code>JunOpenGL3dObject</code> of y-axis.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws jp.co.sra.smalltalk.SmalltalkException
	 * @category private
	 */
	protected JunOpenGL3dObject createYAxis() {
		throw new SmalltalkException("should not implement");
	}

	/**
	 * Create a <code>JunOpenGL3dObject</code> of y-axis label.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @throws jp.co.sra.smalltalk.SmalltalkException
	 * @category private
	 */
	protected JunOpenGL3dObject createYAxisLabels() {
		throw new SmalltalkException("should not implement");
	}

}
