package jp.co.sra.jun.opengl.chart;

import java.awt.Color;
import java.awt.Point;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.geometry.basic.JunAngle;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dPolyline;

/**
 * JunChartRadar class
 * 
 *  @author    nisinaka
 *  @created   1999/01/14 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun641 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartRadar.java,v 8.12 2008/02/20 06:32:17 nisinaka Exp $
 */
public class JunChartRadar extends JunChartWithRoundShape {

	public static final double DefaultPointSize = 0.01;
	public static final double DefaultLineWidth = 1.0;

	protected double pointSize;
	protected double lineWidth;

	/**
	 * Create a new instance of JunChartRadar and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunChartRadar() {
		super();
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection of sample.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @category Instance creation
	 */
	public JunChartRadar(java.util.Vector aCollectionOfSample) {
		super(aCollectionOfSample);
	}

	/**
	 * Create a new instance of a Chart and initialize it with the collection of sample and a number of keys.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @param numberOfKeys int
	 * @category Instance creation
	 */
	public JunChartRadar(java.util.Vector aCollectionOfSample, int numberOfKeys) {
		super(aCollectionOfSample, numberOfKeys);
	}

	/**
	 * Create a new instance of a Chart and initialize it with the JunChartData.
	 * 
	 * @param aChartData jp.co.sra.jun.opengl.chart.JunChartData
	 * @category Instance creation
	 */
	public JunChartRadar(JunChartData aChartData) {
		super(aChartData);
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.opengl.chart.JunChartAbstract#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		pointSize = DefaultPointSize;
		lineWidth = DefaultLineWidth;
	}

	/**
	 * Answer the line width of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double lineWidth() {
		return lineWidth;
	}

	/**
	 * Set the line width of the receiver.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void lineWidth_(double aNumber) {
		lineWidth = aNumber;
	}

	/**
	 * Answer the point size of the receiver.
	 * 
	 * @return double
	 * @category accessing
	 */
	public double pointSize() {
		return pointSize;
	}

	/**
	 * Set the point size of the receiver.
	 * 
	 * @param aNumber double
	 * @category accessing
	 */
	public void pointSize_(double aNumber) {
		pointSize = aNumber;
	}

	/**
	 * Initialize the receiver with the attributes of the chart.
	 * 
	 * @param aChart jp.co.sra.jun.opengl.chart.JunChartRadar
	 * @category copying
	 */
	protected void _copyAttributes(JunChartRadar aChart) {
		super._copyAttributes(aChart);
		aChart.pointSize_(pointSize);
		aChart.lineWidth_(lineWidth);
	}

	/**
	 * Create a JunOpenGL3dObject which represents the chart.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category private
	 */
	protected JunOpenGL3dCompoundObject createChart3dObject() {
		JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		JunChartData myData = this.data();
		JunChartDataSheet[] sheets = myData.sheets();
		if (sheets == null) {
			return compoundObject;
		}

		for (int n = 0; n < sheets.length; n++) {
			JunChartDataSheet sheet = sheets[n];
			int rowSize = sheet.rowSize();
			double z = this.intervalBetweenCharts() * n;
			for (int j = 0; j < sheet.valueSize(); j++) {
				Jun3dPoint[] points = new Jun3dPoint[rowSize];
				Color color = this.nextColor();
				for (int i = 0; i < rowSize; i++) {
					Number value = (Number) sheet.valueAtPoint_(new Point(i, j));
					Jun3dPoint point = new Jun3dPoint(0, myData.normalizeValue_(value.doubleValue()), z);
					point = (Jun3dPoint) point.rotatedBy_(JunAngle.FromRad_((2 * Math.PI * i) / rowSize));
					points[i] = point;
					JunOpenGL3dObject vertex = this.createSmallCubeAt_(point);
					vertex.paint_(color);
					compoundObject.add_(vertex);
					this.registerVisualObject_withValue_(vertex, new Object[] { sheet.keysAtRow_(i), value });
				}
				JunOpenGL3dPolyline line = new JunOpenGL3dPolyline(points);
				line.paint_(color);
				line.lineWidth_((float) this.lineWidth());
				compoundObject.add_(line);
			}
		}

		return compoundObject;
	}

	/**
	 * Create a small cube to represents the point.
	 * 
	 * @param a3dPoint jp.co.sra.jun.geometry.basic.Jun3dPoint
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dObject
	 * @category private
	 */
	protected JunOpenGL3dObject createSmallCubeAt_(Jun3dPoint a3dPoint) {
		double size = this.pointSize();
		JunOpenGL3dObject vertex = JunOpenGL3dObject.Box_(new Jun3dPoint(size, size, size));
		vertex = vertex.translatedBy_((Jun3dPoint) a3dPoint.minus_(size / 2));
		return vertex;
	}

}
