package jp.co.sra.jun.opengl.chart;

import java.awt.Point;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.collections.sequences.JunMatrix;
import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunChartDataSheet class
 * 
 *  @author    nisinaka
 *  @created   1998/11/19 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartDataSheet.java,v 8.13 2008/02/20 06:32:17 nisinaka Exp $
 */
public class JunChartDataSheet extends JunAbstractObject {

	protected JunMatrix keyMatrix = null;
	protected JunDoubleMatrix valueMatrix = null;

	/**
	 * Create a new instance of <code>JunChartDataSheet</code> and initialize it.
	 * 
	 * @param aCollectionOfArray java.lang.Object[][]
	 * @param numberOfKeys int
	 * @category Instance creation
	 */
	public JunChartDataSheet(Object[][] aCollectionOfArray, int numberOfKeys) {
		this();
		this.sample_numberOfKeys_(aCollectionOfArray, numberOfKeys);
	}

	/**
	 * Create a new instance of <code>JunChartDataSheet</code> and initialize it.
	 * 
	 * @param aCollectionOfArray java.util.Vector
	 * @param numberOfKeys int
	 * @category Instance creation
	 */
	public JunChartDataSheet(Vector aCollectionOfArray, int numberOfKeys) {
		this();

		int size = aCollectionOfArray.size();
		Object[][] sample = new Object[size][];
		aCollectionOfArray.copyInto(sample);
		this.sample_numberOfKeys_(sample, numberOfKeys);
	}

	/**
	 * The default constructor should not be called.
	 * 
	 * @category Instance creation
	 */
	private JunChartDataSheet() {
		super();
	}

	/**
	 * Initialize the receiver with specified data.
	 * 
	 * @param aCollectionOfArray java.lang.Object[][]
	 * @param anInteger int
	 * @category initialize-release
	 */
	protected void sample_numberOfKeys_(Object[][] aCollectionOfArray, int anInteger) {
		if (aCollectionOfArray == null) {
			return;
		}

		int size = aCollectionOfArray.length;
		int maxSize = 0;
		for (int i = 0; i < size; i++) {
			maxSize = Math.max(maxSize, aCollectionOfArray[i].length);
		}
		keyMatrix = new JunMatrix(size, anInteger);
		valueMatrix = new JunDoubleMatrix(size, maxSize - anInteger);
		for (int i = 0; i < size; i++) {
			Object[] anArray = aCollectionOfArray[i];
			for (int j = 0; j < anInteger; j++) {
				keyMatrix._put(i, j, anArray[j]);
			}
			for (int j = anInteger; j < anArray.length; j++) {
				valueMatrix._put(i, j - anInteger, anArray[j]);
			}
		}
	}

	/**
	 * Answer the key object at the specified point.
	 * 
	 * @param aPoint java.awt.Point
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object keyAtPoint_(Point aPoint) {
		return keyMatrix._at(aPoint.x, aPoint.y);
	}

	/**
	 * Answer the array of key objects in the specified column.
	 * 
	 * @param anInteger int
	 * @return java.lang.Object[]
	 * @category accessing
	 */
	public Object[] keysAtColumn_(int anInteger) {
		return keyMatrix.atColumn_(anInteger);
	}

	/**
	 * Answer the array of key objects in the specified row.
	 * 
	 * @param anInteger int
	 * @return java.lang.Object[]
	 * @category accessing
	 */
	public Object[] keysAtRow_(int anInteger) {
		return keyMatrix.atRow_(anInteger);
	}

	/**
	 * Enumerate all keys and evaluate the BlockClosure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object keysDo_(StBlockClosure aBlock) {
		return keyMatrix.do_(aBlock);
	}

	/**
	 * Answer the column size of the key matrix.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int keySize() {
		return keyMatrix.columnSize();
	}

	/**
	 * Answer the row size of the value matrix.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int rowSize() {
		return valueMatrix.rowSize();
	}

	/**
	 * Answer the value object at the specified point.
	 * 
	 * @param aPoint java.awt.Point
	 * @return java.lang.Object
	 * @category accessing
	 */
	public Object valueAtPoint_(Point aPoint) {
		return valueMatrix._at(aPoint.x, aPoint.y);
	}

	/**
	 * Answer the array of value objects in the specified column.
	 * 
	 * @param anInteger int
	 * @return java.lang.Object[]
	 * @category accessing
	 */
	public Object[] valuesAtColumn_(int anInteger) {
		return valueMatrix.atColumn_(anInteger);
	}

	/**
	 * Answer the array of value objects in the specified row.
	 * 
	 * @param anInteger int
	 * @return java.lang.Object[]
	 * @category accessing
	 */
	public Object[] valuesAtRow_(int anInteger) {
		return valueMatrix.atRow_(anInteger);
	}

	/**
	 * Answer the column size of the value matrix.
	 * 
	 * @return int
	 * @category accessing
	 */
	public int valueSize() {
		return valueMatrix.columnSize();
	}

	/**
	 * Enumerate all values and evaluate the BlockClosure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public void valuesDo_(StBlockClosure aBlock) {
		valueMatrix.do_(aBlock);
	}

	/**
	 * Enumerate all values with index and evaluate the BlockClosure.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @category enumerating
	 */
	public void valuesDoIJ_(StBlockClosure aBlock) {
		valueMatrix.doIJ_(aBlock);
	}

	/**
	 * Print my string representation on the Writer.
	 * 
	 * @param aWriter java.io.Writer
	 * @throws java.io.IOException
	 * @see jp.co.sra.smalltalk.StObject#printOn_(java.io.Writer)
	 * @category printing
	 */
	public void printOn_(Writer aWriter) throws IOException {
		super.printOn_(aWriter);

		BufferedWriter bw = (aWriter instanceof BufferedWriter) ? (BufferedWriter) aWriter : new BufferedWriter(aWriter);
		bw.write('(');
		bw.newLine();
		bw.write("     keys :  ");
		keyMatrix.printOn_(bw);
		bw.newLine();
		bw.write("     values :  ");
		valueMatrix.printOn_(bw);
		bw.newLine();
		bw.write(')');
		bw.flush();
	}

}
