package jp.co.sra.jun.opengl.chart;

import java.util.Vector;

import jp.co.sra.smalltalk.StBlockClosure;

import jp.co.sra.jun.geometry.basic.Jun3dPoint;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject;
import jp.co.sra.jun.opengl.objects.JunOpenGL3dObject;

/**
 * JunChartBar class
 * 
 *  @author    nisinaka
 *  @created   1998/11/19 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun641 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunChartBar.java,v 8.12 2008/02/20 06:32:17 nisinaka Exp $
 */
public class JunChartBar extends JunChartWithSymbolicKeys {

	/**
	 * Create a new instance of JunChartBar and initialize it.
	 *
	 * @category Instance creation
	 */
	public JunChartBar() {
		super();
	}

	/**
	 * Create a new instance of JunChartBar and initialize it with the
	 * collection of sample.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @category Instance creation
	 */
	public JunChartBar(Vector aCollectionOfSample) {
		super(aCollectionOfSample);
	}

	/**
	 * Create a new instance of JunChartBar and initialize it with the
	 * collection of sample and a number of keys.
	 * 
	 * @param aCollectionOfSample java.util.Vector
	 * @param numberOfKeys int
	 * @category Instance creation
	 */
	public JunChartBar(Vector aCollectionOfSample, int numberOfKeys) {
		super(aCollectionOfSample, numberOfKeys);
	}

	/**
	 * Create a new instance of JunChartBar and initialize it with the
	 * JunChartData.
	 * 
	 * @param aChartData jp.co.sra.jun.opengl.chart.JunChartData
	 * @category Instance creation
	 */
	public JunChartBar(JunChartData aChartData) {
		super(aChartData);
	}

	/**
	 * Create a JunOpenGL3dObject which represents the JunChartBar.
	 * 
	 * @return jp.co.sra.jun.opengl.objects.JunOpenGL3dCompoundObject
	 * @category private
	 */
	protected JunOpenGL3dCompoundObject createChart3dObject() {
		final JunOpenGL3dCompoundObject compoundObject = new JunOpenGL3dCompoundObject();

		JunChartDataSheet[] sheets = this.data().sheets();
		if (sheets == null) {
			return compoundObject;
		}

		final JunChartBar self = this;
		for (int n = 0; n < sheets.length; n++) {
			JunChartDataSheet sheet = sheets[n];
			final double y = this.data().normalizeValue_(this.data().minimumOfValueRange());
			final double z = this.intervalBetweenCharts() * n;
			final double width = (1 - this.leftMargin() - this.rightMargin() - this.interval * (sheet.rowSize() - 1)) / sheet.rowSize();
			final double barWidth = width / sheet.valueSize();
			sheet.valuesDoIJ_(new StBlockClosure() {
				public Object value_value_value_(Object anObject1, Object anObject2, Object anObject3) {
					double value = ((Number) anObject1).doubleValue();
					int i = ((Number) anObject2).intValue();
					int j = ((Number) anObject3).intValue();
					double x = self.leftMargin() + ((self.interval() + width) * i) + (barWidth * j);
					Jun3dPoint origin = new Jun3dPoint(x, y, z);
					Jun3dPoint extent = new Jun3dPoint(barWidth, self.data().normalizeValue_(value), self.thickness());
					JunOpenGL3dObject bar = JunOpenGL3dObject.Origin_extent_(origin, extent);
					bar.paint_(self.nextColor());
					compoundObject.add_(bar);

					return null;
				}
			});
		}

		return compoundObject;
	}

}
