package jp.co.sra.jun.octree.basic;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.geometry.boundaries.*;
import jp.co.sra.jun.octree.nodes.*;
import jp.co.sra.smalltalk.StBlockClosure;

/**
 * Jun27Tree class
 * 
 *  @author    nisinaka
 *  @created   1999/12/28 (by nisinaka)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: Jun27Tree.java,v 8.10 2008/02/20 06:32:17 nisinaka Exp $
 */
public class Jun27Tree extends JunOctree {

	/**
	 * Create an instance of Jun27Tree and initialize it.
	 * 
	 * @param aJun3dBoundingBox jp.co.sra.jun.geometry.basic.Jun3dBoundingBox
	 * 
	 * @return jp.co.sra.jun.octree.basic.JunOctree
	 */
	public static JunOctree Bounds_(Jun3dBoundingBox aJun3dBoundingBox) {
		JunOctree octree = new Jun27Tree();
		octree.setBounds_(aJun3dBoundingBox);

		return octree;
	}

	/**
	 * Create an instance of Jun27Tree and initialize it.
	 * 
	 * @param aBlock jp.co.sra.smalltalk.StBlockClosure
	 * @param anInteger int
	 * @param aJun3dBoundingBox jp.co.sra.jun.geometry.basic.Jun3dBoundingBox
	 * 
	 * @return jp.co.sra.jun.octree.basic.JunOctree
	 */
	public static JunOctree FromBlock_depth_bounds_(StBlockClosure aBlock, int anInteger, Jun3dBoundingBox aJun3dBoundingBox) {
		JunOctree octree = Jun27Tree.Bounds_(aJun3dBoundingBox);
		octree.block_depth_(aBlock, anInteger);

		return octree;
	}

	/**
	 * Create a unit JunOctree.
	 * 
	 * @return jp.co.sra.jun.octree.basic.JunOctree
	 */
	public static JunOctree Unity() {
		return Jun27Tree.Bounds_(Jun3dBoundingBox.Origin_corner_(Jun3dPoint.Zero(), Jun3dPoint.Unity()));
	}

	/**
	 * Create a new node.
	 * 
	 * @return jp.co.sra.jun.octree.nodes.JunOctreeNode
	 */
	protected JunOctreeNode _newNode() {
		return Jun27TreeNode.Filled();
	}
}
