package jp.co.sra.jun.metaball.atoms;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.metaball.abstracts.*;
import jp.co.sra.jun.solid.abstracts.*;

/**
 * JunSolidMetaball class
 * 
 *  @author    nishihara
 *  @created   1999/11/05 (by nishihara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunSolidMetaball.java,v 8.11 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunSolidMetaball extends JunMetaball {
	public static final double defaultInsideValue = 1.0d;
	public static final double defaultOutsideValue = 0.0d;

	/** solid. */
	protected JunSolidModel solid;

	/** insideValue. */
	protected double insideValue;

	/** outsideValue. */
	protected double outsideValue;

	/**
	 * Create a new instance of JunSolidMetaball and set it with solid.
	 * 
	 * @param aJunSolid
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunSolidMetaball
	 */
	public static JunSolidMetaball On_(JunSolidModel aJunSolid) {
		JunSolidMetaball metaball = new JunSolidMetaball();
		metaball.initialize();
		metaball.solid_(aJunSolid);

		return metaball;
	}

	/**
	 * Create a new instance of JunSolidMetaball and set it with solid,
	 * insideValue and outsideValue.
	 * 
	 * @param aJunSolid
	 * @param aNumber1
	 * @param aNumber2
	 * 
	 * @return jp.co.sra.jun.metaball.atoms.JunSolidMetaball
	 */
	public static JunSolidMetaball On_insideValue_outsideValue_(JunSolidModel aJunSolid, double aNumber1, double aNumber2) {
		JunSolidMetaball metaball = JunSolidMetaball.On_(aJunSolid);
		metaball.insideValue_(aNumber1);
		metaball.outsideValue_(aNumber2);

		return metaball;
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
		insideValue = this.defaultInsideValue;
		outsideValue = this.defaultInsideValue;
	}

	/**
	 * Answer the insideValue.
	 * 
	 * @return double
	 */
	public double insideValue() {
		return this.insideValue;
	}

	/**
	 * set the insideValue.
	 * 
	 * @param aNumber
	 */
	public void insideValue_(double aNumber) {
		this.insideValue = aNumber;
	}

	/**
	 * Answer the outsideValue.
	 * 
	 * @return double
	 */
	public double outsideValue() {
		return this.outsideValue;
	}

	/**
	 * set the outsideValue.
	 * 
	 * @param aNumber
	 */
	public void outsideValue_(double aNumber) {
		this.outsideValue = aNumber;
	}

	/**
	 * answer the solid.
	 * 
	 * @return jp.co.sra.jun.solid.abstracts.aJunSolid
	 */
	public JunSolidModel solid() {
		return this.solid;
	}

	/**
	 * set the solid.
	 * 
	 * @param aJunSolid
	 */
	public void solid_(JunSolidModel aJunSolid) {
		this.solid = aJunSolid;
	}

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint
	 * @return double
	 * @see jp.co.sra.jun.metaball.abstracts.JunMetaball#valueAt_(jp.co.sra.jun.geometry.basic.Jun3dPoint)
	 * @category accessing
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		if (this.solid.containsPoint_(aJun3dPoint)) {
			return this.insideValue;
		} else {
			return this.outsideValue;
		}
	}
}
