package jp.co.sra.jun.metaball.atoms;

import jp.co.sra.jun.geometry.basic.*;
import jp.co.sra.jun.metaball.abstracts.*;
import jp.co.sra.smalltalk.*;

/**
 * JunBlockMetaball class
 * 
 *  @author    nishihara
 *  @created   1999/11/05 (by nishihara)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on JunXXX for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunBlockMetaball.java,v 8.10 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunBlockMetaball extends JunMetaball {
	/** block. */
	protected StBlockClosure block = null;

	/**
	 * Answer a value at the specified point.
	 * 
	 * @param aJun3dPoint
	 * 
	 * @return double
	 */
	public double valueAt_(Jun3dPoint aJun3dPoint) {
		return ((Number) block.value_(aJun3dPoint)).doubleValue();
	}

	/**
	 * Answer the block.
	 * 
	 * @return jp.co.sra.smalltalk.StBlockClosure
	 */
	StBlockClosure block() {
		return this.block;
	}

	/**
	 * Set the block.
	 * 
	 * @param valueBlock
	 */
	void block_(StBlockClosure valueBlock) {
		this.block = valueBlock;
	}
}
