package jp.co.sra.jun.graphics.navigator;

import java.awt.Button;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import jp.co.sra.smalltalk.StSimpleDialogViewAwt;
import jp.co.sra.smalltalk.WindowSpecLayout;

/**
 * JunFileRequesterDialogViewAwt class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2006/11/30 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun638 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunFileRequesterDialogViewAwt.java,v 8.12 2008/02/20 06:32:16 nisinaka Exp $
 */
public class JunFileRequesterDialogViewAwt extends StSimpleDialogViewAwt implements JunFileRequesterDialogView {

	protected JunFileRequesterViewAwt fileRequesterView;
	protected Button acceptButton;
	protected Button cancelButton;

	/**
	 * Create a new instance of <code>JunFileRequesterDialogViewAwt</code> and initialize it.
	 * 
	 * @param aFileRequesterDialog jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog
	 * @category Instance creation
	 */
	public JunFileRequesterDialogViewAwt(JunFileRequesterDialog aSimpleDialog) {
		super(aSimpleDialog);
	}

	/**
	 * Answer the receiver's model as <code>JunFileRequesterDialog</code>.
	 * 
	 * @return jp.co.sra.jun.graphics.navigator.JunFileRequesterDialog
	 * @see jp.co.sra.jun.graphics.navigator.JunFileRequesterDialogView#getFileRequesterDialog()
	 * @category model accessing
	 */
	public JunFileRequesterDialog getFileRequesterDialog() {
		return (JunFileRequesterDialog) this.model();
	}

	/**
	 * Build this component.
	 * 
	 * @see jp.co.sra.smalltalk.StViewPanel#buildComponent()
	 * @category interface opening
	 */
	protected void buildComponent() {
		this.setLayout(new WindowSpecLayout());
		this.add(this.fileRequesterView(), WindowSpecLayout.Position(0f, 1, 0f, 1, 1f, -1, 1f, -40));
		this.add(this.acceptButton(), WindowSpecLayout.Position(0.33f, -45, 1f, -35, 0.33f, 45, 1f, -5));
		this.add(this.cancelButton(), WindowSpecLayout.Position(0.67f, -45, 1f, -35, 0.67f, 45, 1f, -5));
		this.setSize(540, 300);

		defaultButton = this.acceptButton();
	}

	/**
	 * Answer my file requester view.
	 * 
	 * @return jp.co.sra.jun.graphics.navigator.JunFileRequesterViewAwt
	 * @category user interface
	 */
	protected JunFileRequesterViewAwt fileRequesterView() {
		if (fileRequesterView == null) {
			fileRequesterView = new JunFileRequesterViewAwt(this.getFileRequesterDialog().fileModel());
		}
		return fileRequesterView;
	}

	/**
	 * Answer my accept button.
	 *
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button acceptButton() {
		if (acceptButton == null) {
			acceptButton = new Button($String("Accept"));
			acceptButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunFileRequesterDialogViewAwt.this.getFileRequesterDialog().acceptButtonPressed()) {
						JunFileRequesterDialogViewAwt.this.getFileRequesterDialog().accept().value_(true);
					}
				}
			});
		}
		return acceptButton;
	}

	/**
	 * Answer my cancel button.
	 *
	 * @return java.awt.Button
	 * @category user interface
	 */
	protected Button cancelButton() {
		if (cancelButton == null) {
			cancelButton = new Button($String("Cancel"));
			cancelButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					if (JunFileRequesterDialogViewAwt.this.getFileRequesterDialog().cancelButtonPressed()) {
						JunFileRequesterDialogViewAwt.this.getFileRequesterDialog().cancel().value_(true);
					}
				}
			});
		}
		return cancelButton;
	}

	/**
	 * Set up the keyboard for the view on the window.
	 * 
	 * @param aWindow java.awt.Window
	 * @see jp.co.sra.smalltalk.StView#_setupKeyboard(java.awt.Window)
	 * @category keyboard
	 */
	public void _setupKeyboard(Window aWindow) {
		this.fileRequesterView()._setupKeyboard(aWindow);
	}

}
