package jp.co.sra.jun.graphics.item;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StComposedText;
import jp.co.sra.smalltalk.StImage;

import jp.co.sra.jun.graphics.abstracts.JunAbstractItem;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunCompositeItemTestExamples class
 * 
 *  @author    Ryouichi Matsuda
 *  @created   2003/12/19 (by Ryouichi Matsuda)
 *  @updated   2006/11/22 (by m-asada)
 *  @version   699 (with StPL8.9) based on Jun637 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunCompositeItemTestExamples.java,v 8.9 2008/02/20 06:32:15 nisinaka Exp $
 */
public class JunCompositeItemTestExamples extends JunTestExamples {
	/**
	 * Test example #1.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		final JunCompositeItem aCompositeItem = new JunCompositeItem(new Point(20, 10), new Point(200, 100));
		JunPrimitiveItem aPrimitiveItem = new JunPrimitiveItem(new Point(20, 10), new Point(120, 50), StImage._OfArea(new Rectangle(0, 0, 100, 100)));
		aCompositeItem.add_(aPrimitiveItem);

		Frame f = new Frame();
		f.add(new Canvas() {
			public void paint(Graphics g) {
				aCompositeItem.displayOn_(g);
			}
		});
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		f.setBounds(200, 200, 300, 300);
		f.setVisible(true);

		return true;
	}

	/**
	 * Test example #2.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		final JunCompositeItem aCompositeItem = new JunCompositeItem(new Point(20, 10), new Point(200, 100));
		aCompositeItem.borderWidth_(1);
		aCompositeItem.borderColor_(Color.magenta);
		aCompositeItem.emphasisState_(false);
		JunPrimitiveItem aPrimitiveItem = new JunPrimitiveItem(new Point(20, 10), new Point(120, 50), StImage._OfArea(new Rectangle(0, 0, 70, 100)));
		aPrimitiveItem.borderWidth_(1);
		aPrimitiveItem.borderColor_(Color.red);
		aPrimitiveItem.emphasisState_(true);
		aCompositeItem.add_(aPrimitiveItem);

		Frame f = new Frame();
		f.add(new Canvas() {
			public void paint(Graphics g) {
				aCompositeItem.displayOn_(g);
			}
		});
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		f.setBounds(200, 200, 300, 300);
		f.setVisible(true);

		return true;
	}

	/**
	 * Test example #3.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		final JunCompositeItem aCompositeItem = new JunCompositeItem(new Point(20, 10), new Point(200, 100));
		aCompositeItem.borderWidth_(1);
		aCompositeItem.borderColor_(Color.magenta);
		aCompositeItem.emphasisState_(false);
		JunPrimitiveItem aPrimitiveItem = new JunPrimitiveItem(new Point(20, 10), new Point(120, 50), new StComposedText("Jun"));
		aPrimitiveItem.borderWidth_(1);
		aPrimitiveItem.borderColor_(Color.red);
		aPrimitiveItem.emphasisState_(true);
		aCompositeItem.add_(aPrimitiveItem);

		Frame f = new Frame();
		f.add(new Canvas() {
			public void paint(Graphics g) {
				aCompositeItem.displayOn_(g);
			}
		});
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		f.setBounds(200, 200, 300, 300);
		f.setVisible(true);

		return true;
	}

	/**
	 * Test example #4.
	 * 
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		final JunCompositeItem aCompositeItem = new JunCompositeItem(new Point(20, 10), new Point(200, 100));
		aCompositeItem.borderWidth_(1);
		aCompositeItem.borderColor_(Color.magenta);
		aCompositeItem.emphasisState_(false);
		JunPrimitiveItem anIconItem = JunPrimitiveItemTestExamples.ExampleIconItem();
		anIconItem.borderWidth_(1);
		JunPrimitiveItem aTextItem = JunPrimitiveItemTestExamples.ExampleTextItem();
		aTextItem.borderWidth_(1);
		JunPrimitiveItem anImageItem = JunPrimitiveItemTestExamples.ExampleImageItem();
		anImageItem.borderWidth_(1);
		JunCompositeItem anExampleItem = JunCompositeItemTestExamples.ExampleCompositeItem();
		aCompositeItem.add_alignment_(anIconItem, $("leftCenter"));
		aCompositeItem.add_alignment_with_alignment_offset_(aTextItem, $("leftCenter"), anIconItem, $("rightCenter"), new Point(2, 0));
		aCompositeItem.add_alignment_offset_(anImageItem, $("rightCenter"), new Point(-2, 0));
		aCompositeItem.add_alignment_(anExampleItem, $("topLeft"));
		aCompositeItem.withAllItemsDo_(new StBlockClosure() {
			public Object value_(Object o) {
				JunAbstractItem item = (JunAbstractItem) o;
				item.borderWidth_(3);
				return null;
			}
		});

		Frame f = new Frame();
		f.add(new Canvas() {
			public void paint(Graphics g) {
				aCompositeItem.displayOn_(g);
			}
		});
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				e.getWindow().dispose();
			}
		});
		f.setBounds(200, 200, 300, 300);
		f.setVisible(true);

		return true;
	}

	/**
	 * ExampleCompositeItem
	 * 
	 * @return JunCompositeItem
	 * @category Examples
	 */
	public static JunCompositeItem ExampleCompositeItem() {
		JunCompositeItem aCompositeItem = new JunCompositeItem(new Point(20, 10), new Point(200, 30));
		aCompositeItem.borderWidth_(1);
		aCompositeItem.borderColor_(Color.magenta);
		aCompositeItem.emphasisState_(false);
		JunPrimitiveItem anIconItem = JunPrimitiveItemTestExamples.ExampleIconItem();
		JunPrimitiveItem aTextItem = JunPrimitiveItemTestExamples.ExampleTextItem();
		JunPrimitiveItem anImageItem = JunPrimitiveItemTestExamples.ExampleImageItem();
		aCompositeItem.add_alignment_(anIconItem, $("leftCenter"));
		aCompositeItem.add_alignment_with_alignment_offset_(aTextItem, $("leftCenter"), anIconItem, $("rightCenter"), new Point(2, 0));
		aCompositeItem.add_alignment_(anImageItem, $("rightCenter"));
		aCompositeItem.allItemsDo_(new StBlockClosure() {
			public Object value_(Object o) {
				JunAbstractItem item = (JunAbstractItem) o;
				item.borderWidth_(0);
				return null;
			}
		});
		return aCompositeItem;
	}

	/**
	 * Execure the example launcher.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunCompositeItemTestExamples();
	}
}
