package jp.co.sra.jun.goodies.wheels;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import jp.co.sra.smalltalk.StView;
import jp.co.sra.jun.goodies.cursors.JunCursors;
import jp.co.sra.jun.system.framework.JunAbstractController;

/**
 * JunThumbWheelController class
 * 
 *  @author    MATSUDA Ryouichi
 *  @created   1999/12/17 (by MATSUDA Ryouichi)
 *  @updated   2000/11/16 (by Mitsuhiro Asada)
 *  @updated   2004/09/21 (by nisinaka)
 *  @updated   2007/03/13 (by Mitsuhiro Asada)
 *  @version   699 (with StPL8.9) based on Jun651 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunThumbWheelController.java,v 8.12 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunThumbWheelController extends JunAbstractController implements MouseListener, MouseMotionListener, MouseWheelListener {
	protected Point previousPoint;

	/**
	 * Invoked when the mouse enters the view.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mouseEntered(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseMoved(MouseEvent event) {
		if (this.getView().thumbWheelArea().contains(event.getPoint())) {
			if (this.getModel().verticalFlag()) {
				this.view().toComponent().setCursor(JunCursors.UpDownCursor());
			} else {
				this.view().toComponent().setCursor(JunCursors.BetweenCursor());
			}
		} else {
			this.view().toComponent().setCursor(Cursor.getDefaultCursor());
		}
	}

	/**
	 * Invoked when the mouse button has been pressed.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mousePressed(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mousePressed(MouseEvent event) {
		previousPoint = event.getPoint();
	}

	/**
	 * Invoked when a mouse button has been released. cursor reset to default.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mouseReleased(java.awt.event.MouseEvent)
	 * @category mouse events
	 */
	public void mouseReleased(MouseEvent event) {
		if (previousPoint != null) {
			this.view().toComponent().setCursor(Cursor.getDefaultCursor());
			previousPoint = null;
		}
	}

	/**
	 * General dragging action.
	 * 
	 * @param event java.awt.event.MouseEvent
	 * @see jp.co.sra.smalltalk.StController#mouseDragged(java.awt.event.MouseEvent)
	 * @category mouse motion events
	 */
	public void mouseDragged(MouseEvent event) {
		if (previousPoint != null) {
			Point currentPoint = event.getPoint();

			if (currentPoint.equals(previousPoint) == false) {
				this.getView().rotateDelta_(new Point(currentPoint.x - previousPoint.x, currentPoint.y - previousPoint.y));
				previousPoint = currentPoint;
			}
		}
	}

	/**
	 * Invoked when the mouse wheel is rotated.
	 * 
	 * @param event java.awt.event.MouseWheelEvent
	 * @see java.awt.event.MouseWheelListener#mouseWheelMoved(java.awt.event.MouseWheelEvent)
	 * @category mouse wheel events
	 */
	public void mouseWheelMoved(MouseWheelEvent event) {
		Rectangle wheelArea = this.getView().thumbWheelArea();
		if (wheelArea.contains(this.cursorPoint()) == false) {
			return;
		}
		int aValue = event.isAltDown() ? 1 : 5;
		Point aPoint;
		if (this.getModel().verticalFlag()) {
			if (event.getWheelRotation() < 0) {
				aPoint = new Point(0, -aValue);
			} else {
				aPoint = new Point(0, aValue);
			}
		} else {
			if (event.getWheelRotation() < 0) {
				aPoint = new Point(-aValue, 0);
			} else {
				aPoint = new Point(aValue, 0);
			}
		}
		this.getView().rotateDelta_(aPoint);
	}

	/**
	 * Add listeners.
	 * 
	 * @param newView sra.mvctest.StView
	 * @see jp.co.sra.smalltalk.StController#buildListener(jp.co.sra.smalltalk.StView)
	 * @category initialize-release
	 */
	protected void buildListener(StView newView) {
		final Component aView = (Component) newView;
		aView.addMouseListener(this);
		aView.addMouseMotionListener(this);
		aView.addMouseWheelListener(this);
	}

	/**
	 * Answer the receiver's model as JunThumbWheel.
	 * 
	 * @return jp.co.sra.jun.goodies.wheels.JunThumbWheel
	 * @category model accessing
	 */
	protected JunThumbWheel getModel() {
		return (JunThumbWheel) this.model();
	}

	/**
	 * Answer the receiver's view as JunThumbWheelView.
	 * 
	 * @return jp.co.sra.jun.goodies.wheels.JunThumbWheelView interface
	 * @category view accessing
	 */
	protected JunThumbWheelView getView() {
		return (JunThumbWheelView) this.view();
	}
}
