package jp.co.sra.jun.goodies.wavelet;

import jp.co.sra.jun.system.framework.JunAbstractObject;

/**
 * JunWaveletTransformation class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/05/07 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun697 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunWaveletTransformation.java,v 8.7 2008/02/20 06:32:14 nisinaka Exp $
 */
public abstract class JunWaveletTransformation extends JunAbstractObject {

	/**
	 * Create a new instance of <code>JunWaveletTransformation</code> and initialize it.
	 * 
	 * @category Instance creation
	 */
	public JunWaveletTransformation() {
		super();
	}

	/**
	 * Initialize the receiver.
	 * 
	 * @see jp.co.sra.jun.system.framework.JunAbstractObject#initialize()
	 * @category initialize-release
	 */
	protected void initialize() {
		super.initialize();
	}

	/**
	 * Apply the specified object to the receiver.
	 * 
	 * @param anObject java.lang.Object
	 * @return jp.co.sra.jun.goodies.wavelet.JunWaveletTransformation
	 * @category applying transformation
	 */
	public abstract JunWaveletTransformation applyTo_(Object anObject);

	/**
	 * Apply a transformation 'waveletTransformation' to the receiver.
	 * 
	 * @param waveletTransformation jp.co.sra.jun.goodies.wavelet.JunWaveletTransformation
	 * @return jp.co.sra.jun.goodies.wavelet.JunWaveletTransformation
	 * @category applying transformation
	 */
	public abstract JunWaveletTransformation transform_(JunWaveletTransformation waveletTransformation);
}
