package jp.co.sra.jun.goodies.wavelet;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

import jp.co.sra.smalltalk.StBlockClosure;
import jp.co.sra.smalltalk.StColorValue;
import jp.co.sra.smalltalk.StImage;
import jp.co.sra.smalltalk.StValueHolder;

import jp.co.sra.jun.collections.sequences.JunDoubleMatrix;
import jp.co.sra.jun.geometry.abstracts.JunGeometry;
import jp.co.sra.jun.geometry.basic.Jun2dPoint;
import jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel;
import jp.co.sra.jun.goodies.image.streams.JunImageStream;
import jp.co.sra.jun.goodies.image.support.JunImageAdjuster;
import jp.co.sra.jun.system.support.JunTestExamples;

/**
 * JunDiscreteWavelet2dTransformationTestExamples class
 * 
 *  @author    Mitsuhiro Asada
 *  @created   2007/05/08 (by m-asada)
 *  @updated   N/A
 *  @version   699 (with StPL8.9) based on Jun660 for Smalltalk
 *  @copyright 1999-2008 SRA (Software Research Associates, Inc.)
 *  @copyright 1999-2005 Information-technology Promotion Agency, Japan (IPA)
 *  @copyright 2001-2008 SRA/KTL (SRA Key Technology Laboratory, Inc.)
 * 
 * $Id: JunDiscreteWavelet2dTransformationTestExamples.java,v 8.6 2008/02/20 06:32:14 nisinaka Exp $
 */
public class JunDiscreteWavelet2dTransformationTestExamples extends JunTestExamples {
	/**
	 * Example1:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example1() {
		JunDiscreteWavelet2dTransformation waveletTransformation = new JunDiscreteWavelet2dTransformation(JunDiscreteWavelet2dTransformationTestExamples.ExampleData());
		waveletTransformation.scalingCoefficients();
		waveletTransformation.waveletCoefficients();
		waveletTransformation.recomposedCoefficients();

		return true;
	}

	/**
	 * Example2:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example2() {
		JunDiscreteWavelet2dTransformation waveletTransformation = new JunDiscreteWavelet2dTransformation(JunDiscreteWavelet2dTransformationTestExamples.ExampleData());
		Point scaleFactor = new Point(5, 5);
		Jun2dPoint displayPoint = new Jun2dPoint(100, 250);
		Jun2dPoint offsetPoint = new Jun2dPoint(25, 25);
		Collection aCollection = new ArrayList();
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.sourceCoefficients(), scaleFactor, "Source Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(0))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.scalingCoefficients(), scaleFactor, "Scaling Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(1))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.horizontalWaveletCoefficients(), scaleFactor, "Horizontal Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(2))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.verticalWaveletCoefficients(), scaleFactor, "Vertical Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(3))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.diagonalWaveletCoefficients(), scaleFactor, "Diagonal Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(4))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.recomposedCoefficients(), scaleFactor, "Recomposed Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(5))._toPoint()));

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(aCollection);
		}

		return true;
	}

	/**
	 * Example3:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example3() {
		JunDiscreteWavelet2dTransformation waveletTransformation = new JunDiscreteWavelet2dTransformation(JunDiscreteWavelet2dTransformationTestExamples.ExampleData());
		Point scaleFactor = new Point(5, 5);
		Jun2dPoint displayPoint = new Jun2dPoint(100, 250);
		Jun2dPoint offsetPoint = new Jun2dPoint(25, 25);
		Collection aCollection = new ArrayList();
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.sourceCoefficients(), scaleFactor, "Source Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(0))._toPoint()));
		waveletTransformation = new JunDiscreteWavelet2dTransformation(waveletTransformation.scalingCoefficients(), waveletTransformation.waveletCoefficients());
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.scalingCoefficients(), scaleFactor, "Scaling Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(1))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.horizontalWaveletCoefficients(), scaleFactor, "Horizontal Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(2))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.verticalWaveletCoefficients(), scaleFactor, "Vertical Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(3))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.diagonalWaveletCoefficients(), scaleFactor, "Diagonal Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(4))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.recomposedCoefficients(), scaleFactor, "Recomposed Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(5))._toPoint()));

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(aCollection);
		}

		return true;
	}

	/**
	 * Example4:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example4() {
		JunDiscreteWavelet2dTransformation waveletTransformation = new JunDiscreteWavelet2dTransformation(JunDiscreteWavelet2dTransformationTestExamples.ExampleData());
		Point scaleFactor = new Point(5, 5);
		Jun2dPoint displayPoint = new Jun2dPoint(100, 250);
		Jun2dPoint offsetPoint = new Jun2dPoint(25, 25);
		Collection aCollection = new ArrayList();
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.sourceCoefficients(), scaleFactor, "Source Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(0))._toPoint()));

		JunDoubleMatrix sourceCoefficients = waveletTransformation.sourceCoefficients();
		JunDoubleMatrix scalingCoefficients = waveletTransformation.scalingCoefficients();
		JunDoubleMatrix[] waveletCoefficients = waveletTransformation.waveletCoefficients();
		double[] absCoefficients = new double[waveletCoefficients[0].size() * 3];
		for (int i = 0; i < waveletCoefficients.length; i++) {
			JunDoubleMatrix matrix = waveletCoefficients[i];
			for (int j = 0; j < matrix.size(); j++) {
				absCoefficients[i * matrix.size() + j] = Math.abs(((Double) matrix.at_(j)).doubleValue());
			}
		}
		Arrays.sort(absCoefficients);
		for (int i = 0; i < absCoefficients.length / 2; i++) {
			double v1 = absCoefficients[i];
			double v2 = absCoefficients[absCoefficients.length - 1 - i];
			absCoefficients[i] = v2;
			absCoefficients[absCoefficients.length - 1 - i] = v1;
		}
		int highPercentage = 23;
		double thresholdValue = absCoefficients[(int) Math.round(absCoefficients.length * (highPercentage / 100.0)) - 1];
		int numberOfCoefficients = 0;
		for (int k = 0; k < waveletCoefficients.length; k++) {
			JunDoubleMatrix matrix = waveletCoefficients[k];

			int rowSize = matrix.rowSize();
			int columnSize = matrix.columnSize();
			for (int i = 0; i < rowSize; i++) {
				for (int j = 0; j < columnSize; j++) {
					if (Math.abs(matrix._doubleValueAt(i, j)) >= thresholdValue) {
						numberOfCoefficients = numberOfCoefficients + 1;
					} else {
						matrix.row_column_put_(i, j, 0.0);
					}
				}
			}
		}

		{
			int d = sourceCoefficients.size();
			int n = scalingCoefficients.size() + numberOfCoefficients;
			System.out.println("compressed " + d + " into " + n + " (" + (n / ((double) d) * 100) + "%)");
		}

		waveletTransformation = new JunDiscreteWavelet2dTransformation(waveletTransformation.scalingCoefficients(), waveletTransformation.waveletCoefficients());
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.scalingCoefficients(), scaleFactor, "Scaling Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(1))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.horizontalWaveletCoefficients(), scaleFactor, "Horizontal Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(2))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.verticalWaveletCoefficients(), scaleFactor, "Vertical Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(3))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.diagonalWaveletCoefficients(), scaleFactor, "Diagonal Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(4))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.recomposedCoefficients(), scaleFactor, "Recomposed Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(5))._toPoint()));

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(aCollection);
		}

		return true;
	}

	/**
	 * Example5:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example5() {
		JunDiscreteWavelet2dTransformation waveletTransformation = new JunDiscreteWavelet2dTransformation(JunDiscreteWavelet2dTransformationTestExamples.ExampleMatrix());
		Point scaleFactor = new Point(1, 1);
		Jun2dPoint displayPoint = new Jun2dPoint(100, 250);
		Jun2dPoint offsetPoint = new Jun2dPoint(25, 25);
		Collection aCollection = new ArrayList();
		aCollection.add(ExampleDisplay_scaleFactor_asImage_labelString_displayPoint_(waveletTransformation.sourceCoefficients(), scaleFactor, true, "Source Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(0))._toPoint()));
		waveletTransformation = new JunDiscreteWavelet2dTransformation(waveletTransformation.scalingCoefficients(), waveletTransformation.waveletCoefficients());
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.scalingCoefficients(), scaleFactor, "Scaling Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(1))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.horizontalWaveletCoefficients(), scaleFactor, "Horizontal Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(2))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.verticalWaveletCoefficients(), scaleFactor, "Vertical Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(3))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.diagonalWaveletCoefficients(), scaleFactor, "Diagonal Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(4))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_asImage_labelString_displayPoint_(waveletTransformation.recomposedCoefficients(), scaleFactor, true, "Recomposed Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(5))._toPoint()));

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(aCollection);
		}

		return true;
	}

	/**
	 * Example6:
	 *  
	 * @return boolean
	 * @category Examples
	 */
	public static boolean Example6() {
		JunDiscreteWavelet2dTransformation waveletTransformation = new JunDiscreteWavelet2dTransformation(JunDiscreteWavelet2dTransformationTestExamples.ExampleMatrix());
		Point scaleFactor = new Point(1, 1);
		Jun2dPoint displayPoint = new Jun2dPoint(100, 250);
		Jun2dPoint offsetPoint = new Jun2dPoint(25, 25);
		Collection aCollection = new ArrayList();
		aCollection.add(ExampleDisplay_scaleFactor_asImage_labelString_displayPoint_(waveletTransformation.sourceCoefficients(), scaleFactor, true, "Source Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(0))._toPoint()));

		JunDoubleMatrix sourceCoefficients = waveletTransformation.sourceCoefficients();
		JunDoubleMatrix scalingCoefficients = waveletTransformation.scalingCoefficients();
		JunDoubleMatrix[] waveletCoefficients = waveletTransformation.waveletCoefficients();
		double[] absCoefficients = new double[waveletCoefficients[0].size() * 3];
		for (int i = 0; i < waveletCoefficients.length; i++) {
			JunDoubleMatrix matrix = waveletCoefficients[i];
			for (int j = 0; j < matrix.size(); j++) {
				absCoefficients[i * matrix.size() + j] = Math.abs(((Double) matrix.at_(j)).doubleValue());
			}
		}
		Arrays.sort(absCoefficients);
		for (int i = 0; i < absCoefficients.length / 2; i++) {
			double v1 = absCoefficients[i];
			double v2 = absCoefficients[absCoefficients.length - 1 - i];
			absCoefficients[i] = v2;
			absCoefficients[absCoefficients.length - 1 - i] = v1;
		}
		int highPercentage = 15;
		double thresholdValue = absCoefficients[(int) Math.round(absCoefficients.length * (highPercentage / 100.0)) - 1];
		int numberOfCoefficients = 0;
		for (int k = 0; k < waveletCoefficients.length; k++) {
			JunDoubleMatrix matrix = waveletCoefficients[k];

			int rowSize = matrix.rowSize();
			int columnSize = matrix.columnSize();
			for (int i = 0; i < rowSize; i++) {
				for (int j = 0; j < columnSize; j++) {
					if (Math.abs(matrix._doubleValueAt(i, j)) >= thresholdValue) {
						numberOfCoefficients = numberOfCoefficients + 1;
					} else {
						matrix.row_column_put_(i, j, 0.0);
					}
				}
			}
		}

		{
			int d = sourceCoefficients.size();
			int n = scalingCoefficients.size() + numberOfCoefficients;
			System.out.println("compressed " + d + " into " + n + " (" + (n / ((double) d) * 100) + "%)");
		}

		waveletTransformation = new JunDiscreteWavelet2dTransformation(waveletTransformation.scalingCoefficients(), waveletTransformation.waveletCoefficients());
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.scalingCoefficients(), scaleFactor, "Scaling Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(1))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.horizontalWaveletCoefficients(), scaleFactor, "Horizontal Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(2))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.verticalWaveletCoefficients(), scaleFactor, "Vertical Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(3))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_labelString_displayPoint_(waveletTransformation.diagonalWaveletCoefficients(), scaleFactor, "Diagonal Wavelet Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(4))._toPoint()));
		aCollection.add(ExampleDisplay_scaleFactor_asImage_labelString_displayPoint_(waveletTransformation.recomposedCoefficients(), scaleFactor, true, "Recomposed Coefficients", displayPoint.plus_(offsetPoint.multipliedBy_(5))._toPoint()));

		JunImageDisplayModel[] models = (JunImageDisplayModel[]) aCollection.toArray(new JunImageDisplayModel[aCollection.size()]);
		for (int i = 0; i < models.length; i++) {
			models[i].closeTogether_(aCollection);
		}

		return true;
	}

	/**
	 * Example: Answer the example data.
	 *  
	 * @return jp.co.sra.jun.collections.sequences.JunDoubleMatrix
	 * @category Examples
	 */
	protected static JunDoubleMatrix ExampleData() {
		int size = 64;
		JunDoubleMatrix aMatrix = new JunDoubleMatrix(size, size);
		aMatrix.atAllPut_(0.2d);
		for (int index = 5; index < size - 5; index++) {
			aMatrix.atPoint_put_(new Point(5, index), 1.0);
			aMatrix.atPoint_put_(new Point(size - 6, index), 1.0);
			aMatrix.atPoint_put_(new Point(index, 5), 1.0);
			aMatrix.atPoint_put_(new Point(index, size - 6), 1.0);
			aMatrix.atPoint_put_(new Point(index, index), 1.0);
			aMatrix.atPoint_put_(new Point(index, size - index - 1), 1.0);
		}
		return aMatrix;
	}

	/**
	 * Example: Open an image display model with the specified wavelet transformation.
	 * 
	 * @param dataMatrix jp.co.sra.jun.collections.sequences.JunDoubleMatrix
	 * @param scaleFactor java.awt.Point
	 * @param aBoolean boolean
	 * @param labelString java.lang.String
	 * @param displayPoint java.awt.Point
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Examples
	 */
	protected static JunImageDisplayModel ExampleDisplay_scaleFactor_asImage_labelString_displayPoint_(JunDoubleMatrix dataMatrix, final Point scaleFactor, boolean aBoolean, String labelString, Point displayPoint) {
		StImage anImage = null;
		if (aBoolean) {
			anImage = dataMatrix.asImage();
			if (scaleFactor == new Point(1, 1)) {
				anImage = JunImageAdjuster.Adjust_extent_(anImage, new Dimension(anImage.width() * scaleFactor.x, anImage.height() * scaleFactor.y));
			}
		} else {
			final StValueHolder maxValueHolder = new StValueHolder(null);
			dataMatrix.do_(new StBlockClosure() {
				public Object value_(Object value) {
					if (maxValueHolder.value() == null) {
						maxValueHolder.value_(Math.abs(((Number) value).doubleValue()));
					} else {
						maxValueHolder.value_(Math.max(((Number) value).doubleValue(), maxValueHolder._doubleValue()));
					}
					return null;
				}
			});
			final JunDoubleMatrix aMatrix = new JunDoubleMatrix(dataMatrix.rowSize(), dataMatrix.columnSize());
			dataMatrix.doIJ_(new StBlockClosure() {
				public Object value_value_value_(Object value, Object i, Object j) {
					double v;
					if (Math.abs(maxValueHolder._doubleValue()) < JunGeometry.Accuracy()) {
						v = 0.0d;
					} else {
						v = Math.abs(((Number) value).doubleValue()) / maxValueHolder._doubleValue();
					}
					aMatrix.row_column_put_(((Number) i).intValue(), ((Number) j).intValue(), v);
					return null;
				}
			});

			anImage = new StImage(new Jun2dPoint(aMatrix.rowSize(), aMatrix.columnSize()).scaledBy_(new Jun2dPoint(scaleFactor)).rounded()._toPoint());
			final Graphics2D graphicsContext = (Graphics2D) anImage.image().getGraphics();
			try {
				aMatrix.doIJ_(new StBlockClosure() {
					public Object value_value_value_(Object v, Object i, Object j) {
						Color color = StColorValue.Brightness_(Math.max(0, Math.min(((Number) v).doubleValue(), 1)));
						Jun2dPoint p = new Jun2dPoint(((Number) i).intValue(), ((Number) j).intValue()).scaledBy_(new Jun2dPoint(scaleFactor)).rounded();
						Rectangle box = new Rectangle((int) p.x(), (int) p.y(), scaleFactor.x, scaleFactor.y);
						graphicsContext.setColor(color);
						graphicsContext.fill(box);
						return null;
					}
				});
			} finally {
				if (graphicsContext != null) {
					graphicsContext.dispose();
				}
			}
		}
		return JunImageDisplayModel.Show_label_at_(anImage, labelString, displayPoint);
	}

	/**
	 * Example: Open an image display model with the specified wavelet transformation.
	 * 
	 * @param dataMatrix jp.co.sra.jun.collections.sequences.JunDoubleMatrix
	 * @param scaleFactor java.awt.Point
	 * @param labelString java.lang.String
	 * @param displayPoint java.awt.Point
	 * @return jp.co.sra.jun.goodies.image.framework.JunImageDisplayModel
	 * @category Examples
	 */
	protected static JunImageDisplayModel ExampleDisplay_scaleFactor_labelString_displayPoint_(JunDoubleMatrix dataMatrix, Point scaleFactor, String labelString, Point displayPoint) {
		return ExampleDisplay_scaleFactor_asImage_labelString_displayPoint_(dataMatrix, scaleFactor, false, labelString, displayPoint);
	}

	/**
	 * Example: Answer the example data.
	 *  
	 * @return jp.co.sra.jun.collections.sequences.JunDoubleMatrix
	 * @category Examples
	 */
	protected static JunDoubleMatrix ExampleMatrix() {
		StImage anImage = JunImageStream.ImageSmalltalkBalloon256x256();
		JunDoubleMatrix aMatrix = new JunDoubleMatrix(anImage);
		return aMatrix;
	}

	/**
	 * Execute all test examples.
	 * 
	 * @param args java.lang.String[]
	 * @category Main
	 */
	public static void main(String[] args) {
		new JunDiscreteWavelet2dTransformationTestExamples();
	}
}
